/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std;

import com.sun.jsfcl.std.RaveStringCustomEditor;
import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class RaveStringEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static boolean useRaw = Boolean.getBoolean("netbeans.stringEditor.useRawCharacters");
    private boolean editable = true;
    protected String instructions = null;
    private boolean oneline = false;
    private boolean customEd = true;

    public boolean isEditable() {
        return this.editable;
    }

    protected boolean forceOneline() {
        return false;
    }

    public String getAsText() {
        if (this.getValue() == null) {
            return "";
        }
        return super.getAsText();
    }

    public void setAsText(String s) {
        this.setValue(s);
    }

    public void setValue(Object value) {
        String s = (String)value;
        if ("".equals(s) && this.getValue() == null) {
            return;
        }
        super.setValue(s);
    }

    protected void superSetValue(Object value) {
        super.setValue(value);
    }

    public String getJavaInitializationString() {
        String s = (String)this.getValue();
        if (s == null) {
            return "\"\"";
        }
        return "\"" + RaveStringEditor.toAscii(s) + "\"";
    }

    public boolean supportsCustomEditor() {
        return this.customEd;
    }

    public Component getCustomEditor() {
        return new RaveStringCustomEditor(this.getAsText(), this.isEditable(), this.oneline, this.instructions, this.getIgnoreCrs(), this);
    }

    public Object getCustomEditorValue(String string) {
        return string;
    }

    private static String toAscii(String str) {
        StringBuffer buf = new StringBuffer(str.length() * 6);
        char[] chars = str.toCharArray();
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && (useRaw || c <= '\u007f')) {
                        buf.append(c);
                        continue block9;
                    }
                    buf.append("\\u");
                    String hex = Integer.toHexString(c);
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        buf.append('0');
                    }
                    buf.append(hex);
                }
            }
        }
        return buf.toString();
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.editable = prop.canWrite();
            if (this.useOriginalShortDescriptionForInstructions()) {
                this.instructions = (String)prop.getValue("originalShortDescription");
                if (this.instructions == null) {
                    this.instructions = prop.getShortDescription();
                }
            } else {
                this.instructions = (String)prop.getValue("instructions");
            }
            this.oneline = this.forceOneline() ? true : Boolean.TRUE.equals(prop.getValue("oneline"));
            this.customEd = !Boolean.TRUE.equals(prop.getValue("suppressCustomEditor"));
        }
    }

    protected boolean useOriginalShortDescriptionForInstructions() {
        return false;
    }

    protected boolean getIgnoreCrs() {
        return false;
    }
}

