/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css;

import com.sun.jsfcl.std.css.BorderWidthField;
import com.sun.jsfcl.std.css.ColorSelectionField;
import com.sun.jsfcl.std.css.model.BorderModel;
import com.sun.jsfcl.std.css.model.CssStyleData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeCellEditor;
import org.openide.util.NbBundle;

public class BorderDataTable
extends JTable {
    CssStyleData cssStyleData;
    private String value;
    JComboBox allStyleCombo;
    BorderWidthField allWidthField;
    ColorSelectionField allColorField;
    JComboBox topStyleCombo;
    BorderWidthField topWidthField;
    ColorSelectionField topColorField;
    JComboBox bottomStyleCombo;
    BorderWidthField bottomWidthField;
    ColorSelectionField bottomColorField;
    JComboBox leftStyleCombo;
    BorderWidthField leftWidthField;
    ColorSelectionField leftColorField;
    JComboBox rightStyleCombo;
    BorderWidthField rightWidthField;
    ColorSelectionField rightColorField;
    private StyleItemListener styleItemListener = new StyleItemListener();
    private WidthPropertyChangeListener widthPropertyChangeListener = new WidthPropertyChangeListener();
    private ColorPropertyChangeListener colorPropertyChangeListener = new ColorPropertyChangeListener();
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public BorderDataTable(CssStyleData cssStyleData) {
        super(6, 4);
        this.cssStyleData = cssStyleData;
        this.setDefaultRenderer(JComponent.class, new JComponentCellRenderer());
        this.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setRowHeight(fontMetrics.getHeight() + 10 > 25 ? fontMetrics.getHeight() + 10 : 25);
        this.setAutoResizeMode(0);
        this.setIntercellSpacing(new Dimension(5, 5));
        this.setTableHeader(null);
        this.setBackground(new JPanel().getBackground());
        this.initCells();
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.getColumnModel().getColumn(1).setPreferredWidth(75);
        this.getColumnModel().getColumn(2).setPreferredWidth(125);
        this.getColumnModel().getColumn(3).setPreferredWidth(125);
    }

    public void initCells() {
        JPanel colHeader1 = new JPanel();
        this.setValueAt(colHeader1, 0, 0);
        JPanel colHeader2 = new JPanel();
        colHeader2.add(new JLabel(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BORDER_STYLE")));
        this.setValueAt(colHeader2, 0, 1);
        JPanel colHeader3 = new JPanel();
        colHeader3.add(new JLabel(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BORDER_WIDTH")));
        this.setValueAt(colHeader3, 0, 2);
        JPanel colHeader6 = new JPanel();
        colHeader6.add(new JLabel(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BORDER_COLOR")));
        this.setValueAt(colHeader6, 0, 3);
        JPanel rowHeader1 = new JPanel();
        rowHeader1.add(new JLabel(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BORDER_ALL")));
        this.setValueAt(rowHeader1, 1, 0);
        JPanel rowHeader2 = new JPanel();
        rowHeader2.add(new JLabel(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BORDER_TOP")));
        this.setValueAt(rowHeader2, 2, 0);
        JPanel rowHeader3 = new JPanel();
        rowHeader3.add(new JLabel(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BORDER_BOTTOM")));
        this.setValueAt(rowHeader3, 3, 0);
        JPanel rowHeader4 = new JPanel();
        rowHeader4.add(new JLabel(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BORDER_LEFT")));
        this.setValueAt(rowHeader4, 4, 0);
        JPanel rowHeader5 = new JPanel();
        rowHeader5.add(new JLabel(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BORDER_RIGHT")));
        this.setValueAt(rowHeader5, 5, 0);
        BorderModel borderModel = new BorderModel();
        this.allStyleCombo = new JComboBox();
        this.allStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)BorderDataTable.class, (String)"ALL_SIDE_BORDER_STYLE_ACCESS_NAME"));
        this.allStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BorderDataTable.class, (String)"ALL_SIDE_BORDER_STYLE_ACCESS_DESC"));
        this.allStyleCombo.setModel(borderModel.getStyleList());
        this.allStyleCombo.addItemListener(this.styleItemListener);
        this.setValueAt(this.allStyleCombo, 1, 1);
        this.allWidthField = new BorderWidthField();
        this.allWidthField.setAccessibleName(NbBundle.getMessage((Class)BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage((Class)BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.allWidthField.setAccessibleDescription(NbBundle.getMessage((Class)BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage((Class)BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
        this.allWidthField.addPropertyChangeListener(this.widthPropertyChangeListener);
        this.setValueAt(this.allWidthField, 1, 2);
        this.allColorField = new ColorSelectionField();
        this.allColorField.addPropertyChangeListener(this.colorPropertyChangeListener);
        this.setValueAt(this.allColorField, 1, 3);
        this.topStyleCombo = new JComboBox();
        this.topStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)BorderDataTable.class, (String)"TOP_SIDE_BORDER_STYLE_ACCESS_NAME"));
        this.topStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BorderDataTable.class, (String)"TOP_SIDE_BORDER_STYLE_ACCESS_DESC"));
        this.topStyleCombo.setModel(borderModel.getStyleList());
        if (this.cssStyleData.getProperty("border-top-style") != null) {
            this.topStyleCombo.setSelectedItem(this.cssStyleData.getProperty("border-top-style"));
        }
        this.topStyleCombo.addItemListener(this.styleItemListener);
        this.setValueAt(this.topStyleCombo, 2, 1);
        this.topWidthField = new BorderWidthField();
        this.topWidthField.setAccessibleName(NbBundle.getMessage((Class)BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage((Class)BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.topWidthField.setAccessibleDescription(NbBundle.getMessage((Class)BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage((Class)BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
        this.topWidthField.setWidthString(this.cssStyleData.getProperty("border-top-width"));
        this.topWidthField.addPropertyChangeListener(this.widthPropertyChangeListener);
        this.setValueAt(this.topWidthField, 2, 2);
        this.topColorField = new ColorSelectionField();
        this.topColorField.setColorString(this.cssStyleData.getProperty("border-top-color"));
        this.topColorField.addPropertyChangeListener(this.colorPropertyChangeListener);
        this.setValueAt(this.topColorField, 2, 3);
        this.bottomStyleCombo = new JComboBox();
        this.bottomStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_STYLE_ACCESS_NAME"));
        this.bottomStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_STYLE_ACCESS_DESC"));
        this.bottomStyleCombo.setModel(borderModel.getStyleList());
        if (this.cssStyleData.getProperty("border-bottom-style") != null) {
            this.bottomStyleCombo.setSelectedItem(this.cssStyleData.getProperty("border-bottom-style"));
        }
        this.bottomStyleCombo.addItemListener(this.styleItemListener);
        this.setValueAt(this.bottomStyleCombo, 3, 1);
        this.bottomWidthField = new BorderWidthField();
        this.bottomWidthField.setAccessibleName(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage((Class)BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.bottomWidthField.setAccessibleDescription(NbBundle.getMessage((Class)BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage((Class)BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
        this.bottomWidthField.setWidthString(this.cssStyleData.getProperty("border-bottom-width"));
        this.bottomWidthField.addPropertyChangeListener(this.widthPropertyChangeListener);
        this.setValueAt(this.bottomWidthField, 3, 2);
        this.bottomColorField = new ColorSelectionField();
        this.bottomColorField.setColorString(this.cssStyleData.getProperty("border-bottom-color"));
        this.bottomColorField.addPropertyChangeListener(this.colorPropertyChangeListener);
        this.setValueAt(this.bottomColorField, 3, 3);
        this.leftStyleCombo = new JComboBox<String>(new String[0]);
        this.leftStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)BorderDataTable.class, (String)"LEFT_SIDE_BORDER_STYLE_ACCESS_NAME"));
        this.leftStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BorderDataTable.class, (String)"LEFT_SIDE_BORDER_STYLE_ACCESS_DESC"));
        this.leftStyleCombo.setModel(borderModel.getStyleList());
        if (this.cssStyleData.getProperty("border-left-style") != null) {
            this.leftStyleCombo.setSelectedItem(this.cssStyleData.getProperty("border-left-style"));
        }
        this.leftStyleCombo.addItemListener(this.styleItemListener);
        this.setValueAt(this.leftStyleCombo, 4, 1);
        this.leftWidthField = new BorderWidthField();
        this.leftWidthField.setAccessibleName(NbBundle.getMessage((Class)BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage((Class)BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.leftWidthField.setAccessibleDescription(NbBundle.getMessage((Class)BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage((Class)BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
        this.leftWidthField.setWidthString(this.cssStyleData.getProperty("border-left-width"));
        this.leftWidthField.addPropertyChangeListener(this.widthPropertyChangeListener);
        this.setValueAt(this.leftWidthField, 4, 2);
        this.leftColorField = new ColorSelectionField();
        this.leftColorField.setColorString(this.cssStyleData.getProperty("border-left-color"));
        this.leftColorField.addPropertyChangeListener(this.colorPropertyChangeListener);
        this.setValueAt(this.leftColorField, 4, 3);
        this.rightStyleCombo = new JComboBox();
        this.rightStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_STYLE_ACCESS_NAME"));
        this.rightStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_STYLE_ACCESS_DESC"));
        this.rightStyleCombo.setModel(borderModel.getStyleList());
        if (this.cssStyleData.getProperty("border-right-style") != null) {
            this.rightStyleCombo.setSelectedItem(this.cssStyleData.getProperty("border-right-style"));
        }
        this.rightStyleCombo.addItemListener(this.styleItemListener);
        this.setValueAt(this.rightStyleCombo, 5, 1);
        this.rightWidthField = new BorderWidthField();
        this.rightWidthField.setAccessibleName(NbBundle.getMessage((Class)BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage((Class)BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.rightWidthField.setAccessibleDescription(NbBundle.getMessage((Class)BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage((Class)BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
        this.rightWidthField.setWidthString(this.cssStyleData.getProperty("border-right-width"));
        this.rightWidthField.addPropertyChangeListener(this.widthPropertyChangeListener);
        this.setValueAt(this.rightWidthField, 5, 2);
        this.rightColorField = new ColorSelectionField();
        this.rightColorField.setColorString(this.cssStyleData.getProperty("border-right-color"));
        this.rightColorField.addPropertyChangeListener(this.colorPropertyChangeListener);
        this.setValueAt(this.rightColorField, 5, 3);
        this.checkBorderStyleAll();
        this.checkBorderWidthAll();
        this.checkBorderColorAll();
    }

    private void checkBorderStyleAll() {
        this.allStyleCombo.removeItemListener(this.styleItemListener);
        String topStyle = this.cssStyleData.getProperty("border-top-style");
        String bottomStyle = this.cssStyleData.getProperty("border-bottom-style");
        String leftStyle = this.cssStyleData.getProperty("border-left-style");
        String rightStyle = this.cssStyleData.getProperty("border-right-style");
        if (topStyle != null && bottomStyle != null && leftStyle != null && rightStyle != null && topStyle.equals(bottomStyle) && topStyle.equals(leftStyle) && topStyle.equals(rightStyle)) {
            this.allStyleCombo.setSelectedItem(topStyle);
        } else {
            this.allStyleCombo.setSelectedIndex(0);
        }
        this.allStyleCombo.addItemListener(this.styleItemListener);
    }

    private void checkBorderWidthAll() {
        this.allWidthField.removePropertyChangeListener(this.widthPropertyChangeListener);
        String topWidth = this.cssStyleData.getProperty("border-top-width");
        String bottomWidth = this.cssStyleData.getProperty("border-bottom-width");
        String leftWidth = this.cssStyleData.getProperty("border-left-width");
        String rightWidth = this.cssStyleData.getProperty("border-right-width");
        if (topWidth != null && bottomWidth != null && leftWidth != null && rightWidth != null && topWidth.equals(bottomWidth) && topWidth.equals(leftWidth) && topWidth.equals(rightWidth)) {
            this.allWidthField.setWidthString(topWidth);
        } else {
            this.allWidthField.setWidthString(null);
        }
        this.allWidthField.addPropertyChangeListener(this.widthPropertyChangeListener);
    }

    private void checkBorderColorAll() {
        this.allColorField.removePropertyChangeListener(this.colorPropertyChangeListener);
        String topColor = this.cssStyleData.getProperty("border-top-color");
        String bottomColor = this.cssStyleData.getProperty("border-bottom-color");
        String leftColor = this.cssStyleData.getProperty("border-left-color");
        String rightColor = this.cssStyleData.getProperty("border-right-color");
        if (topColor != null && bottomColor != null && leftColor != null && rightColor != null && topColor.equals(bottomColor) && topColor.equals(leftColor) && topColor.equals(rightColor)) {
            this.allColorField.setColorString(topColor);
        } else {
            this.allColorField.setColorString(null);
        }
        this.allColorField.addPropertyChangeListener(this.colorPropertyChangeListener);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null) {
            Object o;
            Class<?> c = this.getColumnClass(column);
            if (c.equals(Object.class) && (o = this.getValueAt(row, column)) != null) {
                c = this.getValueAt(row, column).getClass();
            }
            renderer = this.getDefaultRenderer(c);
        }
        return renderer;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellEditor editor = tableColumn.getCellEditor();
        if (editor == null) {
            Object o;
            Class<?> c = this.getColumnClass(column);
            if (c.equals(Object.class) && (o = this.getValueAt(row, column)) != null) {
                c = this.getValueAt(row, column).getClass();
            }
            editor = this.getDefaultEditor(c);
        }
        return editor;
    }

    class JComponentCellEditor
    implements TableCellEditor,
    TreeCellEditor,
    Serializable {
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;
        protected JComponent editorComponent = null;
        protected JComponent container = null;

        JComponentCellEditor() {
        }

        public Component getComponent() {
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            return this.editorComponent;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            if (this.editorComponent != null && anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getID() == 501) {
                Component dispatchComponent = SwingUtilities.getDeepestComponentAt(this.editorComponent, 3, 3);
                MouseEvent e = (MouseEvent)anEvent;
                MouseEvent e2 = new MouseEvent(dispatchComponent, 502, e.getWhen() + 100000L, e.getModifiers(), 3, 3, e.getClickCount(), e.isPopupTrigger());
                dispatchComponent.dispatchEvent(e2);
                e2 = new MouseEvent(dispatchComponent, 500, e.getWhen() + 100001L, e.getModifiers(), 3, 3, 1, e.isPopupTrigger());
                dispatchComponent.dispatchEvent(e2);
            }
            return false;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void addCellEditorListener(CellEditorListener l) {
            this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = BorderDataTable.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
        }

        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = BorderDataTable.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$CellEditorListener == null ? BorderDataTable.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$CellEditorListener == null ? BorderDataTable.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, false);
            this.editorComponent = (JComponent)value;
            this.container = tree;
            return this.editorComponent;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editorComponent = (JComponent)value;
            this.container = table;
            return this.editorComponent;
        }
    }

    class JComponentCellRenderer
    implements TableCellRenderer {
        JComponentCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent comp = (JComponent)value;
            comp.setMinimumSize(new Dimension(100, 25));
            return comp;
        }
    }

    class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        PropertyChangeListenerImpl() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    private class ColorPropertyChangeListener
    implements PropertyChangeListener {
        private ColorPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == BorderDataTable.this.allColorField) {
                BorderDataTable.this.topColorField.removePropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.bottomColorField.removePropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.leftColorField.removePropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.rightColorField.removePropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.topColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-color", BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.bottomColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-color", BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.leftColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-color", BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.rightColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-color", BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.topColorField.addPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.bottomColorField.addPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.leftColorField.addPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.rightColorField.addPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
            }
            if (evt.getSource() == BorderDataTable.this.topColorField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-color", BorderDataTable.this.topColorField.getColorString());
                BorderDataTable.this.checkBorderColorAll();
            }
            if (evt.getSource() == BorderDataTable.this.bottomColorField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-color", BorderDataTable.this.bottomColorField.getColorString());
                BorderDataTable.this.checkBorderColorAll();
            }
            if (evt.getSource() == BorderDataTable.this.leftColorField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-color", BorderDataTable.this.leftColorField.getColorString());
                BorderDataTable.this.checkBorderColorAll();
            }
            if (evt.getSource() == BorderDataTable.this.rightColorField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-color", BorderDataTable.this.rightColorField.getColorString());
                BorderDataTable.this.checkBorderColorAll();
            }
        }
    }

    private class WidthPropertyChangeListener
    implements PropertyChangeListener {
        private WidthPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == BorderDataTable.this.allWidthField) {
                BorderDataTable.this.topWidthField.removePropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.bottomWidthField.removePropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.leftWidthField.removePropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.rightWidthField.removePropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-width", evt.getNewValue().toString());
                BorderDataTable.this.topWidthField.setWidthString(evt.getNewValue().toString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-width", evt.getNewValue().toString());
                BorderDataTable.this.bottomWidthField.setWidthString(evt.getNewValue().toString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-width", evt.getNewValue().toString());
                BorderDataTable.this.leftWidthField.setWidthString(evt.getNewValue().toString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-width", evt.getNewValue().toString());
                BorderDataTable.this.rightWidthField.setWidthString(evt.getNewValue().toString());
                BorderDataTable.this.topWidthField.addPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.bottomWidthField.addPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.leftWidthField.addPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.rightWidthField.addPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
            } else if (evt.getSource() == BorderDataTable.this.topWidthField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-width", evt.getNewValue().toString());
                BorderDataTable.this.checkBorderWidthAll();
            } else if (evt.getSource() == BorderDataTable.this.bottomWidthField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-width", evt.getNewValue().toString());
                BorderDataTable.this.checkBorderWidthAll();
            } else if (evt.getSource() == BorderDataTable.this.leftWidthField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-width", evt.getNewValue().toString());
                BorderDataTable.this.checkBorderWidthAll();
            } else if (evt.getSource() == BorderDataTable.this.rightWidthField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-width", evt.getNewValue().toString());
                BorderDataTable.this.checkBorderWidthAll();
            }
        }
    }

    private class StyleItemListener
    implements ItemListener {
        private StyleItemListener() {
        }

        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == BorderDataTable.this.allStyleCombo) {
                BorderDataTable.this.topStyleCombo.removeItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.bottomStyleCombo.removeItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.leftStyleCombo.removeItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.rightStyleCombo.removeItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-style", BorderDataTable.this.allStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.topStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-style", BorderDataTable.this.allStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.bottomStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-style", BorderDataTable.this.allStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.leftStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-style", BorderDataTable.this.allStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.rightStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                BorderDataTable.this.topStyleCombo.addItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.bottomStyleCombo.addItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.leftStyleCombo.addItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.rightStyleCombo.addItemListener(BorderDataTable.this.styleItemListener);
            } else if (evt.getSource() == BorderDataTable.this.topStyleCombo) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-style", BorderDataTable.this.topStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.checkBorderStyleAll();
            } else if (evt.getSource() == BorderDataTable.this.bottomStyleCombo) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-style", BorderDataTable.this.bottomStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.checkBorderStyleAll();
            } else if (evt.getSource() == BorderDataTable.this.leftStyleCombo) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-style", BorderDataTable.this.leftStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.checkBorderStyleAll();
            } else if (evt.getSource() == BorderDataTable.this.rightStyleCombo) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-style", BorderDataTable.this.rightStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.checkBorderStyleAll();
            }
        }
    }
}

