/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css;

import com.sun.jsfcl.std.css.model.BorderModel;
import com.sun.jsfcl.std.css.model.PropertyWithUnitData;
import com.sun.jsfcl.std.css.model.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class BorderWidthField
extends JPanel {
    PropertyWithUnitData borderWidthData = new PropertyWithUnitData();
    BorderModel borderModel = new BorderModel();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JComboBox borderWidthCombo;
    private JComboBox borderWidthUnitCombo;

    public BorderWidthField() {
        this.initComponents();
        this.borderWidthCombo.setModel(this.borderModel.getWidthList());
        this.borderWidthUnitCombo.setModel(this.borderModel.getWidthUnitList());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void setWidthString(String widthStr) {
        if (widthStr != null && !widthStr.equals("")) {
            if (Utils.isInteger(widthStr)) {
                this.setWidthValue(widthStr);
            } else {
                String unit = this.getUnit(widthStr);
                this.setWidthUnit(unit);
                this.setWidthValue(widthStr.replaceAll(unit, "").trim());
            }
        } else {
            this.setWidthValue(null);
            this.setWidthUnit(null);
        }
    }

    private String getUnit(String positionStr) {
        DefaultComboBoxModel unitList = this.borderModel.getWidthUnitList();
        for (int i = 0; i < unitList.getSize(); ++i) {
            String unit = (String)unitList.getElementAt(i);
            if (!positionStr.trim().endsWith(unit)) continue;
            return unit;
        }
        return "";
    }

    public void setWidthValue(String value) {
        if (value == null || value.equals("")) {
            this.borderWidthCombo.setSelectedIndex(0);
        } else {
            this.borderWidthCombo.setSelectedItem(value);
            this.borderWidthData.setValue(value);
        }
    }

    public void setWidthUnit(String value) {
        if (value == null || value.equals("")) {
            this.borderWidthUnitCombo.setSelectedIndex(this.borderModel.getWidthUnitList().getIndexOf("px"));
        } else {
            if (this.borderModel.getWidthUnitList().getIndexOf(value) != -1) {
                this.borderWidthUnitCombo.setSelectedIndex(this.borderModel.getWidthUnitList().getIndexOf(value));
            } else {
                this.borderWidthUnitCombo.setSelectedIndex(this.borderModel.getWidthUnitList().getIndexOf("px"));
            }
            this.borderWidthData.setUnit(value);
        }
    }

    private void initComponents() {
        this.borderWidthCombo = new JComboBox();
        this.borderWidthUnitCombo = new JComboBox();
        this.setLayout(new BorderLayout(3, 0));
        this.borderWidthCombo.setEditable(true);
        this.borderWidthCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BorderWidthField.this.borderWidthComboItemStateChanged(evt);
            }
        });
        this.borderWidthCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BorderWidthField.this.borderWidthComboActionPerformed(evt);
            }
        });
        this.borderWidthCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                BorderWidthField.this.borderWidthComboFocusLost(evt);
            }
        });
        this.add((Component)this.borderWidthCombo, "Center");
        this.borderWidthCombo.getAccessibleContext().setAccessibleName("Test");
        this.borderWidthCombo.getAccessibleContext().setAccessibleDescription("Test1");
        this.borderWidthUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BorderWidthField.this.borderWidthUnitComboItemStateChanged(evt);
            }
        });
        this.borderWidthUnitCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                BorderWidthField.this.borderWidthUnitComboFocusLost(evt);
            }
        });
        this.add((Component)this.borderWidthUnitCombo, "East");
    }

    private void borderWidthUnitComboFocusLost(FocusEvent evt) {
        this.setBorderWidth();
    }

    private void borderWidthUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setBorderWidth();
        }
    }

    public void setAccessibleName(String comboName, String unitName) {
        this.borderWidthCombo.getAccessibleContext().setAccessibleName(comboName);
        this.borderWidthUnitCombo.getAccessibleContext().setAccessibleName(unitName);
    }

    public void setAccessibleDescription(String comboDesc, String unitDesc) {
        this.borderWidthCombo.getAccessibleContext().setAccessibleDescription(comboDesc);
        this.borderWidthUnitCombo.getAccessibleContext().setAccessibleDescription(unitDesc);
    }

    private void borderWidthComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setBorderWidth();
        }
    }

    private void borderWidthComboFocusLost(FocusEvent evt) {
        this.setBorderWidth();
    }

    private void borderWidthComboActionPerformed(ActionEvent evt) {
        this.setBorderWidth();
    }

    private void setBorderWidth() {
        String oldValue = this.borderWidthData.toString();
        this.borderWidthData.setUnit(this.borderWidthUnitCombo.getSelectedItem().toString());
        this.borderWidthData.setValue(this.borderWidthCombo.getSelectedItem().toString());
        this.propertyChangeSupport.firePropertyChange("border-width", oldValue, this.borderWidthData.toString());
    }
}

