/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css;

import com.sun.jsfcl.std.css.model.MarginPaddingModel;
import com.sun.jsfcl.std.css.model.PropertyWithUnitData;
import com.sun.jsfcl.std.css.model.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class MarginWidthField
extends JPanel {
    PropertyWithUnitData borderMarginData = new PropertyWithUnitData();
    MarginPaddingModel marginPaddingModel = new MarginPaddingModel();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JComboBox borderMarginCombo;
    private JComboBox borderMarginUnitCombo;

    public MarginWidthField() {
        this.initComponents();
        this.borderMarginCombo.setModel(this.marginPaddingModel.getMarginList());
        this.borderMarginUnitCombo.setModel(this.marginPaddingModel.getMarginUnitList());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void setMarginString(String marginStr) {
        if (marginStr != null && !marginStr.equals("")) {
            if (Utils.isInteger(marginStr)) {
                this.setMarginValue(marginStr);
            } else {
                String unit = this.getUnit(marginStr);
                this.setMarginUnit(unit);
                this.setMarginValue(marginStr.replaceAll(unit, "").trim());
            }
        } else {
            this.setMarginValue(null);
            this.setMarginUnit(null);
        }
    }

    public String getMarginString() {
        return this.borderMarginData.toString();
    }

    private String getUnit(String positionStr) {
        DefaultComboBoxModel unitList = this.marginPaddingModel.getMarginUnitList();
        for (int i = 0; i < unitList.getSize(); ++i) {
            String unit = (String)unitList.getElementAt(i);
            if (!positionStr.trim().endsWith(unit)) continue;
            return unit;
        }
        return "";
    }

    public void setMarginValue(String value) {
        if (value == null || value.equals("")) {
            this.borderMarginCombo.setSelectedIndex(0);
        } else {
            this.borderMarginCombo.setSelectedItem(value);
            this.borderMarginData.setValue(value);
        }
    }

    public void setMarginUnit(String value) {
        if (value == null || value.equals("")) {
            this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf("px"));
        } else {
            if (this.marginPaddingModel.getMarginUnitList().getIndexOf(value) != -1) {
                this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf(value));
            } else {
                this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf("px"));
            }
            this.borderMarginData.setUnit(value);
        }
    }

    private void initComponents() {
        this.borderMarginCombo = new JComboBox();
        this.borderMarginUnitCombo = new JComboBox();
        this.setLayout(new BorderLayout(3, 0));
        this.borderMarginCombo.setEditable(true);
        this.borderMarginCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MarginWidthField.this.borderMarginComboItemStateChanged(evt);
            }
        });
        this.borderMarginCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MarginWidthField.this.borderMarginComboActionPerformed(evt);
            }
        });
        this.borderMarginCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MarginWidthField.this.borderMarginComboFocusLost(evt);
            }
        });
        this.add((Component)this.borderMarginCombo, "Center");
        this.borderMarginUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MarginWidthField.this.borderMarginUnitComboItemStateChanged(evt);
            }
        });
        this.borderMarginUnitCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MarginWidthField.this.borderMarginUnitComboFocusLost(evt);
            }
        });
        this.add((Component)this.borderMarginUnitCombo, "East");
    }

    private void borderMarginUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setborderMargin();
        }
    }

    private void borderMarginUnitComboFocusLost(FocusEvent evt) {
        this.setborderMargin();
    }

    public void setAccessibleName(String comboName, String unitName) {
        this.borderMarginCombo.getAccessibleContext().setAccessibleName(comboName);
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleName(unitName);
    }

    public void setAccessibleDescription(String comboDesc, String unitDesc) {
        this.borderMarginCombo.getAccessibleContext().setAccessibleDescription(comboDesc);
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleDescription(unitDesc);
    }

    private void borderMarginComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setborderMargin();
        }
    }

    private void borderMarginComboFocusLost(FocusEvent evt) {
        this.setborderMargin();
    }

    private void borderMarginComboActionPerformed(ActionEvent evt) {
        this.setborderMargin();
    }

    private void setborderMargin() {
        String oldValue = this.borderMarginData.toString();
        this.borderMarginData.setUnit(this.borderMarginUnitCombo.getSelectedItem().toString());
        this.borderMarginData.setValue(this.borderMarginCombo.getSelectedItem().toString());
        this.propertyChangeSupport.firePropertyChange("margin-width", oldValue, this.borderMarginData.toString());
    }
}

