/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css;

import com.sun.jsfcl.std.css.BackgroundStyleEditor;
import com.sun.jsfcl.std.css.BorderStyleEditor;
import com.sun.jsfcl.std.css.FontStyleEditor;
import com.sun.jsfcl.std.css.MarginStyleEditor;
import com.sun.jsfcl.std.css.PositionStyleEditor;
import com.sun.jsfcl.std.css.StyleEditor;
import com.sun.jsfcl.std.css.StyleEditorListPanel;
import com.sun.jsfcl.std.css.TextBlockStyleEditor;
import com.sun.jsfcl.std.css.model.CssStyleData;
import com.sun.jsfcl.std.css.model.CssStyleParser;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import com.sun.rave.designtime.markup.MarkupDesignContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class StyleBuilderPanel
extends JPanel
implements PropertyChangeListener {
    JPanel currentEditor;
    String currentStyle = null;
    private CssStyleData cssStyleData = new CssStyleData();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    DesignProperty designProperty = null;
    Image previewImage = null;
    StyleEditorListPanel styleEditorListPanel = null;
    List styleEditorList = new ArrayList();
    String noPreviewLabel = NbBundle.getMessage((Class)StyleBuilderPanel.class, (String)"NO_PREVIEW");
    private JPanel editorListPanel;
    private JPanel editorPanel;
    private JSplitPane editorSplitPane;
    private JSplitPane mainSplitPane;
    private JPanel previewPanel;
    private JScrollPane previewScrollPane;
    private JScrollPane previewScrollPane1;
    private JSplitPane styleEditorSplitPane;
    private JLabel styleLabel;
    private JPanel styleStringPanel;
    private JScrollPane styleStringScroll;
    private JTextArea styleTextArea;

    public StyleBuilderPanel() {
        this.initComponents();
        this.initialize();
    }

    public StyleBuilderPanel(String styleString, DesignProperty liveProperty) {
        this.initComponents();
        this.designProperty = liveProperty;
        CssStyleParser styleParser = new CssStyleParser(this.cssStyleData, liveProperty);
        this.cssStyleData = styleParser.parse(styleString);
        this.currentStyle = this.cssStyleData.getStyleValue();
        this.initialize();
        this.styleTextArea.setText(this.currentStyle);
        this.displayPreviewImage();
    }

    public StyleBuilderPanel(String styleString) {
        this(styleString, null);
    }

    private void initialize() {
        this.styleEditorListPanel = new StyleEditorListPanel(this, this.cssStyleData);
        this.styleEditorList.add(new FontStyleEditor(this.cssStyleData));
        BackgroundStyleEditor bgStyleEditor = new BackgroundStyleEditor(this.cssStyleData);
        bgStyleEditor.setDesignProperty(this.designProperty);
        this.styleEditorList.add(bgStyleEditor);
        this.styleEditorList.add(new TextBlockStyleEditor(this.cssStyleData));
        this.styleEditorList.add(new BorderStyleEditor(this.cssStyleData));
        this.styleEditorList.add(new MarginStyleEditor(this.cssStyleData));
        this.styleEditorList.add(new PositionStyleEditor(this.cssStyleData));
        for (int i = 0; i < this.styleEditorList.size(); ++i) {
            StyleEditor styleEitor = (StyleEditor)this.styleEditorList.get(i);
            this.styleEditorListPanel.addEditor(styleEitor);
        }
        this.styleEditorListPanel.setSelectedEditor((StyleEditor)this.styleEditorList.get(0));
        this.setEditorListPanel(this.styleEditorListPanel);
        this.cssStyleData.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.styleTextArea.setText(this.cssStyleData.getStyleValue());
        this.propertyChangeSupport.firePropertyChange("style", this.currentStyle, this.cssStyleData.getStyleValue());
        this.currentStyle = this.cssStyleData.getStyleValue();
        this.displayPreviewImage();
    }

    private void displayPreviewImage() {
        if (this.designProperty != null) {
            try {
                MarkupDesignBean liveBean = (MarkupDesignBean)this.designProperty.getDesignBean();
                MarkupDesignContext liveContext = (MarkupDesignContext)liveBean.getDesignContext();
                Dimension viewportDim = this.previewScrollPane.getViewport().getViewSize();
                this.previewImage = liveContext.getCssPreviewImage(this.currentStyle, null, liveBean, (int)viewportDim.getWidth(), (int)viewportDim.getHeight());
                if (this.previewImage != null) {
                    this.previewPanel.setPreferredSize(new Dimension(this.previewImage.getWidth(this) + 10, this.previewImage.getHeight(this) + 10));
                }
                this.repaint();
            }
            catch (Exception exc) {
                ErrorManager.getDefault().notify(4096, (Throwable)exc);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String getStyleString() {
        return this.cssStyleData.toString();
    }

    private void initComponents() {
        this.mainSplitPane = new JSplitPane();
        this.styleStringPanel = new JPanel();
        this.styleStringScroll = new JScrollPane();
        this.styleTextArea = new JTextArea();
        this.styleLabel = new JLabel();
        this.styleEditorSplitPane = new JSplitPane();
        this.editorListPanel = new JPanel();
        this.editorSplitPane = new JSplitPane();
        this.previewScrollPane = new JScrollPane();
        this.previewPanel = new PreviewPanel();
        this.previewScrollPane1 = new JScrollPane();
        this.editorPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.mainSplitPane.setOrientation(0);
        this.mainSplitPane.setResizeWeight(1.0);
        this.mainSplitPane.setPreferredSize(new Dimension(400, 650));
        this.styleStringPanel.setLayout(new GridBagLayout());
        this.styleStringPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.styleStringPanel.setPreferredSize(new Dimension(375, 100));
        this.styleStringScroll.setMaximumSize(new Dimension(300, 100));
        this.styleStringScroll.setPreferredSize(new Dimension(300, 100));
        this.styleTextArea.setColumns(50);
        this.styleTextArea.setLineWrap(true);
        this.styleTextArea.setRows(3);
        this.styleTextArea.setMargin(new Insets(5, 5, 5, 5));
        this.styleTextArea.setMinimumSize(new Dimension(110, 75));
        this.styleTextArea.setPreferredSize(new Dimension(410, 75));
        this.styleTextArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                StyleBuilderPanel.this.styleTextAreaFocusLost(evt);
            }
        });
        this.styleStringScroll.setViewportView(this.styleTextArea);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.styleStringPanel.add((Component)this.styleStringScroll, gridBagConstraints);
        this.styleLabel.setText(NbBundle.getMessage((Class)StyleBuilderPanel.class, (String)"CSS_STYLE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.styleStringPanel.add((Component)this.styleLabel, gridBagConstraints);
        this.mainSplitPane.setBottomComponent(this.styleStringPanel);
        this.editorListPanel.setLayout(new BorderLayout());
        this.editorListPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.styleEditorSplitPane.setLeftComponent(this.editorListPanel);
        this.editorSplitPane.setOrientation(0);
        this.editorSplitPane.setResizeWeight(1.0);
        this.previewScrollPane.setAutoscrolls(true);
        this.previewScrollPane.setDoubleBuffered(true);
        this.previewScrollPane.setPreferredSize(new Dimension(400, 150));
        this.previewPanel.setLayout(new GridBagLayout());
        this.previewScrollPane.setViewportView(this.previewPanel);
        this.editorSplitPane.setBottomComponent(this.previewScrollPane);
        this.previewScrollPane1.setAutoscrolls(true);
        this.previewScrollPane1.setDoubleBuffered(true);
        this.previewScrollPane1.setPreferredSize(new Dimension(400, 350));
        this.editorPanel.setLayout(new BorderLayout());
        this.previewScrollPane1.setViewportView(this.editorPanel);
        this.editorSplitPane.setTopComponent(this.previewScrollPane1);
        this.styleEditorSplitPane.setRightComponent(this.editorSplitPane);
        this.mainSplitPane.setTopComponent(this.styleEditorSplitPane);
        this.add((Component)this.mainSplitPane, "Center");
    }

    private void styleTextAreaFocusLost(FocusEvent evt) {
        this.propertyChangeSupport.firePropertyChange("style", this.currentStyle, this.styleTextArea.getText());
    }

    public void setEditorListPanel(JPanel panel) {
        this.editorListPanel.add((Component)panel, "Center");
        this.repaint();
    }

    public void setEditorPanel(JPanel panel) {
        if (this.currentEditor != null) {
            this.editorPanel.remove(this.currentEditor);
        }
        this.currentEditor = panel;
        this.editorPanel.add((Component)this.currentEditor, "Center");
        this.validate();
        this.repaint();
    }

    class PreviewPanel
    extends JPanel {
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g2d = (Graphics2D)graphics;
            if (StyleBuilderPanel.this.previewImage != null) {
                int imgX = 3;
                int imgY = 3;
                int imgWidth = StyleBuilderPanel.this.previewImage.getWidth(this);
                int imgHeight = StyleBuilderPanel.this.previewImage.getHeight(this);
                if (imgWidth < this.getWidth()) {
                    imgX = (this.getWidth() - imgWidth) / 2;
                    imgY = (this.getHeight() - imgHeight) / 2;
                }
                g2d.drawImage(StyleBuilderPanel.this.previewImage, imgX, imgY, this);
            } else {
                FontRenderContext frc = g2d.getFontRenderContext();
                Rectangle2D bounds = g2d.getFont().getStringBounds(StyleBuilderPanel.this.noPreviewLabel, frc);
                int labelX = (this.getWidth() - (int)bounds.getWidth()) / 2;
                int labelY = (this.getHeight() - (int)bounds.getHeight()) / 2;
                g2d.drawString(StyleBuilderPanel.this.noPreviewLabel, labelX, labelY);
            }
        }
    }
}

