/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css;

import com.sun.jsfcl.std.css.StyleBuilderDialog;
import com.sun.jsfcl.std.css.StyleEditor;
import com.sun.jsfcl.std.css.model.CssStyleData;
import com.sun.jsfcl.std.css.model.PropertyData;
import com.sun.jsfcl.std.css.model.PropertyWithUnitData;
import com.sun.jsfcl.std.css.model.TextBlockData;
import com.sun.jsfcl.std.css.model.TextBlockModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.openide.util.NbBundle;

public class TextBlockStyleEditor
extends StyleEditor {
    CssStyleData cssStyleData = null;
    PropertyData directionData = new PropertyData();
    PropertyData textAlignData = new PropertyData();
    PropertyWithUnitData verticalAlignData = new PropertyWithUnitData();
    PropertyWithUnitData wordSpacingData = new PropertyWithUnitData();
    PropertyWithUnitData letterSpacingData = new PropertyWithUnitData();
    PropertyWithUnitData lineHeightData = new PropertyWithUnitData();
    PropertyWithUnitData textIndentData = new PropertyWithUnitData();
    private JLabel decorationLabel;
    private JComboBox directionCombo;
    private JLabel errorLabel;
    private JPanel errorPanel;
    private JComboBox horizontalAlignCombo;
    private JLabel imageScroll;
    private JLabel imageScroll1;
    private JLabel imageScroll2;
    private JLabel jLabel2;
    private JComboBox letterSpacingCombo;
    private JComboBox letterSpacingUnitCombo;
    private JComboBox lineHeightCombo;
    private JLabel lineHeightLabel;
    private JComboBox lineHeightUnitCombo;
    private JLabel textAlignLabel;
    private JPanel textBlockPanel;
    private JComboBox textIndentCombo;
    private JComboBox textIndentUnitCombo;
    private JComboBox verticalAlignCombo;
    private JComboBox verticalAlignUnitCombo;
    private JComboBox wordSpacingCombo;
    private JComboBox wordSpacingUnitCombo;

    public TextBlockStyleEditor(CssStyleData styleData) {
        this.cssStyleData = styleData;
        this.setName("textBlockStyleEditor");
        this.setDisplayName(NbBundle.getMessage((Class)StyleBuilderDialog.class, (String)"TEXTBLOCK_EDITOR_DISPNAME"));
        this.initComponents();
        this.initialize();
    }

    private void initialize() {
        TextBlockModel textBlockModel = new TextBlockModel();
        TextBlockData textBlockData = new TextBlockData();
        DefaultComboBoxModel horizontalAlignList = textBlockModel.getHorizontalAlignmentList();
        this.horizontalAlignCombo.setModel(horizontalAlignList);
        String horizontalAlign = this.cssStyleData.getProperty("text-align");
        if (horizontalAlign != null) {
            this.horizontalAlignCombo.setSelectedItem(horizontalAlign);
        } else {
            this.horizontalAlignCombo.setSelectedIndex(0);
        }
        DefaultComboBoxModel verticalAlignList = textBlockModel.getVerticalAlignmentList();
        this.verticalAlignCombo.setModel(verticalAlignList);
        this.verticalAlignUnitCombo.setModel(textBlockModel.getTextBlockUnitList());
        String verticalAlign = this.cssStyleData.getProperty("vertical-align");
        if (verticalAlign != null) {
            textBlockData.setVerticalAlign(verticalAlign);
            this.verticalAlignCombo.setSelectedItem(textBlockData.getVerticalAlignValue());
            this.verticalAlignUnitCombo.setSelectedItem(textBlockData.getVerticalAlignUnit());
        } else {
            this.verticalAlignCombo.setSelectedIndex(0);
            this.verticalAlignUnitCombo.setSelectedIndex(0);
        }
        DefaultComboBoxModel indentationList = textBlockModel.getIndentationList();
        this.textIndentCombo.setModel(indentationList);
        this.textIndentUnitCombo.setModel(textBlockModel.getTextBlockUnitList());
        String indentation = this.cssStyleData.getProperty("text-indent");
        if (indentation != null) {
            textBlockData.setIndentation(indentation);
            this.textIndentCombo.setSelectedItem(textBlockData.getIndentationValue());
            this.textIndentUnitCombo.setSelectedItem(textBlockData.getIndentationUnit());
        } else {
            this.textIndentCombo.setSelectedIndex(0);
            this.textIndentUnitCombo.setSelectedIndex(0);
        }
        DefaultComboBoxModel textDirectionList = textBlockModel.getTextDirectionList();
        this.directionCombo.setModel(textDirectionList);
        String textDirection = this.cssStyleData.getProperty("direction");
        if (textDirection != null) {
            this.directionCombo.setSelectedItem(textDirection);
        } else {
            this.directionCombo.setSelectedIndex(0);
        }
        DefaultComboBoxModel wordSpacingList = textBlockModel.getWordSpacingList();
        this.wordSpacingCombo.setModel(wordSpacingList);
        this.wordSpacingUnitCombo.setModel(textBlockModel.getTextBlockUnitList());
        String wordSpacing = this.cssStyleData.getProperty("word-spacing");
        if (wordSpacing != null) {
            textBlockData.setWordSpacing(wordSpacing);
            this.wordSpacingCombo.setSelectedItem(textBlockData.getWordSpacingValue());
            this.wordSpacingUnitCombo.setSelectedItem(textBlockData.getWordSpacingUnit());
        } else {
            this.wordSpacingCombo.setSelectedIndex(0);
            this.wordSpacingUnitCombo.setSelectedIndex(0);
        }
        DefaultComboBoxModel letterSpacingList = textBlockModel.getLetterSpacingList();
        this.letterSpacingCombo.setModel(letterSpacingList);
        this.letterSpacingUnitCombo.setModel(textBlockModel.getTextBlockUnitList());
        String letterSpacing = this.cssStyleData.getProperty("letter-spacing");
        if (letterSpacing != null) {
            textBlockData.setLetterSpacing(letterSpacing);
            this.letterSpacingCombo.setSelectedItem(textBlockData.getLetterSpacingValue());
            this.letterSpacingUnitCombo.setSelectedItem(textBlockData.getLetterSpacingUnit());
        } else {
            this.letterSpacingCombo.setSelectedIndex(0);
            this.letterSpacingUnitCombo.setSelectedIndex(0);
        }
        DefaultComboBoxModel lineHeightList = textBlockModel.getLineHeightList();
        this.lineHeightCombo.setModel(lineHeightList);
        this.lineHeightUnitCombo.setModel(textBlockModel.getTextBlockUnitList());
        String lineHeight = this.cssStyleData.getProperty("line-height");
        if (lineHeight != null) {
            textBlockData.setLineHeight(lineHeight);
            this.lineHeightCombo.setSelectedItem(textBlockData.getLineHeightValue());
            this.lineHeightUnitCombo.setSelectedItem(textBlockData.getLineHeightUnit());
        } else {
            this.lineHeightCombo.setSelectedIndex(0);
            this.lineHeightUnitCombo.setSelectedIndex(0);
        }
        this.textIndentCombo.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TextBlockStyleEditor.this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
            }

            public void focusLost(FocusEvent evt) {
                TextBlockStyleEditor.this.errorLabel.setText("");
            }
        });
        this.directionCombo.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TextBlockStyleEditor.this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
            }

            public void focusLost(FocusEvent evt) {
                TextBlockStyleEditor.this.errorLabel.setText("");
            }
        });
        this.letterSpacingCombo.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TextBlockStyleEditor.this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
            }

            public void focusLost(FocusEvent evt) {
                TextBlockStyleEditor.this.errorLabel.setText("");
            }
        });
        this.wordSpacingCombo.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TextBlockStyleEditor.this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
            }

            public void focusLost(FocusEvent evt) {
                TextBlockStyleEditor.this.errorLabel.setText("");
            }
        });
    }

    private void initComponents() {
        this.textBlockPanel = new JPanel();
        this.decorationLabel = new JLabel();
        this.imageScroll = new JLabel();
        this.directionCombo = new JComboBox();
        this.horizontalAlignCombo = new JComboBox();
        this.textAlignLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.textIndentCombo = new JComboBox();
        this.verticalAlignCombo = new JComboBox();
        this.verticalAlignUnitCombo = new JComboBox();
        this.wordSpacingUnitCombo = new JComboBox();
        this.imageScroll1 = new JLabel();
        this.wordSpacingCombo = new JComboBox();
        this.imageScroll2 = new JLabel();
        this.letterSpacingCombo = new JComboBox();
        this.letterSpacingUnitCombo = new JComboBox();
        this.textIndentUnitCombo = new JComboBox();
        this.lineHeightLabel = new JLabel();
        this.lineHeightCombo = new JComboBox();
        this.lineHeightUnitCombo = new JComboBox();
        this.errorPanel = new JPanel();
        this.errorLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.textBlockPanel.setLayout(new GridBagLayout());
        this.textBlockPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.decorationLabel.setText(NbBundle.getMessage((Class)TextBlockStyleEditor.class, (String)"TEXT_INDENTATION"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.textBlockPanel.add((Component)this.decorationLabel, gridBagConstraints);
        this.imageScroll.setText(NbBundle.getMessage((Class)TextBlockStyleEditor.class, (String)"TEXT_DIRECTION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.textBlockPanel.add((Component)this.imageScroll, gridBagConstraints);
        this.directionCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.directionComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.textBlockPanel.add((Component)this.directionCombo, gridBagConstraints);
        this.horizontalAlignCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TextBlockStyleEditor.this.horizontalAlignComboFocusLost(evt);
            }
        });
        this.horizontalAlignCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.horizontalAlignComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.textBlockPanel.add((Component)this.horizontalAlignCombo, gridBagConstraints);
        this.textAlignLabel.setText(NbBundle.getMessage((Class)TextBlockStyleEditor.class, (String)"TEXT_HORIZ_ALIGN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 10);
        this.textBlockPanel.add((Component)this.textAlignLabel, gridBagConstraints);
        this.jLabel2.setText(NbBundle.getMessage((Class)TextBlockStyleEditor.class, (String)"TEXT_VERTICAL_ALIGN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.textBlockPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.textIndentCombo.setEditable(true);
        this.textIndentCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextBlockStyleEditor.this.textIndentComboActionPerformed(evt);
            }
        });
        this.textIndentCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TextBlockStyleEditor.this.textIndentComboFocusLost(evt);
            }
        });
        this.textIndentCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.textIndentComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.textBlockPanel.add((Component)this.textIndentCombo, gridBagConstraints);
        this.verticalAlignCombo.setEditable(true);
        this.verticalAlignCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextBlockStyleEditor.this.verticalAlignComboActionPerformed(evt);
            }
        });
        this.verticalAlignCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TextBlockStyleEditor.this.verticalAlignComboFocusLost(evt);
            }
        });
        this.verticalAlignCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.verticalAlignComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.textBlockPanel.add((Component)this.verticalAlignCombo, gridBagConstraints);
        this.verticalAlignUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.verticalAlignUnitComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.textBlockPanel.add((Component)this.verticalAlignUnitCombo, gridBagConstraints);
        this.wordSpacingUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.wordSpacingUnitComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.textBlockPanel.add((Component)this.wordSpacingUnitCombo, gridBagConstraints);
        this.imageScroll1.setText(NbBundle.getMessage((Class)TextBlockStyleEditor.class, (String)"WORD_SPACING"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.textBlockPanel.add((Component)this.imageScroll1, gridBagConstraints);
        this.wordSpacingCombo.setEditable(true);
        this.wordSpacingCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextBlockStyleEditor.this.wordSpacingComboActionPerformed(evt);
            }
        });
        this.wordSpacingCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TextBlockStyleEditor.this.wordSpacingComboFocusLost(evt);
            }
        });
        this.wordSpacingCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.wordSpacingComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.textBlockPanel.add((Component)this.wordSpacingCombo, gridBagConstraints);
        this.imageScroll2.setText(NbBundle.getMessage((Class)TextBlockStyleEditor.class, (String)"LETTER_SPACING"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.textBlockPanel.add((Component)this.imageScroll2, gridBagConstraints);
        this.letterSpacingCombo.setEditable(true);
        this.letterSpacingCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextBlockStyleEditor.this.letterSpacingComboActionPerformed(evt);
            }
        });
        this.letterSpacingCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TextBlockStyleEditor.this.letterSpacingComboFocusLost(evt);
            }
        });
        this.letterSpacingCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.letterSpacingComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.textBlockPanel.add((Component)this.letterSpacingCombo, gridBagConstraints);
        this.letterSpacingUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.letterSpacingUnitComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.textBlockPanel.add((Component)this.letterSpacingUnitCombo, gridBagConstraints);
        this.textIndentUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.textIndentUnitComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.textBlockPanel.add((Component)this.textIndentUnitCombo, gridBagConstraints);
        this.lineHeightLabel.setText(NbBundle.getMessage((Class)TextBlockStyleEditor.class, (String)"LINE_HEIGHT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 10);
        this.textBlockPanel.add((Component)this.lineHeightLabel, gridBagConstraints);
        this.lineHeightCombo.setEditable(true);
        this.lineHeightCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextBlockStyleEditor.this.lineHeightComboActionPerformed(evt);
            }
        });
        this.lineHeightCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TextBlockStyleEditor.this.lineHeightComboFocusLost(evt);
            }
        });
        this.lineHeightCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.lineHeightComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.textBlockPanel.add((Component)this.lineHeightCombo, gridBagConstraints);
        this.lineHeightUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextBlockStyleEditor.this.lineHeightUnitComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.textBlockPanel.add((Component)this.lineHeightUnitCombo, gridBagConstraints);
        this.add((Component)this.textBlockPanel, "North");
        this.errorPanel.setLayout(new BorderLayout());
        this.errorPanel.setBorder(new EmptyBorder(new Insets(1, 10, 1, 1)));
        this.errorLabel.setForeground(new Color(0, 0, 153));
        this.errorLabel.setMinimumSize(new Dimension(200, 20));
        this.errorLabel.setPreferredSize(new Dimension(200, 20));
        this.errorPanel.add((Component)this.errorLabel, "Center");
        this.add((Component)this.errorPanel, "South");
    }

    private void letterSpacingUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setLetterSpacing();
        }
    }

    private void letterSpacingComboFocusLost(FocusEvent evt) {
        this.setLetterSpacing();
    }

    private void letterSpacingComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setLetterSpacing();
        }
    }

    private void letterSpacingComboActionPerformed(ActionEvent evt) {
        this.setLetterSpacing();
    }

    private void wordSpacingUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setWordSpacing();
        }
    }

    private void wordSpacingComboFocusLost(FocusEvent evt) {
        this.setWordSpacing();
    }

    private void wordSpacingComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setWordSpacing();
        }
    }

    private void wordSpacingComboActionPerformed(ActionEvent evt) {
        this.setWordSpacing();
    }

    private void directionComboItemStateChanged(ItemEvent evt) {
        this.setDirection();
    }

    private void textIndentUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setTextIndent();
        }
    }

    private void textIndentComboFocusLost(FocusEvent evt) {
        this.setTextIndent();
    }

    private void textIndentComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setTextIndent();
        }
    }

    private void textIndentComboActionPerformed(ActionEvent evt) {
        this.setTextIndent();
    }

    private void verticalAlignUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setVerticalAlign();
        }
    }

    private void verticalAlignComboFocusLost(FocusEvent evt) {
        this.setVerticalAlign();
    }

    private void horizontalAlignComboFocusLost(FocusEvent evt) {
        this.setTextAlign();
    }

    private void verticalAlignComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setVerticalAlign();
        }
    }

    private void verticalAlignComboActionPerformed(ActionEvent evt) {
        this.setVerticalAlign();
    }

    private void horizontalAlignComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setTextAlign();
        }
    }

    private void lineHeightUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setLineHeight();
        }
    }

    private void lineHeightComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setLineHeight();
        }
    }

    private void lineHeightComboFocusLost(FocusEvent evt) {
        this.setLineHeight();
    }

    private void lineHeightComboActionPerformed(ActionEvent evt) {
        this.setLineHeight();
    }

    private void setLineHeight() {
        this.lineHeightData.setUnit(this.lineHeightUnitCombo.getSelectedItem().toString());
        this.lineHeightData.setValue(this.lineHeightCombo.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("line-height", this.lineHeightData.toString());
        this.lineHeightUnitCombo.setEnabled(this.lineHeightData.isValueInteger());
    }

    private void setLetterSpacing() {
        this.letterSpacingData.setUnit(this.letterSpacingUnitCombo.getSelectedItem().toString());
        this.letterSpacingData.setValue(this.letterSpacingCombo.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("letter-spacing", this.letterSpacingData.toString());
        this.letterSpacingUnitCombo.setEnabled(this.letterSpacingData.isValueInteger());
    }

    private void setWordSpacing() {
        this.wordSpacingData.setUnit(this.wordSpacingUnitCombo.getSelectedItem().toString());
        this.wordSpacingData.setValue(this.wordSpacingCombo.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("word-spacing", this.wordSpacingData.toString());
        this.wordSpacingUnitCombo.setEnabled(this.wordSpacingData.isValueInteger());
    }

    private void setDirection() {
        this.directionData.setValue(this.directionCombo.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("direction", this.directionData.toString());
    }

    private void setTextIndent() {
        this.textIndentData.setUnit(this.textIndentUnitCombo.getSelectedItem().toString());
        this.textIndentData.setValue(this.textIndentCombo.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("text-indent", this.textIndentData.toString());
        this.textIndentUnitCombo.setEnabled(this.textIndentData.isValueInteger());
    }

    private void setVerticalAlign() {
        this.verticalAlignData.setUnit(this.verticalAlignUnitCombo.getSelectedItem().toString());
        this.verticalAlignData.setValue(this.verticalAlignCombo.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("vertical-align", this.verticalAlignData.toString());
        this.verticalAlignUnitCombo.setEnabled(this.verticalAlignData.isValueInteger());
    }

    private void setTextAlign() {
        this.textAlignData.setValue(this.horizontalAlignCombo.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("text-align", this.textAlignData.toString());
    }
}

