/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css.model;

import com.sun.jsfcl.std.css.model.BackgroundModel;
import com.sun.jsfcl.std.css.model.CssStyleData;
import com.sun.jsfcl.std.css.model.Utils;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;

public class BackgroundPositionData {
    private String horizontalUnit = "px";
    private String verticalUnit = "px";
    private String verticalValue = "";
    private String horizontalValue = "";

    public void setBackgroundPosition(String bgPositionStr) {
        String token;
        StringTokenizer st = new StringTokenizer(bgPositionStr);
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            this.horizontalUnit = this.getUnit(token);
            this.horizontalValue = token.replaceAll(this.horizontalUnit, "");
        }
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            this.verticalUnit = this.getUnit(token);
            this.verticalValue = token.replaceAll(this.verticalUnit, "");
        }
    }

    private String getUnit(String postionStr) {
        DefaultComboBoxModel unitList = new BackgroundModel().getBackgroundPositionUnitList();
        for (int i = 0; i < unitList.getSize(); ++i) {
            String unit = (String)unitList.getElementAt(i);
            if (!postionStr.endsWith(unit)) continue;
            return unit;
        }
        return "";
    }

    public void setHorizontalUnit(String horizontalUnit) {
        this.horizontalUnit = horizontalUnit;
    }

    public String getHorizontalUnit() {
        return this.horizontalUnit;
    }

    public void setVerticalUnit(String verticalUnit) {
        this.verticalUnit = verticalUnit;
    }

    public String getVerticalUnit() {
        return this.verticalUnit;
    }

    public void setVerticalValue(String verticalValue) {
        this.verticalValue = verticalValue;
    }

    public String getVerticalValue() {
        return this.verticalValue;
    }

    public void setHorizontalValue(String horizontalValue) {
        this.horizontalValue = horizontalValue;
    }

    public String getHorizontalValue() {
        return this.horizontalValue;
    }

    public String toString() {
        String bgPosition = "";
        if (!this.horizontalValue.equals("") && !this.horizontalValue.startsWith(CssStyleData.NOT_SET)) {
            bgPosition = bgPosition + this.horizontalValue;
            if (Utils.isInteger(this.horizontalValue)) {
                bgPosition = bgPosition + this.horizontalUnit;
            }
        }
        if (!this.verticalValue.equals("") && !this.verticalValue.startsWith(CssStyleData.NOT_SET)) {
            bgPosition = bgPosition + " " + this.verticalValue;
            if (Utils.isInteger(this.verticalValue)) {
                bgPosition = bgPosition + this.verticalUnit;
            }
        }
        return bgPosition;
    }
}

