/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css.model;

import com.sun.jsfcl.std.css.model.ClipModel;
import com.sun.jsfcl.std.css.model.PropertyData;
import com.sun.jsfcl.std.css.model.PropertyWithUnitData;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;

public class ClipData
extends PropertyData {
    PropertyWithUnitData topValue = new PropertyWithUnitData();
    PropertyWithUnitData bottomValue = new PropertyWithUnitData();
    PropertyWithUnitData leftValue = new PropertyWithUnitData();
    PropertyWithUnitData rightValue = new PropertyWithUnitData();
    private boolean hasErrors = false;

    public void setClip(String cip) {
        String cipString = cip.substring(cip.indexOf("(") + 1, cip.indexOf(")"));
        StringTokenizer st = new StringTokenizer(cipString, ",");
        if (st.hasMoreTokens()) {
            this.setTop(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            this.setRight(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            this.setBottom(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            this.setLeft(st.nextToken());
        }
    }

    public void setTop(String clipTopStr) {
        this.topValue.setUnit(this.getUnit(clipTopStr));
        this.topValue.setValue(clipTopStr.replaceAll(this.topValue.getUnit(), "").trim());
    }

    public void setBottom(String clipBottomStr) {
        this.bottomValue.setUnit(this.getUnit(clipBottomStr));
        this.bottomValue.setValue(clipBottomStr.replaceAll(this.bottomValue.getUnit(), "").trim());
    }

    public void setLeft(String clipLeftStr) {
        this.leftValue.setUnit(this.getUnit(clipLeftStr));
        this.leftValue.setValue(clipLeftStr.replaceAll(this.leftValue.getUnit(), "").trim());
    }

    public void setRight(String clipRightStr) {
        this.rightValue.setUnit(this.getUnit(clipRightStr));
        this.rightValue.setValue(clipRightStr.replaceAll(this.rightValue.getUnit(), "").trim());
    }

    private String getUnit(String clipStr) {
        DefaultComboBoxModel unitList = new ClipModel().getClipUnitList();
        for (int i = 0; i < unitList.getSize(); ++i) {
            String unit = (String)unitList.getElementAt(i);
            if (!clipStr.trim().endsWith(unit)) continue;
            return unit;
        }
        return "";
    }

    public void setTopValue(String top) {
        this.topValue.setValue(top);
    }

    public void setTopUnit(String topUnit) {
        this.topValue.setUnit(topUnit);
    }

    public void setBottomValue(String bottom) {
        this.bottomValue.setValue(bottom);
    }

    public void setBottomUnit(String bottomUnit) {
        this.bottomValue.setUnit(bottomUnit);
    }

    public void setLeftValue(String left) {
        this.leftValue.setValue(left);
    }

    public void setLeftUnit(String leftUnit) {
        this.leftValue.setUnit(leftUnit);
    }

    public void setRightValue(String right) {
        this.rightValue.setValue(right);
    }

    public void setRightUnit(String rightUnit) {
        this.rightValue.setUnit(rightUnit);
    }

    public String getTopValue() {
        return this.topValue.getValue();
    }

    public String getTopUnit() {
        return this.topValue.getUnit();
    }

    public String getBottomValue() {
        return this.bottomValue.getValue();
    }

    public String getBottomUnit() {
        return this.bottomValue.getUnit();
    }

    public String getLeftValue() {
        return this.leftValue.getValue();
    }

    public String getLeftUnit() {
        return this.leftValue.getUnit();
    }

    public String getRightValue() {
        return this.rightValue.getValue();
    }

    public String getRightUnit() {
        return this.rightValue.getUnit();
    }

    public boolean isTopValueInteger() {
        return this.topValue.isValueInteger();
    }

    public boolean isBottomValueInteger() {
        return this.bottomValue.isValueInteger();
    }

    public boolean isLeftValueInteger() {
        return this.leftValue.isValueInteger();
    }

    public boolean isRightValueInteger() {
        return this.rightValue.isValueInteger();
    }

    public boolean hasErros() {
        if (this.topValue.hasValue() || this.bottomValue.hasValue() || this.rightValue.hasValue() || this.leftValue.hasValue()) {
            return this.hasErrors;
        }
        return false;
    }

    public String toString() {
        String clipString = "";
        if (!this.topValue.toString().equals("")) {
            clipString = clipString + " " + this.topValue.toString();
        } else {
            clipString = "";
            this.hasErrors = true;
        }
        if (!this.rightValue.toString().equals("")) {
            clipString = clipString + ", " + this.rightValue.toString();
        } else {
            clipString = "";
            this.hasErrors = true;
        }
        if (!this.bottomValue.toString().equals("")) {
            clipString = clipString + ", " + this.bottomValue.toString();
        } else {
            clipString = "";
            this.hasErrors = true;
        }
        if (!this.leftValue.toString().equals("")) {
            clipString = clipString + ", " + this.leftValue.toString();
        } else {
            clipString = "";
            this.hasErrors = true;
        }
        clipString = clipString.equals("") || this.hasErrors ? "" : "rect(" + clipString.trim() + ")";
        return clipString.trim();
    }
}

