/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css.model;

import com.sun.jsfcl.std.css.model.CssStyleData;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;

public class ColorModel {
    private Color color = Color.BLACK;
    private Map colorNameHexMap = new HashMap();

    public ColorModel() {
        this.colorNameHexMap.put("black", "#000000");
        this.colorNameHexMap.put("gray", "#808080");
        this.colorNameHexMap.put("white", "#FFFFFF");
        this.colorNameHexMap.put("maroon", "#800000");
        this.colorNameHexMap.put("red", "#FF0000");
        this.colorNameHexMap.put("purple", "#800080");
        this.colorNameHexMap.put("fuchsia", "#FF00FF");
        this.colorNameHexMap.put("green", "#008000");
        this.colorNameHexMap.put("lime", "#00FF00");
        this.colorNameHexMap.put("olive", "#808000");
        this.colorNameHexMap.put("orange", "#FFA500");
        this.colorNameHexMap.put("yellow", "#FFFF00");
        this.colorNameHexMap.put("navy", "#000080");
        this.colorNameHexMap.put("blue", "#0000FF");
        this.colorNameHexMap.put("teal", "#008080");
        this.colorNameHexMap.put("aqua", "#00FFFF");
    }

    public DefaultComboBoxModel getColorList() {
        return new ColorList();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color newColor) {
        this.color = newColor;
    }

    public void setColor(String newColor) {
        if (newColor.startsWith(CssStyleData.NOT_SET)) {
            this.setColor(Color.BLACK);
        } else if (newColor.startsWith("#")) {
            this.setHexColor(newColor);
        } else if (newColor.startsWith("rgb")) {
            String rgbString = newColor.substring(newColor.indexOf("(") + 1, newColor.indexOf(")"));
            try {
                StringTokenizer st = new StringTokenizer(rgbString, ",");
                while (st.hasMoreTokens()) {
                    int red = Integer.parseInt(st.nextToken().trim());
                    int green = Integer.parseInt(st.nextToken().trim());
                    int blue = Integer.parseInt(st.nextToken().trim());
                    this.color = new Color(red, green, blue);
                }
            }
            catch (Exception exc) {
                this.color = Color.BLACK;
            }
        } else {
            String hexValue = (String)this.colorNameHexMap.get(newColor);
            if (hexValue != null) {
                this.setHexColor(hexValue);
            }
        }
    }

    public void setHexColor(String hexColor) {
        int start = 0;
        if (hexColor.startsWith("#")) {
            start = 1;
        }
        try {
            int red = Integer.parseInt(hexColor.substring(start, start + 2), 16);
            int green = Integer.parseInt(hexColor.substring(start + 2, start + 4), 16);
            int blue = Integer.parseInt(hexColor.substring(start + 4, start + 6), 16);
            this.color = new Color(red, green, blue);
        }
        catch (Exception exc) {
            this.color = Color.BLACK;
        }
    }

    public String getHexColor() {
        String blueHex;
        String greenHex;
        String redHex = Integer.toHexString(this.color.getRed());
        if (redHex.length() < 2) {
            redHex = "0" + redHex;
        }
        if ((greenHex = Integer.toHexString(this.color.getGreen())).length() < 2) {
            greenHex = "0" + greenHex;
        }
        if ((blueHex = Integer.toHexString(this.color.getBlue())).length() < 2) {
            blueHex = "0" + blueHex;
        }
        String hexString = "#" + redHex + greenHex + blueHex;
        return hexString;
    }

    public class ColorList
    extends DefaultComboBoxModel {
        public ColorList() {
            this.addElement(CssStyleData.NOT_SET);
            Iterator iter = ColorModel.this.colorNameHexMap.keySet().iterator();
            while (iter.hasNext()) {
                this.addElement(iter.next());
            }
        }
    }
}

