/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css.model;

import com.sun.jsfcl.std.css.model.CssStyleData;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import com.sun.rave.designtime.markup.MarkupDesignContext;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class CssStyleParser {
    CssStyleData cssStyleDate = null;
    DesignProperty designProperty = null;

    public CssStyleParser() {
        this(new CssStyleData());
    }

    public CssStyleParser(CssStyleData styleDate) {
        this.cssStyleDate = styleDate;
    }

    public CssStyleParser(CssStyleData styleDate, DesignProperty designProperty) {
        this.cssStyleDate = styleDate;
        this.designProperty = designProperty;
    }

    public CssStyleData parse(String cssStyleString) {
        if (this.designProperty != null) {
            this.cssStyleDate.setDesignProperty(this.designProperty);
            MarkupDesignBean liveBean = (MarkupDesignBean)this.designProperty.getDesignBean();
            MarkupDesignContext liveContext = (MarkupDesignContext)liveBean.getDesignContext();
            Map styleMap = liveContext.convertCssStyleToMap(cssStyleString);
            Iterator iter = styleMap.keySet().iterator();
            while (iter.hasNext()) {
                String propertyName = (String)iter.next();
                String propertyValue = (String)styleMap.get(propertyName);
                this.cssStyleDate.addProperty(propertyName, propertyValue);
            }
        } else {
            cssStyleString = cssStyleString.replaceAll("&quot;", "\"");
            StringTokenizer styleProperties = new StringTokenizer(cssStyleString, ";");
            while (styleProperties.hasMoreTokens()) {
                String styleProperty = styleProperties.nextToken();
                String propertyName = styleProperty.substring(0, styleProperty.indexOf(":")).trim();
                String propertyValue = styleProperty.substring(styleProperty.indexOf(":") + 1).trim();
                this.cssStyleDate.addProperty(propertyName, propertyValue);
            }
        }
        return this.cssStyleDate;
    }

    public static void main(String[] args) {
        String cssStyleString = "background-color: red; border-left-color: rgb(255, 204, 204); border-right-color: rgb(255, 204, 204); border-top-color: rgb(255, 255, 102); border-bottom-color: rgb(255, 204, 204); border-left-style: double; border-right-style: double; border-top-style: solid; border-bottom-style: double; border-left-width: 44px; border-right-width: 44px; border-top-width: 44px; border-bottom-width: 44px; margin-left: 10px; margin-right: 10px; margin-top: 10px; margin-bottom: 10px; left: 72px; top: 48px; padding-left: 10px; padding-right: 10px; padding-top: 10px; padding-bottom: 10px; position: absolute ";
        System.out.println(cssStyleString);
        CssStyleParser styleParser = new CssStyleParser();
        CssStyleData styleData = styleParser.parse(cssStyleString);
        System.out.println(styleData.toString());
    }
}

