/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.BundleHolder;
import com.sun.jsfcl.std.property.ChooseManyReferenceDataPropertyEditor;
import com.sun.jsfcl.std.property.ChooseOneReferenceDataPanel;
import com.sun.jsfcl.std.property.ReferenceDataTwoColumnListCellRenderer;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import com.sun.rave.designtime.DesignProperty;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;

public class ChooseManyReferenceDataPanel
extends ChooseOneReferenceDataPanel {
    protected static final String DESELECT_ACTION = "deselect";
    protected static final String DESELECT_ALL_ACTION = "deselect-all";
    protected static final String DOWN_ACTION = "down";
    protected static final String SELECT_ACTION = "select";
    protected static final String UP_ACTION = "up";
    protected JButton downJButton;
    protected JButton deselectJButton;
    protected JButton deselectAllJButton;
    protected JButton selectJButton;
    protected JList selectedJList;
    protected DefaultListModel selectedJListModel;
    protected JButton upJButton;

    public ChooseManyReferenceDataPanel(ChooseManyReferenceDataPropertyEditor propertyEditor, DesignProperty liveProperty) {
        super(propertyEditor, liveProperty);
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        if (DESELECT_ACTION.equals(event.getActionCommand())) {
            this.handleDeselectAction(event);
            return;
        }
        if (DESELECT_ALL_ACTION.equals(event.getActionCommand())) {
            this.handleDeselectAllAction(event);
            return;
        }
        if (SELECT_ACTION.equals(event.getActionCommand())) {
            this.handleSelectAction(event);
            return;
        }
        if (DOWN_ACTION.equals(event.getActionCommand())) {
            this.handleDownAction(event);
            return;
        }
        if (UP_ACTION.equals(event.getActionCommand())) {
            this.handleUpAction(event);
            return;
        }
    }

    protected void adjustLeftColumnWidthIfNecessary(ReferenceDataItem item) {
        ReferenceDataTwoColumnListCellRenderer renderer = (ReferenceDataTwoColumnListCellRenderer)this.selectedJList.getCellRenderer();
        renderer.getListCellRendererComponent(this.choicesJList, item, -1, false, false);
        renderer.adjustLeftColumnWidthIfNecessary();
    }

    protected ChooseManyReferenceDataPropertyEditor getChooseManyReferenceDataPropertyEditor() {
        return (ChooseManyReferenceDataPropertyEditor)this.getPropertyEditor();
    }

    protected int getListSelectionStyle() {
        return 2;
    }

    public Object getPropertyValue() {
        Object[] selectedItems = this.getSelectedItems();
        if (selectedItems == null || selectedItems.length == 0) {
            return null;
        }
        String string = this.getChooseManyReferenceDataPropertyEditor().getStringForManyItems(selectedItems);
        return string;
    }

    protected ReferenceDataItem[] getSelectedItems() {
        ReferenceDataItem[] result = new ReferenceDataItem[this.selectedJListModel.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (ReferenceDataItem)this.selectedJListModel.get(i);
        }
        return result;
    }

    protected Map getSelectedItemsMap() {
        IdentityHashMap<ReferenceDataItem, Object> map = new IdentityHashMap<ReferenceDataItem, Object>();
        ReferenceDataItem[] items = this.getSelectedItems();
        Object dummy = new Object();
        for (int i = 0; i < items.length; ++i) {
            ReferenceDataItem item = items[i];
            map.put(item, dummy);
        }
        return map;
    }

    protected String getTopLabel() {
        return this.getCompositeReferenceData().getChooseManyTitle();
    }

    protected int getValueLabelGridWidth() {
        return 6;
    }

    protected void grabCurrentValueFromPropertyEditor() {
    }

    protected void handleDeselectAction(ActionEvent event) {
        Object[] values = this.selectedJList.getSelectedValues();
        for (int i = 0; i < values.length; ++i) {
            this.selectedJListModel.removeElement(values[i]);
        }
        this.updateButtonsState();
    }

    protected void handleDeselectAllAction(ActionEvent event) {
        this.selectedJListModel.clear();
        this.updateButtonsState();
    }

    protected void handleDownAction(ActionEvent event) {
        int[] indices = this.selectedJList.getSelectedIndices();
        int maxIndex = this.selectedJListModel.size() - 1;
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            if (index >= maxIndex) continue;
            Object swap = this.selectedJListModel.elementAt(index + 1);
            this.selectedJListModel.set(index + 1, this.selectedJListModel.elementAt(index));
            this.selectedJListModel.set(index, swap);
            int n = i;
            indices[n] = indices[n] + 1;
        }
        this.selectedJList.setSelectedIndices(indices);
    }

    protected void handleSelectAction(ActionEvent event) {
        Object[] values = this.choicesJList.getSelectedValues();
        int[] toSelect = new int[values.length];
        int lastToSelect = 0;
        for (int i = 0; i < values.length; ++i) {
            ReferenceDataItem item = (ReferenceDataItem)values[i];
            if (!this.getChooseManyReferenceDataPropertyEditor().getAllowDuplicates() && this.getSelectedItemsMap().containsKey(item)) continue;
            toSelect[lastToSelect] = this.selectedJListModel.size();
            ++lastToSelect;
            this.selectedJListModel.addElement(item);
            this.adjustLeftColumnWidthIfNecessary(item);
        }
        if (lastToSelect != values.length) {
            int[] nArray = toSelect;
            toSelect = new int[lastToSelect];
            System.arraycopy(nArray, 0, toSelect, 0, lastToSelect);
        }
        this.updateButtonsState();
        this.selectedJList.setSelectedIndices(toSelect);
        if (toSelect.length > 0) {
            this.selectedJList.ensureIndexIsVisible(toSelect[0]);
        }
    }

    protected void handleSelectedJListSelectionChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (this.selectedJList != null) {
            this.updateButtonsState();
        }
    }

    protected void handleUpAction(ActionEvent event) {
        int index;
        int[] indices = this.selectedJList.getSelectedIndices();
        int i = 0;
        while (i < indices.length && (index = indices[i]) > 0) {
            Object swap = this.selectedJListModel.elementAt(index - 1);
            this.selectedJListModel.set(index - 1, this.selectedJListModel.elementAt(index));
            this.selectedJListModel.set(index, swap);
            int n = i++;
            indices[n] = indices[n] - 1;
        }
        this.selectedJList.setSelectedIndices(indices);
    }

    protected boolean includeInChoicesJList(ReferenceDataItem item) {
        if (super.includeInChoicesJList(item)) {
            return item.getName().length() > 0;
        }
        return false;
    }

    protected void initializeComponents() {
        super.initializeComponents();
        JPanel selectButtonsPanel = new JPanel();
        selectButtonsPanel.setLayout(new BoxLayout(selectButtonsPanel, 1));
        this.selectJButton = new JButton(">");
        this.selectJButton.setMaximumSize(new Dimension(200, 200));
        this.selectJButton.setActionCommand(SELECT_ACTION);
        this.selectJButton.addActionListener(this);
        this.selectJButton.setEnabled(false);
        selectButtonsPanel.add((Component)this.selectJButton, null);
        selectButtonsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.deselectJButton = new JButton("<");
        this.deselectJButton.setMaximumSize(new Dimension(200, 200));
        this.deselectJButton.setActionCommand(DESELECT_ACTION);
        this.deselectJButton.addActionListener(this);
        this.deselectJButton.setEnabled(false);
        selectButtonsPanel.add((Component)this.deselectJButton, null);
        selectButtonsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.deselectAllJButton = new JButton("<<");
        this.deselectAllJButton.setMaximumSize(new Dimension(200, 200));
        this.deselectAllJButton.setActionCommand(DESELECT_ALL_ACTION);
        this.deselectAllJButton.addActionListener(this);
        selectButtonsPanel.add((Component)this.deselectAllJButton, null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)selectButtonsPanel, gridBagConstraints);
        JLabel label = new JLabel();
        label.setText(BundleHolder.bundle.getMessage("Available"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)label, gridBagConstraints);
        label = new JLabel();
        label.setText(BundleHolder.bundle.getMessage("sel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)label, gridBagConstraints);
        Component component = this.initializeSelectedListComponent();
        JScrollPane selectedJListScrollPane = new JScrollPane(component);
        selectedJListScrollPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)selectedJListScrollPane, gridBagConstraints);
        if (this.getCompositeReferenceData().canOrderItems()) {
            JPanel moveButtonsPanel = new JPanel();
            moveButtonsPanel.setLayout(new BoxLayout(moveButtonsPanel, 1));
            this.upJButton = new JButton(BundleHolder.bundle.getMessage(UP_ACTION));
            this.upJButton.setMaximumSize(new Dimension(200, 200));
            this.upJButton.setActionCommand(UP_ACTION);
            this.upJButton.addActionListener(this);
            this.upJButton.setEnabled(false);
            moveButtonsPanel.add(this.upJButton);
            moveButtonsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            this.downJButton = new JButton(BundleHolder.bundle.getMessage(DOWN_ACTION));
            this.downJButton.setMaximumSize(new Dimension(200, 200));
            this.downJButton.setActionCommand(DOWN_ACTION);
            this.downJButton.setEnabled(false);
            this.downJButton.addActionListener(this);
            moveButtonsPanel.add(this.downJButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 19;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            this.add((Component)moveButtonsPanel, gridBagConstraints);
        }
    }

    protected Component initializeSelectedListComponent() {
        this.selectedJListModel = new DefaultListModel();
        this.selectedJList = new JList(this.selectedJListModel);
        this.selectedJList.setSelectionMode(this.getListSelectionStyle());
        this.selectedJList.setLayoutOrientation(0);
        this.selectedJList.setVisibleRowCount(-1);
        this.selectedJList.setCellRenderer(new ReferenceDataTwoColumnListCellRenderer());
        this.populateSelectedJListModel();
        this.selectedJList.addListSelectionListener(this);
        return this.selectedJList;
    }

    protected void populateSelectedJListModel() {
        this.selectedJListModel.clear();
        ReferenceDataTwoColumnListCellRenderer renderer = (ReferenceDataTwoColumnListCellRenderer)this.selectedJList.getCellRenderer();
        renderer.resetLeftColumnWidth();
        ReferenceDataItem[] items = this.getChooseManyReferenceDataPropertyEditor().getValueReferenceDataItems();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                ReferenceDataItem item = items[i];
                this.selectedJListModel.addElement(item);
                renderer.getListCellRendererComponent(this.choicesJList, item, -1, false, false);
                renderer.adjustLeftColumnWidthIfNecessary();
            }
        }
    }

    protected void updateButtonsState() {
        super.updateButtonsState();
        boolean hasSelections = this.choicesJList.getSelectedIndices().length > 0;
        this.selectJButton.setEnabled(hasSelections);
        if (this.selectedJList != null) {
            hasSelections = this.selectedJList.getSelectedIndices().length > 0;
            this.deselectJButton.setEnabled(hasSelections);
            this.deselectAllJButton.setEnabled(this.selectedJListModel.size() > 0);
            if (this.getCompositeReferenceData().canOrderItems()) {
                this.upJButton.setEnabled(this.selectedJList.getMinSelectionIndex() > 0);
                this.downJButton.setEnabled(this.selectedJList.getMaxSelectionIndex() >= 0 && this.selectedJList.getMaxSelectionIndex() < this.selectedJListModel.size() - 1);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        super.valueChanged(event);
        if (event.getSource() == this.selectedJList) {
            this.handleSelectedJListSelectionChanged(event);
        }
    }
}

