/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.AbstractPropertyEditor;
import com.sun.jsfcl.std.property.ChooseOneReferenceDataPanel;
import com.sun.jsfcl.std.property.LocalizedMessageRuntimeException;
import com.sun.jsfcl.std.reference.CompositeReferenceData;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import com.sun.jsfcl.std.reference.ReferenceDataManager;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

public class ChooseOneReferenceDataPropertyEditor
extends AbstractPropertyEditor {
    public static final String REFERENCE_DATA_NAME = "referenceDataDefiner";
    protected static final int MAX_CHOICE_COUNT_FOR_TAGS = 8;
    protected CompositeReferenceData compositeReferenceData;
    protected long lastRefreshTime;
    protected ReferenceDataItem valueReferenceDataItem;

    public void attachToNewDesignProperty() {
        super.attachToNewDesignProperty();
        this.compositeReferenceData = this.getCompositeReferenceDataImp();
        this.setValue(this.getDesignProperty().getValue());
    }

    public String getAsText() {
        return this.getStringForItem(this.valueReferenceDataItem);
    }

    public CompositeReferenceData getCompositeReferenceDataImp() {
        String name = (String)this.getDesignProperty().getPropertyDescriptor().getValue(REFERENCE_DATA_NAME);
        if (name == null) {
            throw new RuntimeException("Property named: " + this.getDesignProperty().getPropertyDescriptor().getDisplayName() + " has no " + REFERENCE_DATA_NAME + "specified !!!");
        }
        CompositeReferenceData result = ReferenceDataManager.getInstance().getCompositeReferenceData(name, this.getProject(), this.getDesignProperty());
        if (result == null) {
            throw new RuntimeException("Property named: " + this.getDesignProperty().getPropertyDescriptor().getDisplayName() + " got null for reference data named: " + name);
        }
        return result;
    }

    public Component getCustomEditor() {
        return new ChooseOneReferenceDataPanel(this, this.getDesignProperty());
    }

    public ReferenceDataItem getItemByName(String name) {
        if (name == null) {
            return this.getItemByValue(null);
        }
        name = name.trim();
        Iterator iterator = this.getItems().iterator();
        while (iterator.hasNext()) {
            ReferenceDataItem item = (ReferenceDataItem)iterator.next();
            if (!name.equals(item.getName())) continue;
            return item;
        }
        if (this.getCompositeReferenceData().canAddRemoveItems()) {
            ReferenceDataItem item = this.getCompositeReferenceData().getDefiner().newItem(name, name, false, true);
            this.getCompositeReferenceData().add(item);
            return item;
        }
        return null;
    }

    public ReferenceDataItem getItemByValue(Object value) {
        Iterator iterator = this.getItems().iterator();
        while (iterator.hasNext()) {
            ReferenceDataItem item = (ReferenceDataItem)iterator.next();
            if (!(value == null ? item.getValue() == null : value.equals(item.getValue()))) continue;
            return item;
        }
        return null;
    }

    public List getItems() {
        return this.getCompositeReferenceData().getItemsSorted();
    }

    public CompositeReferenceData getCompositeReferenceData() {
        return this.compositeReferenceData;
    }

    public String getJavaInitializationString() {
        if (this.valueReferenceDataItem == null || this.valueReferenceDataItem.isUnsetMarker()) {
            return null;
        }
        if (this.valueReferenceDataItem.getJavaInitializationString() != null) {
            return this.valueReferenceDataItem.getJavaInitializationString();
        }
        if (this.valueReferenceDataItem.getValue() == null) {
            return null;
        }
        if (this.valueReferenceDataItem.getValue() instanceof String) {
            return ChooseOneReferenceDataPropertyEditor.stringToJavaSourceString((String)this.valueReferenceDataItem.getValue());
        }
        throw new RuntimeException("Badly setup reference data item: " + this.getCompositeReferenceData().getName() + ":" + this.valueReferenceDataItem.getName());
    }

    protected String getStringForItem(ReferenceDataItem item) {
        if (item == null) {
            return "";
        }
        String string = this.getCompositeReferenceData().isValueAString() ? (String)item.getValue() : item.getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String[] getTags() {
        if (this.getCompositeReferenceData().canAddRemoveItems()) {
            return null;
        }
        List items = this.getItems();
        if (items.size() > 8) {
            return null;
        }
        String[] result = new String[items.size()];
        int i = 0;
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            result[i] = ((ReferenceDataItem)iterator.next()).getName();
            ++i;
        }
        return result;
    }

    public ReferenceDataItem getValueReferenceDataItem() {
        return this.valueReferenceDataItem;
    }

    public boolean isPaintable() {
        if (System.currentTimeMillis() - this.lastRefreshTime > 10000L) {
            this.refreshItems();
            this.lastRefreshTime = System.currentTimeMillis();
        }
        return super.isPaintable();
    }

    public void refreshItems() {
        this.getCompositeReferenceData().invalidateDesignContextRelatedCaches();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.valueReferenceDataItem = this.getItemByName(text);
        if (this.valueReferenceDataItem == null) {
            super.setValue(null);
            throw new LocalizedMessageRuntimeException("Unknown value: \"" + text + "\"");
        }
        super.setValue(this.valueReferenceDataItem.getValue());
    }

    public void setValue(Object object) {
        this.setValueImp(object);
        super.setValue(object);
    }

    public void setValueImp(Object object) {
        this.valueReferenceDataItem = this.getItemByValue(object);
    }

    public boolean supportsCustomEditor() {
        if (this.getCompositeReferenceData().canAddRemoveItems()) {
            return true;
        }
        return this.getItems().size() > 8;
    }
}

