/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.AbstractPropertyEditor;

public class LengthValuePropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        String value = (String)this.getValue();
        if (value == null || value.length() == 0) {
            return "";
        }
        return value;
    }

    public String getJavaInitializationString() {
        return LengthValuePropertyEditor.stringToJavaSourceString(this.getAsText());
    }

    public void setAsText(String string) {
        string = string.trim();
        boolean unset = true;
        boolean isPercent = false;
        String value = null;
        if (string != null && string.length() > 0) {
            try {
                int number;
                if (string.endsWith("%")) {
                    isPercent = true;
                    string = string.substring(0, string.length() - 1).trim();
                }
                if ((number = Integer.parseInt(string)) >= 0) {
                    value = String.valueOf(number);
                    if (isPercent) {
                        value = number + "%";
                    }
                    unset = false;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.setValue(value);
        if (unset) {
            this.unsetProperty();
        }
    }
}

