/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.BundleHolder;
import com.sun.jsfcl.std.reference.CompositeReferenceData;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class NewReferenceDataItemDialog
extends JPanel
implements DocumentListener,
UndoableEditListener,
ActionListener {
    protected JButton cancelButton;
    protected JDialog dialog;
    protected JTextField nameTextField;
    protected JButton okButton;
    protected CompositeReferenceData referenceData;
    protected JCheckBox sameCheckBox;
    protected JTextField valueTextField;
    protected ReferenceDataItem newItem;

    public NewReferenceDataItemDialog(CompositeReferenceData referenceData) {
        this.referenceData = referenceData;
        this.initializeComponents();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.sameCheckBox) {
            if (this.isValueSameAsName()) {
                this.valueTextField.setEditable(false);
            } else {
                this.valueTextField.setEditable(true);
                this.valueTextField.selectAll();
                this.valueTextField.requestFocusInWindow();
            }
            this.handleNameTextChanged();
        } else if (source == this.okButton) {
            this.handleOkButton();
        } else if (source == this.cancelButton && this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (e.getDocument() == this.nameTextField.getDocument()) {
            this.handleNameTextChanged();
        } else if (e.getDocument() == this.valueTextField.getDocument()) {
            this.handleValueTextChanged();
        }
    }

    protected void addDialogButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        this.okButton = new JButton(BundleHolder.bundle.getMessage("OK"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.cancelButton = new JButton(BundleHolder.bundle.getMessage("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)buttonPanel, gridBagConstraints);
    }

    public void handleNameTextChanged() {
        if (this.isValueSameAsName()) {
            this.valueTextField.setText(this.nameTextField.getText());
        }
    }

    public void handleValueTextChanged() {
    }

    protected void handleOkButton() {
        String name = this.nameTextField.getText().trim();
        String value = this.valueTextField.getText().trim();
        this.newItem = this.referenceData.getDefiner().newItem(name, value, null, false, true);
        this.newItem.setIsRemovable(true);
        String message = value.length() == 0 ? BundleHolder.bundle.getMessage("newReferenceDataItemEmptyValueError") : (this.referenceData.getItems().indexOf(this.newItem) >= 0 ? BundleHolder.bundle.getMessage("newReferenceDataItemAlreadyExistError", value) : null);
        if (message == null) {
            this.referenceData.add(this.newItem);
            this.dialog.setVisible(false);
        } else {
            this.newItem = null;
            JOptionPane.showMessageDialog(this.dialog, message);
        }
    }

    protected void initializeComponents() {
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel();
        label.setText(BundleHolder.bundle.getMessage("newReferenceDataItemName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 10, 0, 5);
        this.add((Component)label, gridBagConstraints);
        this.nameTextField = new JTextField();
        this.nameTextField.setColumns(20);
        this.nameTextField.getDocument().addDocumentListener(this);
        this.nameTextField.getDocument().addUndoableEditListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        label = new JLabel();
        label.setText(BundleHolder.bundle.getMessage("newReferenceDataItemValue"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 10, 0, 5);
        this.add((Component)label, gridBagConstraints);
        this.valueTextField = new JTextField();
        this.valueTextField.setEditable(false);
        this.valueTextField.getDocument().addDocumentListener(this);
        this.valueTextField.getDocument().addUndoableEditListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.valueTextField, gridBagConstraints);
        this.sameCheckBox = new JCheckBox(BundleHolder.bundle.getMessage("newReferenceDataItemSameCheckbox"), true);
        this.sameCheckBox.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.sameCheckBox, gridBagConstraints);
    }

    protected boolean isValueSameAsName() {
        return this.sameCheckBox.getModel().isSelected();
    }

    public void insertUpdate(DocumentEvent e) {
        if (e.getDocument() == this.nameTextField.getDocument()) {
            this.handleNameTextChanged();
        } else if (e.getDocument() == this.valueTextField.getDocument()) {
            this.handleValueTextChanged();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (e.getDocument() == this.nameTextField.getDocument()) {
            this.handleNameTextChanged();
        } else if (e.getDocument() == this.valueTextField.getDocument()) {
            this.handleValueTextChanged();
        }
    }

    public ReferenceDataItem showDialog(JPanel parent) {
        this.addDialogButtons();
        Dialog parentDialog = (Dialog)parent.getRootPane().getParent();
        this.dialog = new JDialog(parentDialog, BundleHolder.bundle.getMessage("newReferenceDataItemPanelTitle", this.referenceData.getDisplayName()), true);
        this.dialog.setContentPane(this);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog);
        this.nameTextField.requestFocusInWindow();
        this.dialog.show();
        this.dialog.dispose();
        this.dialog = null;
        this.cancelButton = null;
        this.okButton = null;
        return this.newItem;
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        if (e.getSource() == this.nameTextField) {
            this.handleNameTextChanged();
        } else if (e.getSource() == this.valueTextField) {
            this.handleValueTextChanged();
        }
    }
}

