/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.NumberPatternPropertyEditor;
import com.sun.rave.designtime.DesignProperty;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.openide.util.NbBundle;

public class NumberPatternPanel
extends JPanel {
    private DesignProperty designProperty;
    private NumberPatternPropertyEditor propertyEditor;
    private JButton btnTest;
    private JComboBox cmbExample;
    private JComboBox cmbPattern;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JLabel lblExample;
    private JLabel lblPattern;
    private JLabel lblResults;
    private JPanel pnlExample;
    private JTextPane txtExampleInstructions;
    private JTextField txtResults;

    public NumberPatternPanel(NumberPatternPropertyEditor propertyEditor, DesignProperty liveProperty) {
        this.propertyEditor = propertyEditor;
        this.designProperty = liveProperty;
        this.initComponents();
        NumberFormat form1 = NumberFormat.getInstance();
        NumberFormat form2 = NumberFormat.getIntegerInstance();
        NumberFormat form3 = NumberFormat.getCurrencyInstance();
        NumberFormat form4 = NumberFormat.getPercentInstance();
        this.cmbPattern.setModel(new DefaultComboBoxModel<String>(new String[]{"", ((DecimalFormat)form1).toPattern(), ((DecimalFormat)form2).toPattern(), ((DecimalFormat)form3).toPattern(), ((DecimalFormat)form4).toPattern()}));
        this.cmbExample.setModel(new DefaultComboBoxModel<String>(new String[]{"1234.56", "-1234.56", "123.4567", "0.123", "01234"}));
        if (this.designProperty != null) {
            this.cmbPattern.setSelectedItem(this.designProperty.getValue());
        }
    }

    public void addPatternListener(ActionListener listener) {
        this.cmbPattern.addActionListener(listener);
    }

    private boolean upateSampleResult() {
        double sampleNumber = 0.0;
        try {
            if (this.cmbExample.getSelectedItem() == null || ((String)this.cmbExample.getSelectedItem()).trim().length() == 0) {
                return true;
            }
            sampleNumber = Double.parseDouble((String)this.cmbExample.getSelectedItem());
        }
        catch (NumberFormatException ne) {
            this.txtResults.setText(NbBundle.getMessage((Class)NumberPatternPanel.class, (String)"notANumber", (Object)((String)this.cmbExample.getSelectedItem())));
            return false;
        }
        try {
            if (this.cmbPattern.getSelectedItem() == null || ((String)this.cmbPattern.getSelectedItem()).trim().length() == 0) {
                return true;
            }
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance();
            decimalFormat.applyPattern(((String)this.cmbPattern.getSelectedItem()).trim());
            this.txtResults.setText(decimalFormat.format(sampleNumber));
        }
        catch (IllegalArgumentException ie) {
            this.txtResults.setText(NbBundle.getMessage((Class)NumberPatternPanel.class, (String)"badPattern", (Object)((String)this.cmbPattern.getSelectedItem())));
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.lblPattern = new JLabel();
        this.cmbPattern = new JComboBox();
        this.pnlExample = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.lblExample = new JLabel();
        this.txtResults = new JTextField();
        this.lblResults = new JLabel();
        this.cmbExample = new JComboBox();
        this.btnTest = new JButton();
        this.txtExampleInstructions = new JTextPane();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblPattern.setLabelFor(this.cmbPattern);
        this.lblPattern.setText(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("pattern"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.lblPattern, gridBagConstraints);
        this.lblPattern.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("pattern"));
        this.cmbPattern.setEditable(true);
        this.cmbPattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NumberPatternPanel.this.cmbPatternActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.cmbPattern, gridBagConstraints);
        this.cmbPattern.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("pattern"));
        this.pnlExample.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.pnlExample.add((Component)this.jSeparator1, gridBagConstraints);
        this.lblExample.setDisplayedMnemonic('a');
        this.lblExample.setLabelFor(this.cmbExample);
        this.lblExample.setText(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("example"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.pnlExample.add((Component)this.lblExample, gridBagConstraints);
        this.lblExample.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("example"));
        this.txtResults.setEditable(false);
        this.txtResults.setText("1234.56");
        this.txtResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NumberPatternPanel.this.txtResultsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.pnlExample.add((Component)this.txtResults, gridBagConstraints);
        this.txtResults.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("results"));
        this.lblResults.setDisplayedMnemonic('R');
        this.lblResults.setLabelFor(this.txtResults);
        this.lblResults.setText(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("results"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.pnlExample.add((Component)this.lblResults, gridBagConstraints);
        this.lblResults.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("results"));
        this.cmbExample.setEditable(true);
        this.cmbExample.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NumberPatternPanel.this.cmbExampleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.pnlExample.add((Component)this.cmbExample, gridBagConstraints);
        this.cmbExample.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("example"));
        this.btnTest.setMnemonic('e');
        this.btnTest.setText(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("test"));
        this.btnTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NumberPatternPanel.this.btnTestActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.pnlExample.add((Component)this.btnTest, gridBagConstraints);
        this.btnTest.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("test"));
        this.txtExampleInstructions.setBackground(this.getBackground());
        this.txtExampleInstructions.setBorder(null);
        this.txtExampleInstructions.setEditable(false);
        this.txtExampleInstructions.setText(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("exampleInstruction"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 11);
        this.pnlExample.add((Component)this.txtExampleInstructions, gridBagConstraints);
        this.txtExampleInstructions.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("exampleInstruction"));
        this.txtExampleInstructions.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/jsfcl/std/property/Bundle").getString("exampleInstruction"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.pnlExample, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void txtResultsActionPerformed(ActionEvent evt) {
    }

    private void cmbExampleActionPerformed(ActionEvent evt) {
        this.upateSampleResult();
    }

    private void btnTestActionPerformed(ActionEvent evt) {
        this.upateSampleResult();
    }

    private void cmbPatternActionPerformed(ActionEvent evt) {
        if (this.upateSampleResult()) {
            this.propertyEditor.setAsText((String)this.cmbPattern.getSelectedItem());
        }
    }
}

