/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.reference.ReferenceDataItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ReferenceDataTwoColumnListCellRenderer
extends JPanel
implements ListCellRenderer {
    protected static final int COLUMN_GAP = 5;
    protected static final Dimension MAX_DIMENSION = new Dimension(Short.MAX_VALUE, 0);
    protected static final Dimension MIN_DIMENSION = new Dimension(0, 0);
    protected static final Dimension COLUMN_GAP_DIMENSION = new Dimension(5, 0);
    protected int leftColumnWidth = -1;
    protected JLabel leftLabel = new JLabel();
    protected boolean wantsSecondLabel = true;
    protected JLabel rightLabel;

    public static String[] getLabels(ReferenceDataItem item) {
        String itemNameString = item.getName();
        Object itemValue = item.getValue();
        String itemValueString = " ";
        if (itemValue instanceof String) {
            itemValueString = (String)itemValue;
            itemValueString = itemValueString.equals(itemNameString) ? " " : "[" + itemValueString + "]";
        }
        return new String[]{itemNameString, itemValueString};
    }

    public ReferenceDataTwoColumnListCellRenderer() {
        this.leftLabel.setOpaque(true);
        this.rightLabel = new JLabel();
        this.rightLabel.setOpaque(true);
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.leftLabel);
        this.add(new Box.Filler(null, null, null){

            public Dimension getMinimumSize() {
                if (ReferenceDataTwoColumnListCellRenderer.this.wantsSecondLabel) {
                    return COLUMN_GAP_DIMENSION;
                }
                return MIN_DIMENSION;
            }

            public Dimension getPreferredSize() {
                if (ReferenceDataTwoColumnListCellRenderer.this.wantsSecondLabel) {
                    if (ReferenceDataTwoColumnListCellRenderer.this.leftColumnWidth != -1) {
                        return new Dimension(Math.max(ReferenceDataTwoColumnListCellRenderer.this.leftColumnWidth + 5 - (int)ReferenceDataTwoColumnListCellRenderer.this.leftLabel.getPreferredSize().getWidth(), 5), 0);
                    }
                    return COLUMN_GAP_DIMENSION;
                }
                return MIN_DIMENSION;
            }

            public Dimension getMaximumSize() {
                if (ReferenceDataTwoColumnListCellRenderer.this.wantsSecondLabel) {
                    if (ReferenceDataTwoColumnListCellRenderer.this.leftColumnWidth == -1) {
                        return MAX_DIMENSION;
                    }
                    return new Dimension(Math.max(ReferenceDataTwoColumnListCellRenderer.this.leftColumnWidth + 5 - (int)ReferenceDataTwoColumnListCellRenderer.this.leftLabel.getPreferredSize().getWidth(), 5), 0);
                }
                return MIN_DIMENSION;
            }
        });
        this.add(this.rightLabel);
        this.setOpaque(true);
    }

    public void adjustLeftColumnWidthIfNecessary() {
        int w = (int)this.leftLabel.getPreferredSize().getWidth();
        if (w > this.leftColumnWidth) {
            this.leftColumnWidth = w;
            this.invalidate();
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color foregroundColor;
        Color backgroundColor;
        ReferenceDataItem item = (ReferenceDataItem)value;
        if (isSelected) {
            backgroundColor = list.getSelectionBackground();
            foregroundColor = list.getSelectionForeground();
        } else {
            backgroundColor = list.getBackground();
            foregroundColor = list.getForeground();
        }
        this.setBackground(backgroundColor);
        this.leftLabel.setBackground(backgroundColor);
        this.rightLabel.setBackground(backgroundColor);
        this.setForeground(foregroundColor);
        this.leftLabel.setForeground(foregroundColor);
        this.rightLabel.setForeground(foregroundColor);
        Font font = list.getFont();
        this.setFont(font);
        this.leftLabel.setFont(font);
        this.rightLabel.setFont(font);
        String[] labels = ReferenceDataTwoColumnListCellRenderer.getLabels(item);
        this.leftLabel.setText(labels[0]);
        this.rightLabel.setText(labels[1]);
        this.invalidate();
        return this;
    }

    public void resetLeftColumnWidth() {
        this.leftColumnWidth = -1;
    }
}

