/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.reference;

import com.sun.jsfcl.std.reference.BaseReferenceData;
import com.sun.jsfcl.std.reference.DesignPropertyAttachedReferenceData;
import com.sun.jsfcl.std.reference.ProjectAttachedReferenceData;
import com.sun.jsfcl.std.reference.ReferenceData;
import com.sun.jsfcl.std.reference.ReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import com.sun.jsfcl.std.reference.ReferenceDataManager;
import java.util.List;

public class CompositeReferenceData
extends ReferenceData {
    protected BaseReferenceData baseReferenceData;
    protected List itemsSorted;
    protected ProjectAttachedReferenceData projectReferenceData;
    protected Object projectVersionMarker;
    protected DesignPropertyAttachedReferenceData livePropertyReferenceData;

    public CompositeReferenceData(ReferenceDataManager manager, String name, ReferenceDataDefiner definer, BaseReferenceData baseReferenceData, ProjectAttachedReferenceData projectReferenceData, DesignPropertyAttachedReferenceData livePropertyReferenceData) {
        super(manager, definer, name);
        this.name = name;
        this.baseReferenceData = baseReferenceData;
        this.projectReferenceData = projectReferenceData;
        if (projectReferenceData != null) {
            definer = projectReferenceData.getDefiner();
        }
        this.livePropertyReferenceData = livePropertyReferenceData;
    }

    public void add(ReferenceDataItem item) {
        if (this.projectReferenceData != null) {
            this.projectReferenceData.add(item);
            this.invalidateItemsCache();
        }
    }

    public boolean canAddRemoveItems() {
        return this.projectReferenceData != null && this.projectReferenceData.canAddRemoveItems();
    }

    protected void defineItems() {
        if (this.baseReferenceData != null) {
            this.items.addAll(this.baseReferenceData.getItems());
        }
        if (this.projectReferenceData != null) {
            this.items.addAll(this.projectReferenceData.getItems());
        }
        if (this.livePropertyReferenceData != null) {
            this.items.addAll(this.livePropertyReferenceData.getItems());
        }
    }

    public List getItems() {
        if (this.items != null && this.projectReferenceData != null && this.projectReferenceData.getVersionMarker() != this.projectVersionMarker) {
            this.invalidateItemsCache();
            this.projectVersionMarker = this.projectReferenceData.getVersionMarker();
        }
        return super.getItems();
    }

    public List getItemsSorted() {
        if (this.itemsSorted != null && this.projectReferenceData != null && this.projectReferenceData.getVersionMarker() != this.projectVersionMarker) {
            this.invalidateItemsCache();
        }
        if (this.itemsSorted == null) {
            this.itemsSorted = ReferenceDataItem.sorted(this.getItems());
        }
        return this.itemsSorted;
    }

    public void invalidateItemsCache() {
        super.invalidateItemsCache();
        this.itemsSorted = null;
    }

    public void invalidateDesignContextRelatedCaches() {
        if (this.livePropertyReferenceData != null) {
            this.livePropertyReferenceData.invalidateItemsCache();
            this.invalidateItemsCache();
        }
    }

    public void remove(ReferenceDataItem item) {
        if (this.projectReferenceData != null) {
            this.projectReferenceData.remove(item);
            this.invalidateItemsCache();
        }
    }
}

