/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.util;

import java.beans.Beans;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;

public class ComponentBundle {
    private static MessageFormat mf = new MessageFormat("");
    private ResourceBundle rb;
    private static final String DESIGN_TIME_IMPL_CLASS = "com.sun.jsfcl.util.DesignTimeComponentBundle";
    private static Map componentBundleMap = new Hashtable();

    protected ComponentBundle() {
    }

    public void init(String baseName, ClassLoader classLoader) {
        this.rb = ResourceBundle.getBundle(baseName, mf.getLocale(), classLoader);
    }

    public String getMessage(String key) {
        String string = this.rb.getString(key);
        return string;
    }

    public String getMessage(String key, Object arg1) {
        return this.getMessage(key, new Object[]{arg1});
    }

    public String getMessage(String key, Object arg1, Object arg2) {
        return this.getMessage(key, new Object[]{arg1, arg2});
    }

    public String getMessage(String key, Object arg1, Object arg2, Object arg3) {
        return this.getMessage(key, new Object[]{arg1, arg2, arg3});
    }

    public String getMessage(String key, Object[] args) {
        return this.getMessage(key, args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(String key, Object[] args, boolean escapeSingleQuotes) {
        String message;
        String pattern = this.getMessage(key);
        if (escapeSingleQuotes) {
            pattern = pattern.replaceAll("'", "''");
        }
        MessageFormat messageFormat = mf;
        synchronized (messageFormat) {
            mf.applyPattern(pattern);
            message = mf.format(args);
        }
        return message;
    }

    public static ComponentBundle getBundle(Class c) {
        return ComponentBundle.getBundle(c, null);
    }

    public static ComponentBundle getBundle(Class c, String suffix) {
        ComponentBundle cb;
        String className = c.getName();
        int lastDotIndex = className.lastIndexOf(46);
        String packageName = "";
        if (lastDotIndex > -1) {
            packageName = className.substring(0, lastDotIndex + 1);
        }
        String baseName = packageName + "Bundle";
        if (suffix != null && suffix.length() > 0) {
            baseName = baseName + suffix;
        }
        if ((cb = (ComponentBundle)componentBundleMap.get(baseName)) == null) {
            if (Beans.isDesignTime()) {
                try {
                    cb = (ComponentBundle)Class.forName(DESIGN_TIME_IMPL_CLASS).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create instance of com.sun.jsfcl.util.DesignTimeComponentBundle", e);
                }
            } else {
                cb = new ComponentBundle();
            }
            cb.init(baseName, c.getClassLoader());
            componentBundleMap.put(baseName, cb);
        }
        return cb;
    }
}

