/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.util;

import com.sun.jsfcl.util.ComponentBundle;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;

public class DesignTimeComponentBundle
extends ComponentBundle {
    private static final boolean isDebugOn = Boolean.getBoolean("org.openide.util.NbBundle.DEBUG");

    public void init(String baseName, ClassLoader classLoader) {
        super.init(baseName, isDebugOn ? DebugLoader.get(classLoader) : classLoader);
    }

    private static final class DebugLoader
    extends ClassLoader {
        private static int count = 0;
        private static final Map knownIDs = new HashMap();
        private static final Map existing = new WeakHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int getID(String name) {
            Map map = knownIDs;
            synchronized (map) {
                Integer i = (Integer)knownIDs.get(name);
                if (i == null) {
                    i = new Integer(++count);
                    knownIDs.put(name, i);
                    System.err.println("ComponentBundle trace: #" + i + " = " + name);
                }
                return i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ClassLoader get(ClassLoader normal) {
            Map map = existing;
            synchronized (map) {
                ClassLoader dl;
                Reference r = (Reference)existing.get(normal);
                if (r != null && (dl = (ClassLoader)r.get()) != null) {
                    return dl;
                }
                dl = new DebugLoader(normal);
                existing.put(normal, new WeakReference<ClassLoader>(dl));
                return dl;
            }
        }

        private DebugLoader(ClassLoader cl) {
            super(cl);
        }

        public InputStream getResourceAsStream(String name) {
            InputStream base = super.getResourceAsStream(name);
            if (base == null) {
                return null;
            }
            if (name.endsWith(".properties")) {
                int id = DebugLoader.getID(name);
                boolean loc = name.indexOf("/Bundle.") != -1 || name.indexOf("/Bundle_") != -1;
                return new DebugInputStream(base, id, loc |= name.matches(".*/Bundle.*\\.properties"));
            }
            return base;
        }

        private static final class DebugInputStream
        extends InputStream {
            protected static final HashSet debugIgnoreKeySet = new HashSet();
            private final InputStream base;
            private final int id;
            private final boolean localizable;
            private int line = 0;
            private static final int WAITING_FOR_KEY = 0;
            private static final int IN_COMMENT = 1;
            private static final int IN_KEY = 2;
            private static final int IN_KEY_BACKSLASH = 3;
            private static final int AFTER_KEY = 4;
            private static final int WAITING_FOR_VALUE = 5;
            private static final int IN_VALUE = 6;
            private static final int IN_VALUE_BACKSLASH = 7;
            private int state = 0;
            private boolean twixtCrAndNl = false;
            private String toInsert = null;
            private boolean reverseLocalizable = false;
            private StringBuffer lastComment = null;
            private StringBuffer lastKey = null;

            public DebugInputStream(InputStream base, int id, boolean localizable) {
                this.base = base;
                this.id = id;
                this.localizable = localizable;
            }

            public int read() throws IOException {
                if (this.toInsert != null) {
                    char result = this.toInsert.charAt(0);
                    this.toInsert = this.toInsert.length() > 1 ? this.toInsert.substring(1) : null;
                    return result;
                }
                int next = this.base.read();
                if (next == 10) {
                    this.twixtCrAndNl = false;
                    ++this.line;
                } else if (next == 13) {
                    if (this.twixtCrAndNl) {
                        ++this.line;
                    } else {
                        this.twixtCrAndNl = true;
                    }
                } else {
                    this.twixtCrAndNl = false;
                }
                switch (this.state) {
                    case 0: {
                        switch (next) {
                            case 33: 
                            case 35: {
                                this.state = 1;
                                this.lastComment = new StringBuffer();
                                this.lastComment.append((char)next);
                                return next;
                            }
                            case -1: 
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                return next;
                            }
                            case 92: {
                                this.state = 3;
                                return next;
                            }
                        }
                        this.state = 2;
                        this.lastKey = new StringBuffer();
                        this.lastKey.append((char)next);
                        return next;
                    }
                    case 1: {
                        switch (next) {
                            case 10: 
                            case 13: {
                                String comment = this.lastComment.toString();
                                this.lastComment = null;
                                if (this.localizable && comment.equals("#NOI18N")) {
                                    this.reverseLocalizable = true;
                                } else if (this.localizable && comment.equals("#PARTNOI18N")) {
                                    System.err.println("ComponentBundle WARNING (" + this.id + ":" + this.line + "): #PARTNOI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && comment.equals("#I18N")) {
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && comment.equals("#PARTI18N")) {
                                    System.err.println("ComponentBundle WARNING (" + this.id + ":" + this.line + "): #PARTI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = false;
                                } else if (this.localizable && (comment.equals("#I18N") || comment.equals("#PARTI18N")) || !this.localizable && (comment.equals("#NOI18N") || comment.equals("#PARTNOI18N"))) {
                                    System.err.println("ComponentBundle WARNING (" + this.id + ":" + this.line + "): incongruous comment " + comment + " found for bundle");
                                    this.reverseLocalizable = false;
                                }
                                this.state = 0;
                                return next;
                            }
                        }
                        this.lastComment.append((char)next);
                        return next;
                    }
                    case 2: {
                        switch (next) {
                            case 92: {
                                this.state = 3;
                                return next;
                            }
                            case 9: 
                            case 32: {
                                this.state = 4;
                                return next;
                            }
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return next;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return next;
                            }
                        }
                        this.lastKey.append((char)next);
                        return next;
                    }
                    case 3: {
                        this.lastKey.append((char)next);
                        this.state = 2;
                        return next;
                    }
                    case 4: {
                        switch (next) {
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return next;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return next;
                            }
                        }
                        return next;
                    }
                    case 5: {
                        switch (next) {
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return next;
                            }
                            case 9: 
                            case 32: {
                                return next;
                            }
                            case 92: {
                                this.state = 7;
                                return next;
                            }
                        }
                        this.state = 6;
                        return next;
                    }
                    case 6: {
                        switch (next) {
                            case 92: {
                                this.state = 7;
                                return next;
                            }
                            case 10: 
                            case 13: {
                                if (!this.reverseLocalizable) {
                                    String key = this.lastKey.toString();
                                    this.reverseLocalizable = debugIgnoreKeySet.contains(key);
                                }
                                boolean revLoc = this.reverseLocalizable;
                                this.reverseLocalizable = false;
                                this.state = 0;
                                if (this.localizable ^ revLoc) {
                                    this.toInsert = "[" + this.id + ":" + this.line + "]" + new Character((char)next);
                                    return 32;
                                }
                                return next;
                            }
                        }
                        return next;
                    }
                    case 7: {
                        this.state = 6;
                        return next;
                    }
                }
                throw new IOException("should never happen");
            }

            public static void main(String[] args) throws Exception {
                int c;
                if (args.length != 1) {
                    throw new Exception();
                }
                boolean loc = Boolean.valueOf(args[0]);
                DebugInputStream dis = new DebugInputStream(System.in, 123, loc);
                while ((c = dis.read()) != -1) {
                    System.out.write(c);
                }
            }

            static {
                debugIgnoreKeySet.add("currentVersion");
                debugIgnoreKeySet.add("SplashRunningTextBounds");
                debugIgnoreKeySet.add("SplashProgressBarBounds");
                debugIgnoreKeySet.add("SplashRunningTextColor");
                debugIgnoreKeySet.add("SplashProgressBarColor");
                debugIgnoreKeySet.add("SplashProgressBarColor");
                debugIgnoreKeySet.add("SplashProgressBarEdgeColor");
                debugIgnoreKeySet.add("SplashProgressBarCornerColor");
                debugIgnoreKeySet.add("SplashRunningTextFontSize");
                debugIgnoreKeySet.add("SPLASH_WIDTH");
                debugIgnoreKeySet.add("SPLASH_HEIGHT");
                debugIgnoreKeySet.add("SplashShowProgressBar");
                debugIgnoreKeySet.add("WelcomeLabelFontSize");
                debugIgnoreKeySet.add("WelcomeLabelLine2FontSize");
                debugIgnoreKeySet.add("OpenIDE-Module-Display-Category");
                debugIgnoreKeySet.add("LBL_WebAppAppNameStub");
                debugIgnoreKeySet.add("FOLDER_RaveProjects");
            }
        }
    }
}

