/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerUtil {
    protected static HashMap loggerUtils = new HashMap();
    protected Logger logger;

    public static LoggerUtil getLogger(String loggerName) {
        LoggerUtil loggerUtil = (LoggerUtil)loggerUtils.get(loggerName);
        if (loggerUtil == null) {
            loggerUtil = new LoggerUtil(Logger.getLogger(loggerName));
            loggerUtils.put(loggerName, loggerUtil);
        }
        return loggerUtil;
    }

    protected LoggerUtil(Logger logger) {
        this.logger = logger;
    }

    public boolean config(String message) {
        this.log(Level.CONFIG, message, null);
        return true;
    }

    public boolean config(String message, Throwable throwable) {
        this.log(Level.CONFIG, message, throwable);
        return true;
    }

    protected String[] inferCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        String lookFor = "com.sun.jsfcl.util.LoggerUtil";
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(lookFor); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(lookFor)) {
                return new String[]{cname, frame.getMethodName()};
            }
            ++ix;
        }
        return new String[2];
    }

    public boolean info(String message) {
        this.log(Level.INFO, message, null);
        return true;
    }

    public boolean info(String message, Throwable throwable) {
        this.log(Level.INFO, message, throwable);
        return true;
    }

    public boolean log(Level level, String message, Throwable throwable) {
        if (!this.logger.isLoggable(level)) {
            return true;
        }
        String[] inferedCaller = this.inferCaller();
        this.logger.logp(level, inferedCaller[0], inferedCaller[1], message, throwable);
        return true;
    }

    public boolean severe(String message) {
        this.log(Level.SEVERE, message, null);
        return true;
    }

    public boolean severe(String message, Throwable throwable) {
        this.log(Level.SEVERE, message, throwable);
        return true;
    }

    public boolean warning(String message) {
        this.log(Level.WARNING, message, null);
        return true;
    }

    public boolean warning(String message, Throwable throwable) {
        this.log(Level.WARNING, message, throwable);
        return true;
    }

    static {
        InputStream in = LoggerUtil.class.getResourceAsStream("/local-logging.properties");
        if (in == null) {
            in = LoggerUtil.class.getResourceAsStream("/logging.properties");
        }
        if (in != null) {
            // empty if block
        }
    }
}

