/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesBindingPropertyEditor;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.propertyeditors.PropertyEditorBase;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.convert.BooleanConverter;
import javax.faces.convert.ByteConverter;
import javax.faces.convert.CharacterConverter;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.convert.DoubleConverter;
import javax.faces.convert.FloatConverter;
import javax.faces.convert.IntegerConverter;
import javax.faces.convert.LongConverter;
import javax.faces.convert.NumberConverter;
import javax.faces.convert.ShortConverter;
import javax.faces.el.ValueBinding;

public class ConverterPropertyEditor
extends PropertyEditorBase
implements FacesBindingPropertyEditor {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle");
    private static final Class[] defaultFacesConverterClasses = new Class[]{BooleanConverter.class, ByteConverter.class, CharacterConverter.class, DateTimeConverter.class, DoubleConverter.class, FloatConverter.class, IntegerConverter.class, LongConverter.class, NumberConverter.class, ShortConverter.class};
    private static Comparator converterComparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            String name1 = ((Class)obj1).getName();
            String name2 = ((Class)obj2).getName();
            return name1.substring(name1.lastIndexOf(46) + 1).compareTo(name2.substring(name2.lastIndexOf(46) + 1));
        }
    };
    private static HashMap converterClassMap = new HashMap();
    private Class[] converterClasses;
    private String[] converterLabels;

    public String[] getTags() {
        int i;
        DesignBean[] converterBeans = this.getConverterBeans();
        String[] converterLabels = this.getConverterLabels();
        String[] tags = new String[converterBeans.length + converterLabels.length + 1];
        int index = 0;
        tags[index++] = "";
        for (i = 0; i < converterBeans.length; ++i) {
            tags[index++] = converterBeans[i].getInstanceName();
        }
        for (i = 0; i < converterLabels.length; ++i) {
            tags[index++] = converterLabels[i];
        }
        return tags;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || text.trim().length() == 0) {
            this.setValue(null);
            return;
        }
        DesignBean[] converterBeans = this.getConverterBeans();
        Converter converter = null;
        for (int i = 0; i < converterBeans.length && converter == null; ++i) {
            if (!converterBeans[i].getInstanceName().equals(text)) continue;
            converter = (Converter)converterBeans[i].getInstance();
        }
        if (converter == null) {
            String[] converterLabels = this.getConverterLabels();
            Class[] converterClasses = this.getConverterClasses();
            for (int i = 0; i < converterLabels.length && converter == null; ++i) {
                DesignProperty designProperty;
                DesignBean createResult;
                if (!converterLabels[i].equals(text) || (createResult = (designProperty = this.getDesignProperty()).getDesignBean().getDesignContext().createBean(converterClasses[i].getName(), null, null)) == null) continue;
                converter = (Converter)createResult.getInstance();
            }
        }
        this.setValue(converter);
    }

    public String getAsText() {
        Object value = this.getValue();
        if (value instanceof ValueBinding) {
            return ((ValueBinding)value).getExpressionString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        DesignBean designBean = this.getDesignBean();
        if (designBean != null && designBean.getInstance() instanceof NumberConverter) {
            designBean.getProperty("minIntegerDigits").setValue((Object)new Integer(1));
            designBean.getProperty("maxIntegerDigits").setValue((Object)new Integer(40));
            designBean.getProperty("minFractionDigits").setValue((Object)new Integer(0));
            designBean.getProperty("maxFractionDigits").setValue((Object)new Integer(3));
        }
        return designBean == null ? "" : designBean.getInstanceName();
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    protected Class[] getConverterClasses() {
        if (this.converterClasses != null) {
            return this.converterClasses;
        }
        DesignProperty designProperty = this.getDesignProperty();
        if (designProperty == null) {
            return defaultFacesConverterClasses;
        }
        FacesContext facesContext = ((FacesDesignContext)designProperty.getDesignBean().getDesignContext()).getFacesContext();
        Application application = facesContext.getApplication();
        Iterator iter = application.getConverterTypes();
        TreeSet set = new TreeSet(converterComparator);
        while (iter.hasNext()) {
            Class propertyClass = (Class)iter.next();
            if (!converterClassMap.containsKey(propertyClass)) {
                Converter converter = application.createConverter(propertyClass);
                converterClassMap.put(propertyClass, converter.getClass());
            }
            set.add(converterClassMap.get(propertyClass));
        }
        this.converterClasses = new Class[set.size()];
        iter = set.iterator();
        for (int i = 0; i < this.converterClasses.length; ++i) {
            this.converterClasses[i] = (Class)iter.next();
        }
        return this.converterClasses;
    }

    protected String[] getConverterLabels() {
        if (this.converterLabels != null) {
            return this.converterLabels;
        }
        Class[] converterClasses = this.getConverterClasses();
        this.converterLabels = new String[converterClasses.length];
        MessageFormat labelFormat = new MessageFormat(bundle.getString("ConverterPropertyEditor.newConverterLabel"));
        Object[] args = new Object[1];
        for (int i = 0; i < converterClasses.length; ++i) {
            String name = converterClasses[i].getName();
            args[0] = name.substring(name.lastIndexOf(46) + 1);
            this.converterLabels[i] = labelFormat.format(args);
        }
        return this.converterLabels;
    }

    private DesignBean getDesignBean() {
        Object value = this.getValue();
        DesignBean[] lbeans = this.getConverterBeans();
        for (int i = 0; i < lbeans.length; ++i) {
            if (lbeans[i].getInstance() != value) continue;
            return lbeans[i];
        }
        return null;
    }

    private DesignBean[] getConverterBeans() {
        DesignProperty designProperty = this.getDesignProperty();
        if (designProperty == null) {
            return new DesignBean[0];
        }
        return designProperty.getDesignBean().getDesignContext().getBeansOfType(Converter.class);
    }
}

