/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.propertyeditors.PropertyEditorBase;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class DateFormatPropertyEditor
extends PropertyEditorBase {
    private static String[] formats = new String[]{"MM/dd/yyyy", "MM-dd-yyyy", "yyyy-MM-dd", "dd/MM/yyyy", "dd-MM-yyyy", "dd-MMM-yyyy", "MMM dd, yyyy", "E, MMM dd, yyyy"};

    public String getAsText() {
        DateFormat df = (DateFormat)this.getValue();
        if (df instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)df;
            return sdf.toPattern();
        }
        return "";
    }

    public void setAsText(String text) {
        if (text.trim().length() == 0) {
            this.setValue(null);
        } else {
            SimpleDateFormat df = new SimpleDateFormat(text);
            this.setValue(df);
        }
    }

    public String getJavaInitializationString() {
        DateFormat df = (DateFormat)this.getValue();
        if (df instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)df;
            return "new java.text.SimpleDateFormat(\"" + sdf.toPattern() + "\")";
        }
        return "java.util.DateFormat.getDateInstance(java.util.DateFormat.SHORT)";
    }

    public String[] getTags() {
        return formats;
    }
}

