/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.faces.util.ConstantMethodBinding;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.propertyeditors.IllegalTextArgumentException;
import com.sun.rave.propertyeditors.MethodBindingPropertyPanel;
import com.sun.rave.propertyeditors.PropertyEditorBase;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.Component;
import javax.faces.application.Application;
import javax.faces.el.MethodBinding;
import javax.faces.el.ReferenceSyntaxException;

public class MethodBindingPropertyEditor
extends PropertyEditorBase {
    private static final Bundle bundle = Bundle.getBundle(MethodBindingPropertyEditor.class);

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(this.getAsMethodBinding(text));
    }

    public String getAsText() {
        Object value = this.getValue();
        if (value instanceof MethodBinding) {
            MethodBinding mb = (MethodBinding)value;
            if (mb instanceof ConstantMethodBinding) {
                return (String)mb.invoke(null, null);
            }
            return mb.getExpressionString();
        }
        return value == null ? "" : value.toString();
    }

    public String getJavaInitializationString() {
        return "\"" + this.getAsText() + "\"";
    }

    MethodBinding getAsMethodBinding(String string) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).startsWith("#{")) {
            try {
                DesignProperty designProperty = this.getDesignProperty();
                FacesDesignContext context = (FacesDesignContext)designProperty.getDesignBean().getDesignContext();
                Application app = context.getFacesContext().getApplication();
                return app.createMethodBinding(string, new Class[0]);
            }
            catch (ReferenceSyntaxException e) {
                throw new IllegalTextArgumentException(bundle.getMessage("MethodBindingPropertyEditor.formatErrorMessage", string), e);
            }
        }
        if (string.length() > 0) {
            return new ConstantMethodBinding(string);
        }
        return null;
    }

    public Component getCustomEditor() {
        return new MethodBindingPropertyPanel(this);
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

