/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.propertyeditors.IllegalTextArgumentException;
import com.sun.rave.propertyeditors.PropertyEditorBase;
import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class NumberPropertyEditor
extends PropertyEditorBase {
    static ResourceBundle bundle = ResourceBundle.getBundle(NumberPropertyEditor.class.getPackage().getName() + ".Bundle");
    public static final String MIN_VALUE = "com.sun.rave.propertyeditors.MIN_VALUE";
    public static final String MAX_VALUE = "com.sun.rave.propertyeditors.MAX_VALUE";
    String unsetText;
    Object value;
    Class propertyType;
    Number minValue;
    Number maxValue;
    private Number defaultMinValue;
    private Number defaultMaxValue;

    NumberPropertyEditor(Number defaultMinValue, Number defaultMaxValue) {
        this.minValue = defaultMinValue;
        this.maxValue = defaultMaxValue;
        this.defaultMinValue = defaultMinValue;
        this.defaultMaxValue = defaultMaxValue;
        this.value = null;
    }

    protected abstract Number parseString(String var1) throws IllegalTextArgumentException;

    public void setDesignProperty(DesignProperty designProperty) {
        super.setDesignProperty(designProperty);
        PropertyDescriptor descriptor = designProperty.getPropertyDescriptor();
        Number number = null;
        Object value = descriptor.getValue(MIN_VALUE);
        if (value instanceof String) {
            try {
                number = this.parseString((String)value);
            }
            catch (NumberFormatException e) {
                number = null;
            }
        } else if (value instanceof Number) {
            number = (Number)value;
        }
        if (number != null && ((Comparable)((Object)number)).compareTo(this.defaultMinValue) >= 0) {
            this.minValue = number;
        }
        number = null;
        value = descriptor.getValue(MAX_VALUE);
        if (value instanceof String) {
            try {
                number = this.parseString((String)value);
            }
            catch (NumberFormatException e) {
                number = null;
            }
        } else if (value instanceof Number) {
            number = (Number)value;
        }
        if (number != null && ((Comparable)((Object)number)).compareTo(this.defaultMaxValue) <= 0) {
            this.maxValue = number;
        }
        this.propertyType = designProperty.getPropertyDescriptor().getPropertyType();
    }

    public void setValue(Object value) {
        if (value == null) {
            this.value = null;
        } else if (String.class.isAssignableFrom(value.getClass())) {
            this.setAsText((String)value);
        } else if (Number.class.isAssignableFrom(value.getClass())) {
            this.value = (Number)value;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(this.propertyType)) {
            return this.value.toString();
        }
        return this.value;
    }

    public String getAsText() {
        if (this.value == null) {
            return "";
        }
        if (this.value.equals(this.unsetValue) && Number.class.isAssignableFrom(this.value.getClass()) && (((Comparable)this.value).compareTo(this.minValue) <= 0 || ((Comparable)this.value).compareTo(this.maxValue) >= 0)) {
            return "";
        }
        return this.value.toString();
    }

    public void setAsText(String str) throws IllegalArgumentException {
        String string = str = str == null ? "" : str.trim();
        if (str.length() == 0) {
            this.value = this.unsetValue;
        } else {
            Number n = this.parseString(str);
            if (((Comparable)((Object)n)).compareTo(this.minValue) >= 0 && ((Comparable)((Object)n)).compareTo(this.maxValue) <= 0) {
                this.value = n;
            } else {
                String rangeErrorMessage = null;
                int maxCompare = ((Comparable)((Object)this.maxValue)).compareTo(this.defaultMaxValue);
                int minCompare = ((Comparable)((Object)this.minValue)).compareTo(this.defaultMinValue);
                if (maxCompare > 0 && minCompare < 0) {
                    rangeErrorMessage = MessageFormat.format(bundle.getString("NumberPropertyEditor.rangeErrorMessage"), this.minValue, this.maxValue);
                } else if (maxCompare < 0) {
                    rangeErrorMessage = MessageFormat.format(bundle.getString("NumberPropertyEditor.rangeMaxErrorMessage"), this.maxValue);
                } else if (minCompare > 0) {
                    rangeErrorMessage = MessageFormat.format(bundle.getString("NumberPropertyEditor.rangeMinErrorMessage"), this.minValue);
                }
                throw new IllegalTextArgumentException(rangeErrorMessage);
            }
        }
    }
}

