/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.propertyeditors.PropertyEditorBase;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JPanel;
import org.openide.explorer.propertysheet.PropertyEnv;

public abstract class PropertyPanelBase
extends JPanel {
    PropertyEditorBase propertyEditor;
    PanelSubmissionListener panelSubmissionListener;

    public static PropertyPanelBase createPropertyPanel(DesignProperty designProperty) {
        PropertyDescriptor descriptor = designProperty.getPropertyDescriptor();
        Class<?> editorClass = descriptor.getPropertyEditorClass();
        if (editorClass == null) {
            return null;
        }
        try {
            PropertyEditor editor = (PropertyEditor)editorClass.newInstance();
            if (PropertyEditorBase.class.isAssignableFrom(editorClass)) {
                ((PropertyEditorBase)editor).setDesignProperty(designProperty);
            }
            editor.setValue(designProperty.getValue());
            Component customEditor = editor.getCustomEditor();
            if (PropertyPanelBase.class.isAssignableFrom(customEditor.getClass())) {
                return (PropertyPanelBase)customEditor;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public PropertyPanelBase(PropertyEditorBase propertyEditor) {
        PropertyEnv propertyEnv = propertyEditor.getEnv();
        if (propertyEnv != null) {
            propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            this.panelSubmissionListener = new PanelSubmissionListener(propertyEditor);
            propertyEnv.addVetoableChangeListener((VetoableChangeListener)this.panelSubmissionListener);
            this.propertyEditor = propertyEditor;
        }
    }

    public abstract Object getPropertyValue();

    protected void finalize() throws Throwable {
        if (this.panelSubmissionListener != null) {
            this.propertyEditor.getEnv().removeVetoableChangeListener((VetoableChangeListener)this.panelSubmissionListener);
        }
        super.finalize();
    }

    class PanelSubmissionListener
    implements VetoableChangeListener {
        PropertyEditorBase propertyEditor;

        PanelSubmissionListener(PropertyEditorBase propertyEditor) {
            this.propertyEditor = propertyEditor;
        }

        public final void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
            if ("state".equals(event.getPropertyName())) {
                this.propertyEditor.setValue(PropertyPanelBase.this.getPropertyValue());
                this.propertyEditor.getEnv().setState(PropertyEnv.STATE_VALID);
            }
        }
    }
}

