/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.propertyeditors.DomainPropertyEditor;
import com.sun.rave.propertyeditors.SelectOneDomainPanel;
import com.sun.rave.propertyeditors.domains.Domain;
import com.sun.rave.propertyeditors.domains.EditableDomain;
import com.sun.rave.propertyeditors.domains.Element;
import java.awt.Component;

public class SelectOneDomainEditor
extends DomainPropertyEditor {
    static final long FETCH_TIME_LIMIT = 2500L;
    static final int MAX_DOMAIN_SIZE = 8;
    Element element;
    private long elementsFetchTime;
    private Element[] elements;
    private String[] elementLabels;

    public SelectOneDomainEditor() {
    }

    public SelectOneDomainEditor(Domain domain) {
        super(domain);
    }

    public Object getValue() {
        return this.element == null ? null : this.element.getValue();
    }

    public void setValue(Object value) {
        Domain domain = this.getDomain();
        if (domain == null) {
            return;
        }
        Element[] elements = this.getElements();
        Element e = null;
        for (int i = 0; i < elements.length && e == null; ++i) {
            Object v = elements[i].getValue();
            if (value != v && (v == null || !v.equals(value))) continue;
            e = elements[i];
        }
        this.element = e == null ? this.defaultElement : e;
    }

    public String getAsText() {
        if (this.element == null) {
            this.element = this.defaultElement;
        }
        return this.element.getLabel();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        Domain domain = this.getDomain();
        if (domain == null) {
            return;
        }
        if (text == null || text.trim().length() == 0) {
            this.element = this.defaultElement;
        } else {
            Element[] elements = this.getElements();
            Element e = null;
            for (int i = 0; i < elements.length && e == null; ++i) {
                if (!elements[i].getLabel().equals(text)) continue;
                e = elements[i];
            }
            if (e != null) {
                this.element = e;
            }
        }
    }

    public String[] getTags() {
        Domain domain = this.getDomain();
        if (domain == null) {
            return new String[0];
        }
        if (domain instanceof EditableDomain) {
            ((EditableDomain)domain).setDesignProperty(this.getDesignProperty());
        }
        if (domain.getSize() > 8) {
            return null;
        }
        return this.getElementLabels();
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        Domain domain = this.getDomain();
        if (domain instanceof EditableDomain) {
            EditableDomain editableDomain = (EditableDomain)domain;
            editableDomain.setDesignProperty(this.getDesignProperty());
        }
        SelectOneDomainPanel panel = new SelectOneDomainPanel(this);
        return panel;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public void setDesignProperty(DesignProperty designProperty) {
        super.setDesignProperty(designProperty);
        if (this.getDomain() != null && this.getValue() == null) {
            this.setValue(null);
        }
    }

    public String getJavaInitializationString() {
        return this.element.getJavaInitializationString();
    }

    private Element[] getElements() {
        if (this.elements == null || System.currentTimeMillis() - this.elementsFetchTime > 2500L) {
            this.elements = this.domain.getElements();
            this.elementsFetchTime = System.currentTimeMillis();
        }
        return this.elements;
    }

    private String[] getElementLabels() {
        if (this.elementLabels == null || System.currentTimeMillis() - this.elementsFetchTime > 2500L) {
            this.elements = this.getElements();
            int i = 0;
            int j = 0;
            if (this.domain.isRequired()) {
                this.elementLabels = new String[this.elements.length];
            } else {
                this.elementLabels = new String[this.elements.length + 1];
                int n = i++;
                this.elementLabels[n] = EMPTY_ELEMENT.getLabel();
            }
            while (j < this.elements.length) {
                this.elementLabels[i++] = this.elements[j++].getLabel();
            }
        }
        return this.elementLabels;
    }
}

