/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.propertyeditors.EditElementDialog;
import com.sun.rave.propertyeditors.PropertyPanelBase;
import com.sun.rave.propertyeditors.SelectOneDomainEditor;
import com.sun.rave.propertyeditors.domains.Domain;
import com.sun.rave.propertyeditors.domains.EditableDomain;
import com.sun.rave.propertyeditors.domains.Element;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectOneDomainPanel
extends PropertyPanelBase {
    static ResourceBundle bundle;
    protected Domain domain;
    protected Element element;
    private DefaultListModel listModel;
    private JPanel buttonPanel;
    private JButton deleteButton;
    private JList domainList;
    private JScrollPane domainScrollPane;
    private JButton editButton;
    private JLabel listLabel;
    private JButton newButton;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SelectOneDomainPanel(SelectOneDomainEditor propertyEditor) {
        super(propertyEditor);
        int i;
        this.domain = propertyEditor.getDomain();
        this.element = propertyEditor.getElement();
        if (!$assertionsDisabled && this.domain == null) {
            throw new AssertionError();
        }
        this.listModel = new DefaultListModel();
        Element[] elements = this.domain.getElements();
        for (i = 0; i < elements.length; ++i) {
            this.listModel.addElement(elements[i].getLabel());
        }
        this.initComponents();
        if (this.domain instanceof EditableDomain) {
            this.buttonPanel.setVisible(true);
        } else {
            this.buttonPanel.setVisible(false);
        }
        if (this.element != null) {
            for (i = 0; i < elements.length && !this.element.equals(elements[i]); ++i) {
            }
            if (i < elements.length) {
                this.domainList.setSelectedIndex(i);
                this.domainList.ensureIndexIsVisible(i);
            }
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
        ListEventListener eventListener = new ListEventListener(this.domainList);
        this.domainList.addListSelectionListener(eventListener);
        this.domainList.addKeyListener(eventListener);
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.element == null) {
            return null;
        }
        return this.element.getValue();
    }

    public void valueChanged(ListSelectionEvent event) {
    }

    private void initComponents() {
        String domainDisplayName = this.domain.getDisplayName();
        String listLabelString = domainDisplayName == null ? bundle.getString("SelectOneDomainPanel.list.label.default") : MessageFormat.format(bundle.getString("SelectOneDomainPanel.list.label"), domainDisplayName);
        this.listLabel = new JLabel();
        this.domainScrollPane = new JScrollPane();
        this.domainList = new JList(this.listModel);
        this.buttonPanel = new JPanel();
        this.newButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.listLabel.setText(listLabelString);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 11);
        this.add((Component)this.listLabel, gridBagConstraints);
        this.domainList.setMinimumSize(new Dimension(64, 64));
        this.domainList.setVisibleRowCount(this.getLabelRowCount());
        this.domainScrollPane.setViewportView(this.domainList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 11);
        this.add((Component)this.domainScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(0, 6, 5));
        this.newButton.setText(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("SelectOneDomainPanel.button.new"));
        this.newButton.setActionCommand("new");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectOneDomainPanel.this.handleButtonAction(evt);
            }
        });
        this.buttonPanel.add(this.newButton);
        this.editButton.setText(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("SelectOneDomainPanel.button.edit"));
        this.editButton.setActionCommand("edit");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectOneDomainPanel.this.handleButtonAction(evt);
            }
        });
        this.buttonPanel.add(this.editButton);
        this.deleteButton.setText(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("SelectOneDomainPanel.button.delete"));
        this.deleteButton.setActionCommand("delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectOneDomainPanel.this.handleButtonAction(evt);
            }
        });
        this.buttonPanel.add(this.deleteButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 5, 0, 0);
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void handleButtonAction(ActionEvent evt) {
        int index;
        String action = evt.getActionCommand();
        EditableDomain editableDomain = (EditableDomain)this.domain;
        if (action.equals("new")) {
            Element newElement = new EditElementDialog(editableDomain).showDialog(this);
            if (newElement != null) {
                editableDomain.addElement(newElement);
                this.listModel.addElement(newElement.getLabel());
                this.domainList.setSelectedIndex(editableDomain.getSize() - 1);
            }
        } else if (action.equals("edit")) {
            Element element;
            Element newElement;
            int index2 = this.domainList.getSelectedIndex();
            if (index2 >= 0 && index2 < this.domain.getSize() && (newElement = new EditElementDialog(element = editableDomain.getElementAt(index2), editableDomain).showDialog(this)) != null && !newElement.equals(element)) {
                editableDomain.setElementAt(index2, newElement);
                this.listModel.set(index2, newElement.getLabel());
            }
        } else if (action.equals("delete") && (index = this.domainList.getSelectedIndex()) >= 0 && index < this.domain.getSize()) {
            editableDomain.removeElementAt(index);
            this.listModel.remove(index);
            if (index == this.listModel.getSize()) {
                --index;
            }
            this.domainList.setSelectedIndex(index);
        }
    }

    private int getLabelColumnCount() {
        int c = 8;
        Element[] elements = this.domain.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].getLabel().length() <= c) continue;
            c = elements[i].getLabel().length();
        }
        return c;
    }

    private int getLabelRowCount() {
        return this.domain.getSize() < 16 ? this.domain.getSize() : 16;
    }

    static {
        $assertionsDisabled = !SelectOneDomainPanel.class.desiredAssertionStatus();
        bundle = ResourceBundle.getBundle(SelectOneDomainPanel.class.getPackage().getName() + ".Bundle");
    }

    class ListEventListener
    implements KeyListener,
    ListSelectionListener {
        static final long BUFFER_ERASE_DELAY = 350L;
        JList list;
        StringBuffer keyStrokeBuffer;
        Timer keyStrokeTimer;
        TimerTask bufferEraseTask;

        ListEventListener(JList list) {
            this.list = list;
            this.keyStrokeBuffer = new StringBuffer(16);
            this.keyStrokeTimer = new Timer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyTyped(KeyEvent event) {
            char c = event.getKeyChar();
            if (!Character.isISOControl(c)) {
                StringBuffer stringBuffer = this.keyStrokeBuffer;
                synchronized (stringBuffer) {
                    if (this.bufferEraseTask != null) {
                        this.bufferEraseTask.cancel();
                    }
                    this.keyStrokeBuffer.append(c);
                    this.bufferEraseTask = new TimerTask(){

                        public void run() {
                            ListEventListener.this.keyStrokeBuffer.setLength(0);
                        }
                    };
                    this.repositionSelectedItem(this.keyStrokeBuffer.toString());
                    this.keyStrokeTimer.schedule(this.bufferEraseTask, 350L);
                }
            }
        }

        private void repositionSelectedItem(String prefix) {
            int j;
            int i = this.list.getSelectedIndex() - 1;
            ListModel listModel = this.list.getModel();
            if (i >= 0) {
                for (j = i + 1; j < listModel.getSize(); ++j) {
                    if (!((String)listModel.getElementAt(j)).regionMatches(true, 0, prefix, 0, prefix.length())) continue;
                    this.list.setSelectedIndex(j);
                    this.list.ensureIndexIsVisible(j);
                    return;
                }
            }
            for (j = 0; j < listModel.getSize(); ++j) {
                if (!((String)listModel.getElementAt(j)).regionMatches(true, 0, prefix, 0, prefix.length())) continue;
                this.list.setSelectedIndex(j);
                this.list.ensureIndexIsVisible(j);
                return;
            }
        }

        public void keyReleased(KeyEvent event) {
        }

        public void keyPressed(KeyEvent event) {
        }

        public void valueChanged(ListSelectionEvent event) {
            int index = ((JList)event.getSource()).getSelectedIndex();
            SelectOneDomainPanel.this.element = SelectOneDomainPanel.this.domain.getElementAt(index);
            SelectOneDomainPanel.this.editButton.setEnabled(true);
            SelectOneDomainPanel.this.deleteButton.setEnabled(true);
        }
    }
}

