/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.propertyeditors.TabularPropertyEditor;
import com.sun.rave.propertyeditors.TabularPropertyModel;
import com.sun.rave.propertyeditors.util.JavaInitializer;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.event.TableModelListener;

public class StringArrayPropertyEditor
extends TabularPropertyEditor {
    private static ResourceBundle bundle = ResourceBundle.getBundle(StringArrayPropertyEditor.class.getPackage().getName() + ".Bundle");
    private static String columnName = bundle.getString("StringArrayPropertyEditor.label");
    private static String columnValue = bundle.getString("StringArrayPropertyEditor.value");
    private StringArrayTableModel tableModel;
    static /* synthetic */ Class class$java$lang$String;

    public String getJavaInitializationString() {
        StringBuffer buffer = new StringBuffer();
        Object value = this.getValue();
        if (!(value instanceof String[])) {
            return null;
        }
        String[] strings = (String[])value;
        buffer.append("new String[] {");
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(JavaInitializer.toJavaInitializationString(strings[i]));
        }
        buffer.append("}");
        return buffer.toString();
    }

    protected TabularPropertyModel getTabularPropertyModel() {
        if (this.tableModel == null) {
            this.tableModel = new StringArrayTableModel();
        }
        return this.tableModel;
    }

    class StringArrayTableModel
    implements TabularPropertyModel {
        ArrayList stringList = new ArrayList();

        public void setValue(Object value) {
            this.stringList.clear();
            if (value != null && value instanceof String[]) {
                String[] values = (String[])value;
                for (int i = 0; i < values.length; ++i) {
                    this.stringList.add(values[i]);
                }
            }
        }

        public Object getValue() {
            String[] values = new String[this.stringList.size()];
            return this.stringList.toArray(values);
        }

        public void addTableModelListener(TableModelListener listener) {
        }

        public void removeTableModelListener(TableModelListener listener) {
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex != 0) {
                return false;
            }
            return rowIndex >= 0 && rowIndex < this.stringList.size();
        }

        public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
            if (this.isCellEditable(rowIndex, columnIndex)) {
                this.stringList.set(rowIndex, newValue);
            }
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = StringArrayPropertyEditor.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= 0 && rowIndex < this.stringList.size()) {
                return this.stringList.get(rowIndex);
            }
            return null;
        }

        public int getRowCount() {
            return this.stringList.size();
        }

        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return columnName;
            }
            return null;
        }

        public int getColumnCount() {
            return 1;
        }

        public boolean canAddRow() {
            return true;
        }

        public boolean addRow() {
            this.stringList.add(columnValue);
            return true;
        }

        public boolean canMoveRow(int indexFrom, int indexTo) {
            if (indexFrom < 0 || indexTo < 0 || indexFrom == indexTo) {
                return false;
            }
            return indexFrom < this.stringList.size() && indexTo < this.stringList.size();
        }

        public boolean moveRow(int indexFrom, int indexTo) {
            if (!this.canMoveRow(indexFrom, indexTo)) {
                return false;
            }
            this.stringList.add(indexTo, this.stringList.remove(indexFrom));
            return true;
        }

        public boolean canRemoveRow(int index) {
            return index >= 0 && index < this.stringList.size();
        }

        public boolean removeRow(int index) {
            if (!this.canRemoveRow(index)) {
                return false;
            }
            this.stringList.remove(index);
            return true;
        }

        public boolean removeAllRows() {
            if (this.stringList.isEmpty()) {
                return true;
            }
            this.stringList.clear();
            return true;
        }
    }
}

