/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.propertyeditors.PropertyPanelBase;
import com.sun.rave.propertyeditors.StyleClassPropertyEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class StyleClassPropertyPanel
extends PropertyPanelBase {
    StyleClassPropertyEditor editor;
    DefaultListModel availableListModel;
    DefaultListModel selectedListModel;
    private JLabel availableLabel;
    private JList availableList;
    private JScrollPane availableListScrollPane;
    private JButton deselectAllButton;
    private JButton deselectButton;
    private JButton selectAllButton;
    private JButton selectButton;
    private JPanel selectButtonPanel;
    private JLabel selectedLabel;
    private JList selectedList;
    private JScrollPane selectedListScrollPane;
    private JLabel titleLabel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StyleClassPropertyPanel(StyleClassPropertyEditor editor) {
        super(editor);
        if (!$assertionsDisabled && editor == null) {
            throw new AssertionError();
        }
        this.editor = editor;
        this.selectedListModel = new DefaultListModel();
        String[] selectedStyleClasses = editor.getStyleClasses();
        HashSet<String> selectStyleClassesSet = new HashSet<String>();
        for (int i = 0; i < selectedStyleClasses.length; ++i) {
            this.selectedListModel.addElement(selectedStyleClasses[i]);
            selectStyleClassesSet.add(selectedStyleClasses[i]);
        }
        this.availableListModel = new DefaultListModel();
        String[] availableStyleClasses = editor.getAvailableStyleClasses();
        for (int i = 0; i < availableStyleClasses.length; ++i) {
            if (selectStyleClassesSet.contains(availableStyleClasses[i])) continue;
            this.availableListModel.addElement(availableStyleClasses[i]);
        }
        this.initComponents();
        this.availableList.addKeyListener(new ListKeyListener(this.availableList));
    }

    public Object getPropertyValue() {
        if (this.selectedListModel.size() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.selectedListModel.get(0));
        for (int i = 1; i < this.selectedListModel.size(); ++i) {
            buffer.append(" ");
            buffer.append(this.selectedListModel.get(i));
        }
        return buffer.toString();
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.availableListScrollPane = new JScrollPane();
        this.availableList = new JList(this.availableListModel);
        this.selectButtonPanel = new JPanel();
        this.selectButton = new JButton();
        this.deselectButton = new JButton();
        this.selectAllButton = new JButton();
        this.deselectAllButton = new JButton();
        this.selectedListScrollPane = new JScrollPane();
        this.selectedList = new JList(this.selectedListModel);
        this.availableLabel = new JLabel();
        this.selectedLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.titleLabel.setText(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("StyleClassPropertyEditor.title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 6, 11);
        this.add((Component)this.titleLabel, gridBagConstraints);
        this.availableListScrollPane.setViewportView(this.availableList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.add((Component)this.availableListScrollPane, gridBagConstraints);
        this.selectButtonPanel.setLayout(new BoxLayout(this.selectButtonPanel, 1));
        this.selectButton.setFont(new Font("MS Sans Serif", 1, 11));
        this.selectButton.setText(">");
        this.selectButton.setActionCommand("select");
        this.selectButton.setAlignmentY(0.0f);
        this.selectButton.setMaximumSize(new Dimension(45, 23));
        this.selectButton.setMinimumSize(new Dimension(45, 23));
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleClassPropertyPanel.this.handleButtonAction(evt);
            }
        });
        this.selectButtonPanel.add(this.selectButton);
        this.deselectButton.setFont(new Font("MS Sans Serif", 1, 11));
        this.deselectButton.setText("<");
        this.deselectButton.setActionCommand("deselect");
        this.deselectButton.setMaximumSize(new Dimension(45, 23));
        this.deselectButton.setMinimumSize(new Dimension(45, 23));
        this.selectButtonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.deselectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleClassPropertyPanel.this.handleButtonAction(evt);
            }
        });
        this.selectButtonPanel.add(this.deselectButton);
        this.selectAllButton.setFont(new Font("MS Sans Serif", 1, 11));
        this.selectAllButton.setText(">>");
        this.selectAllButton.setActionCommand("selectAll");
        this.selectButtonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleClassPropertyPanel.this.handleButtonAction(evt);
            }
        });
        this.selectButtonPanel.add(this.selectAllButton);
        this.deselectAllButton.setFont(new Font("MS Sans Serif", 1, 11));
        this.deselectAllButton.setText("<<");
        this.deselectAllButton.setActionCommand("deselectAll");
        this.selectButtonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.deselectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleClassPropertyPanel.this.handleButtonAction(evt);
            }
        });
        this.selectButtonPanel.add(this.deselectAllButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.selectButtonPanel, gridBagConstraints);
        this.selectedListScrollPane.setViewportView(this.selectedList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.add((Component)this.selectedListScrollPane, gridBagConstraints);
        this.availableLabel.setText(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("StyleClassPropertyEditor.availableStyleClasses"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.add((Component)this.availableLabel, gridBagConstraints);
        this.selectedLabel.setText(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("StyleClassPropertyEditor.selectedStyleClasses"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.selectedLabel, gridBagConstraints);
    }

    private void handleButtonAction(ActionEvent evt) {
        block3: {
            String action;
            block2: {
                action = evt.getActionCommand();
                if (!action.equals("select")) break block2;
                int[] selectedIndices = this.availableList.getSelectedIndices();
                for (int i = selectedIndices.length - 1; i >= 0; --i) {
                    this.selectedListModel.addElement(this.availableListModel.remove(selectedIndices[i]));
                }
                break block3;
            }
            if (!action.equals("deselect")) break block3;
            int[] selectedIndices = this.selectedList.getSelectedIndices();
            for (int i = selectedIndices.length - 1; i >= 0; --i) {
                String styleClass = (String)this.selectedListModel.remove(selectedIndices[i]);
                this.availableListModel.add(-1 - Arrays.binarySearch(this.availableListModel.toArray(), styleClass), styleClass);
            }
        }
    }

    static {
        $assertionsDisabled = !StyleClassPropertyPanel.class.desiredAssertionStatus();
    }

    class ListKeyListener
    implements KeyListener {
        static final long BUFFER_ERASE_DELAY = 350L;
        JList list;
        StringBuffer keyStrokeBuffer;
        Timer keyStrokeTimer;
        TimerTask bufferEraseTask;

        ListKeyListener(JList list) {
            this.list = list;
            this.keyStrokeBuffer = new StringBuffer(16);
            this.keyStrokeTimer = new Timer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyTyped(KeyEvent event) {
            char c = event.getKeyChar();
            if (!Character.isISOControl(c)) {
                StringBuffer stringBuffer = this.keyStrokeBuffer;
                synchronized (stringBuffer) {
                    if (this.bufferEraseTask != null) {
                        this.bufferEraseTask.cancel();
                    }
                    this.keyStrokeBuffer.append(c);
                    this.bufferEraseTask = new TimerTask(){

                        public void run() {
                            ListKeyListener.this.keyStrokeBuffer.setLength(0);
                        }
                    };
                    this.repositionSelectedItem(this.keyStrokeBuffer.toString());
                    this.keyStrokeTimer.schedule(this.bufferEraseTask, 350L);
                }
            }
        }

        private void repositionSelectedItem(String prefix) {
            int j;
            int i = this.list.getSelectedIndex() - 1;
            ListModel listModel = this.list.getModel();
            if (i >= 0) {
                for (j = i + 1; j < listModel.getSize(); ++j) {
                    if (!((String)listModel.getElementAt(j)).regionMatches(true, 0, prefix, 0, prefix.length())) continue;
                    this.list.setSelectedIndex(j);
                    this.list.ensureIndexIsVisible(j);
                    return;
                }
            }
            for (j = 0; j < listModel.getSize(); ++j) {
                if (!((String)listModel.getElementAt(j)).regionMatches(true, 0, prefix, 0, prefix.length())) continue;
                this.list.setSelectedIndex(j);
                this.list.ensureIndexIsVisible(j);
                return;
            }
        }

        public void keyReleased(KeyEvent event) {
        }

        public void keyPressed(KeyEvent event) {
        }
    }
}

