/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.propertyeditors.PropertyEditorBase;
import com.sun.rave.propertyeditors.UrlFileFilter;
import com.sun.rave.propertyeditors.UrlPropertyPanel;
import java.awt.Component;
import javax.faces.component.UIComponent;

public class UrlPropertyEditor
extends PropertyEditorBase {
    public boolean isEditableAsText() {
        return true;
    }

    protected String getPropertyHelpId() {
        return "projrave_ui_elements_propeditors_url_prop_ed";
    }

    public String getAsText() {
        Object value = super.getValue();
        if (value == null || value.equals(this.unsetValue)) {
            return "";
        }
        return UrlPropertyEditor.decodeUrl((String)value);
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            super.setValue(null);
        } else if (text.trim().length() == 0) {
            super.setValue(this.unsetValue);
        } else {
            super.setValue(UrlPropertyEditor.encodeUrl(text.trim()));
        }
    }

    public Component getCustomEditor() {
        return new UrlPropertyPanel(this);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public boolean isTargetComponent(UIComponent component) {
        return false;
    }

    public String getTargetComponentName(UIComponent component) {
        return component.getId();
    }

    public UrlFileFilter getFileFilter() {
        return null;
    }

    public static String encodeUrl(String url) {
        if (url == null || url.length() == 0) {
            return url;
        }
        StringBuffer buffer = new StringBuffer();
        String anchor = null;
        int index = url.lastIndexOf(35);
        if (index >= 0) {
            anchor = url.substring(index + 1);
            url = url.substring(0, index);
        }
        char[] chars = url.toCharArray();
        block13: for (int i = 0; i < chars.length; ++i) {
            if (chars[i] <= ' ') {
                buffer.append('%');
                buffer.append(Integer.toHexString(chars[i]));
                continue;
            }
            switch (chars[i]) {
                case '\t': {
                    buffer.append("%09");
                    continue block13;
                }
                case ' ': {
                    buffer.append("%20");
                    continue block13;
                }
                case '#': {
                    buffer.append("%23");
                    continue block13;
                }
                case '%': {
                    buffer.append("%25");
                    continue block13;
                }
                case '<': {
                    buffer.append("%3C");
                    continue block13;
                }
                case '>': {
                    buffer.append("%3E");
                    continue block13;
                }
                case '[': {
                    buffer.append("%5B");
                    continue block13;
                }
                case ']': {
                    buffer.append("%5D");
                    continue block13;
                }
                case '{': {
                    buffer.append("%7B");
                    continue block13;
                }
                case '}': {
                    buffer.append("%7D");
                    continue block13;
                }
                case '~': {
                    buffer.append("%7E");
                    continue block13;
                }
                default: {
                    buffer.append(chars[i]);
                }
            }
        }
        if (anchor != null) {
            buffer.append('#');
            buffer.append(anchor);
        }
        if (buffer.length() == url.length()) {
            return url;
        }
        return buffer.toString();
    }

    public static String decodeUrl(String url) {
        if (url == null || url.indexOf(37) == -1) {
            return url;
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = url.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '%' && i + 2 < chars.length) {
                buffer.append((char)Integer.parseInt(String.copyValueOf(chars, i + 1, 2), 16));
                i += 2;
                continue;
            }
            buffer.append(chars[i]);
        }
        return buffer.toString();
    }
}

