/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import com.sun.rave.propertyeditors.PropertyPanelBase;
import com.sun.rave.propertyeditors.UrlFileFilter;
import com.sun.rave.propertyeditors.UrlPropertyEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UrlPropertyPanel
extends PropertyPanelBase {
    protected static ResourceBundle resourceBundle = ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle");
    protected static WeakHashMap directoryMap = new WeakHashMap();
    static FileFilter defaultFileFilter = new FileFilter(){

        public boolean accept(File file) {
            String fileName = file.getName();
            if (fileName == null) {
                return false;
            }
            if (file.isDirectory() && fileName.equals("WEB-INF")) {
                return false;
            }
            return !fileName.endsWith(".jspf") && !fileName.endsWith("~");
        }
    };
    UrlPropertyEditor editor;
    DesignContext designContext;
    ResourceNode rootTreeNode;
    DefaultTreeModel treeModel;
    private JButton addButton;
    private ButtonGroup radioButtonGroup;
    private JScrollPane resourceScrollPane;
    private JTree resourceTree;
    private JComboBox urlComboBox;
    private JLabel urlLabel;
    private JPanel urlPanel;
    static /* synthetic */ Class class$javax$faces$component$UIComponent;

    public UrlPropertyPanel(UrlPropertyEditor editor) {
        super(editor);
        this.editor = editor;
        this.designContext = editor.getDesignProperty().getDesignBean().getDesignContext();
        this.rootTreeNode = this.generateTargetTree(this.designContext);
        this.treeModel = new DefaultTreeModel(this.rootTreeNode);
        this.initComponents();
        for (int i = 0; i < this.rootTreeNode.getChildCount(); ++i) {
            TreeNode n = this.rootTreeNode.getChildAt(i);
            this.resourceTree.expandPath(new TreePath(this.treeModel.getPathToRoot(n)));
        }
        DesignBean[] beans = this.designContext.getBeansOfType(editor.getDesignProperty().getDesignBean().getInstance().getClass());
        if (beans != null && beans.length > 0) {
            String propertyName = editor.getDesignProperty().getPropertyDescriptor().getName();
            for (int i = 0; i < beans.length; ++i) {
                String url = (String)beans[i].getProperty(propertyName).getValue();
                if (url == null) continue;
                this.urlComboBox.addItem(url);
            }
        }
        if (editor.getValue() != null) {
            String url = UrlPropertyEditor.decodeUrl(editor.getValue().toString());
            this.urlComboBox.setSelectedItem(url);
            if (url.indexOf(":") < 0) {
                TreePath path = this.urlToTreePath(url, this.rootTreeNode);
                this.resourceTree.makeVisible(path);
                this.resourceTree.setSelectionPath(path);
            }
        } else {
            this.urlComboBox.setSelectedItem("");
        }
    }

    public Object getPropertyValue() throws IllegalArgumentException {
        return UrlPropertyEditor.encodeUrl((String)this.urlComboBox.getSelectedItem());
    }

    protected File getLastDirectory() {
        DesignProject key = this.editor.getDesignProperty().getDesignBean().getDesignContext().getProject();
        return (File)directoryMap.get(key);
    }

    protected void setLastDirectory(File dir) {
        DesignProject key = this.editor.getDesignProperty().getDesignBean().getDesignContext().getProject();
        directoryMap.put(key, dir);
    }

    private void initComponents() {
        this.radioButtonGroup = new ButtonGroup();
        this.resourceScrollPane = new JScrollPane();
        this.resourceTree = new JTree(this.treeModel);
        this.addButton = new JButton();
        this.urlPanel = new JPanel();
        this.urlLabel = new JLabel();
        this.urlComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.resourceScrollPane.setMinimumSize(new Dimension(120, 80));
        this.resourceTree.setCellRenderer(new NodeRenderer());
        this.resourceTree.setMinimumSize(new Dimension(120, 80));
        this.resourceTree.setRootVisible(false);
        this.resourceTree.setShowsRootHandles(true);
        this.resourceTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                UrlPropertyPanel.this.resourceTreeMouseClicked(evt);
            }
        });
        this.resourceScrollPane.setViewportView(this.resourceTree);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 11, 11);
        this.add((Component)this.resourceScrollPane, gridBagConstraints);
        this.addButton.setText(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("UrlPropertyPanel.add.label"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UrlPropertyPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 7);
        this.add((Component)this.addButton, gridBagConstraints);
        this.urlPanel.setLayout(new GridBagLayout());
        this.urlLabel.setText(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("UrlPropertyPanel.url.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        this.urlPanel.add((Component)this.urlLabel, gridBagConstraints);
        this.urlComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.urlPanel.add((Component)this.urlComboBox, gridBagConstraints);
        this.urlComboBox.getAccessibleContext().setAccessibleName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(7, 11, 0, 7);
        this.add((Component)this.urlPanel, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String approveMessage;
        File lastDir;
        JFileChooser fileChooser = new JFileChooser();
        UrlFileFilter fileFilter = this.editor.getFileFilter();
        if (fileFilter != null) {
            fileChooser.addChoosableFileFilter(fileFilter);
        }
        if ((lastDir = this.getLastDirectory()) != null) {
            fileChooser.setCurrentDirectory(lastDir);
        }
        if (fileChooser.showDialog(this, approveMessage = resourceBundle.getString("UrlPropertyPanel.add.label")) == 0) {
            File file = fileChooser.getSelectedFile();
            if (file == null || !file.exists()) {
                return;
            }
            try {
                DesignProject project = this.designContext.getProject();
                project.addResource(file.toURI().toURL(), new URI("web/resources/" + UrlPropertyEditor.encodeUrl(file.getName())));
                String url = "/resources/" + file.getName();
                ResourceNode resourcesNode = this.getNode("/resources", this.rootTreeNode);
                if (resourcesNode == null) {
                    File rootFile = ((FileNode)this.rootTreeNode).getFile();
                    resourcesNode = new FileNode(this.rootTreeNode, new File(rootFile, "/resources"));
                    this.rootTreeNode.add(resourcesNode);
                }
                FileNode childNode = new FileNode(resourcesNode, file);
                this.treeModel.insertNodeInto(childNode, resourcesNode, resourcesNode.getChildCount());
                this.resourceTree.setSelectionPath(this.urlToTreePath(url, this.rootTreeNode));
                this.urlComboBox.setSelectedItem(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        this.setLastDirectory(fileChooser.getCurrentDirectory());
    }

    private void resourceTreeMouseClicked(MouseEvent evt) {
        TreePath path = this.resourceTree.getPathForLocation(evt.getX(), evt.getY());
        if (path != null) {
            ResourceNode n = (ResourceNode)path.getPathComponent(path.getPathCount() - 1);
            if (n instanceof FileNode && !((FileNode)n).getFile().isDirectory()) {
                this.urlComboBox.setSelectedItem(n.getUrlPathString());
            } else if (n instanceof TargetNode) {
                this.urlComboBox.setSelectedItem(n.getUrlPathString());
            }
        }
    }

    protected TreePath urlToTreePath(String url, TreeNode treeNode) {
        ResourceNode resourceNode = this.getNode(url, treeNode);
        if (resourceNode == null) {
            return new TreePath(new TreeNode[]{treeNode});
        }
        ArrayList<ResourceNode> nodeList = new ArrayList<ResourceNode>();
        while (resourceNode != null) {
            nodeList.add(0, resourceNode);
            resourceNode = (ResourceNode)resourceNode.getParent();
        }
        return new TreePath(nodeList.toArray());
    }

    protected ResourceNode getNode(String url, TreeNode treeNode) {
        Stack<TreeNode> nodeStack = new Stack<TreeNode>();
        nodeStack.push(treeNode);
        ResourceNode resourceNode = null;
        while (!nodeStack.isEmpty() && resourceNode == null) {
            ResourceNode node = (ResourceNode)nodeStack.pop();
            if (url.equals(node.getUrlPathString())) {
                resourceNode = node;
            }
            if (node.getChildCount() <= 0) continue;
            nodeStack.addAll(Collections.list(node.children()));
        }
        return resourceNode;
    }

    ResourceNode generateTargetTree(DesignContext designContext) {
        HashMap<String, PageNode> pagesMap = new HashMap<String, PageNode>(16);
        DesignContext[] contexts = designContext.getProject().getDesignContexts();
        for (int i = 0; i < contexts.length; ++i) {
            DesignBean pageBean = contexts[i].getRootContainer();
            if (pageBean == null || !(pageBean.getInstance() instanceof UIViewRoot)) continue;
            PageNode pageNode = new PageNode(null, pageBean);
            DesignBean[] beans = contexts[i].getBeans();
            for (int j = 0; j < beans.length; ++j) {
                Object instance;
                if (!(class$javax$faces$component$UIComponent == null ? UrlPropertyPanel.class$("javax.faces.component.UIComponent") : class$javax$faces$component$UIComponent).isAssignableFrom((instance = beans[j].getInstance()).getClass()) || !this.editor.isTargetComponent((UIComponent)instance)) continue;
                ComponentTargetNode target = new ComponentTargetNode(pageNode, beans[j]);
                pageNode.add(target);
            }
            if (pageBean.getChildBeanCount() > 0 && pageBean.getChildBeans()[0] instanceof MarkupDesignBean) {
                Element pageElement = ((MarkupDesignBean)pageBean.getChildBeans()[0]).getElement();
                NodeList anchorList = pageElement.getElementsByTagName("a");
                for (int j = 0; j < anchorList.getLength(); ++j) {
                    Element element = (Element)anchorList.item(j);
                    if (!element.hasAttribute("name")) continue;
                    ElementTargetNode target = new ElementTargetNode(pageNode, element);
                    pageNode.add(target);
                }
            }
            pagesMap.put(pageNode.getUrlString(), pageNode);
        }
        FileNode rootNode = new FileNode();
        try {
            DesignProject project = this.designContext.getProject();
            File file = project.getResourceFile(new URI("web"));
            FileFilter fileFilter = defaultFileFilter;
            UrlFileFilter urlFileFilter = this.editor.getFileFilter();
            if (urlFileFilter != null) {
                fileFilter = urlFileFilter.getIOFileFilter();
            }
            rootNode.setFile(file);
            Stack<FileNode> nodeStack = new Stack<FileNode>();
            nodeStack.push(rootNode);
            while (!nodeStack.isEmpty()) {
                FileNode node = (FileNode)nodeStack.pop();
                file = node.getFile();
                if (!file.isDirectory()) continue;
                File[] childFiles = file.listFiles(fileFilter);
                for (int i = 0; i < childFiles.length; ++i) {
                    FileNode childNode;
                    File childFile = childFiles[i];
                    if (pagesMap.containsKey(childFile.getName())) {
                        childNode = (PageNode)pagesMap.get(childFile.getName());
                        childNode.setParent(node);
                        childNode.setFile(childFile);
                        node.add(childNode);
                        continue;
                    }
                    childNode = new FileNode(node, childFile);
                    node.add(childNode);
                    nodeStack.push(childNode);
                }
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        return rootNode;
    }

    static class NodeRenderer
    extends DefaultTreeCellRenderer {
        NodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof ComponentTargetNode) {
                this.setIcon(new ImageIcon(((ComponentTargetNode)value).getComponentDesignBean().getBeanInfo().getIcon(1)));
            } else if (value instanceof FileNode) {
                try {
                    FileObject fileObject = FileUtil.toFileObject((File)((FileNode)value).getFile());
                    Image fileImage = DataObject.find((FileObject)fileObject).getNodeDelegate().getIcon(1);
                    this.setIcon(new ImageIcon(fileImage));
                }
                catch (DataObjectNotFoundException e) {
                    // empty catch block
                }
            }
            return this;
        }
    }

    static class ComponentTargetNode
    extends TargetNode {
        DesignBean componentBean;

        ComponentTargetNode(MutableTreeNode parentNode, DesignBean componentBean) {
            super(parentNode);
            this.componentBean = componentBean;
            super.setUrlString(((UIComponent)componentBean.getInstance()).getId());
        }

        DesignBean getComponentDesignBean() {
            return this.componentBean;
        }

        public String toString() {
            return this.componentBean.getInstanceName();
        }
    }

    static class ElementTargetNode
    extends TargetNode {
        Element element;

        ElementTargetNode(MutableTreeNode parentNode, Element element) {
            super(parentNode);
            this.element = element;
            super.setUrlString(element.getAttribute("name"));
        }

        Element getElement() {
            return this.element;
        }

        public String toString() {
            return this.element.getAttribute("name");
        }
    }

    static abstract class TargetNode
    extends ResourceNode {
        TargetNode(MutableTreeNode parentNode) {
            super(parentNode);
        }

        char getPathSepChar() {
            return '#';
        }
    }

    static class PageNode
    extends FileNode {
        DesignBean pageBean;

        PageNode(MutableTreeNode parentNode, DesignBean pageBean) {
            super(parentNode);
            this.pageBean = pageBean;
            super.setUrlString(pageBean.getInstanceName() + ".jsp");
        }

        public String toString() {
            return this.pageBean.getInstanceName();
        }

        String getUrlPathString() {
            return "/faces" + super.getUrlPathString();
        }
    }

    static class FileNode
    extends ResourceNode {
        String suffix;
        private File file;

        FileNode() {
        }

        FileNode(MutableTreeNode parentNode) {
            super(parentNode);
        }

        FileNode(MutableTreeNode parentNode, File file) {
            super(parentNode);
            this.setFile(file);
            super.setUrlString(file.getName());
        }

        File getFile() {
            return this.file;
        }

        void setFile(File file) {
            this.file = file;
            String fileName = this.file.getName();
            if (!file.isDirectory()) {
                int i = fileName.lastIndexOf(46);
                this.suffix = null;
                if (i >= 0) {
                    this.suffix = fileName.substring(i + 1);
                }
            }
        }

        String getSuffix() {
            return this.suffix;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    static class ResourceNode
    implements MutableTreeNode {
        ArrayList children = new ArrayList();
        MutableTreeNode parentNode;
        private String urlString;

        ResourceNode() {
        }

        ResourceNode(MutableTreeNode parentNode) {
            this.parentNode = parentNode;
        }

        public TreeNode getChildAt(int index) {
            return (TreeNode)this.children.get(index);
        }

        void add(MutableTreeNode node) {
            this.children.add(node);
        }

        public void insert(MutableTreeNode child, int index) {
            this.children.add(index, child);
        }

        void clear() {
            this.children.clear();
        }

        public int getIndex(TreeNode node) {
            return this.children.indexOf(node);
        }

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public TreeNode getParent() {
            return this.parentNode;
        }

        public void setParent(MutableTreeNode node) {
            this.parentNode = node;
        }

        public int getChildCount() {
            return this.children.size();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Enumeration children() {
            return Collections.enumeration(this.children);
        }

        char getPathSepChar() {
            return '/';
        }

        public String toString() {
            return null;
        }

        String getUrlString() {
            return this.urlString;
        }

        void setUrlString(String urlString) {
            this.urlString = urlString;
        }

        String getUrlPathString() {
            if (this.getUrlString() == null) {
                return null;
            }
            if (this.getParent() == null) {
                return this.getPathSepChar() + this.getUrlString();
            }
            String parentPathString = ((ResourceNode)this.getParent()).getUrlPathString();
            if (parentPathString == null) {
                return this.getPathSepChar() + this.getUrlString();
            }
            return parentPathString + this.getPathSepChar() + this.getUrlString();
        }

        public void remove(MutableTreeNode node) {
            this.children.remove(node);
        }

        public void remove(int index) {
            this.children.remove(index);
        }

        public void removeFromParent() {
            this.parentNode = null;
        }

        public void setUserObject(Object object) {
        }
    }
}

