/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.propertyeditors.binding.BindingTargetNodeFactory;
import com.sun.rave.propertyeditors.binding.PropertyBindingHelper;
import com.sun.rave.propertyeditors.binding.nodes.PropertyTargetNode;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public abstract class BindingTargetNode
implements TreeNode {
    private static final Bundle bundle = Bundle.getBundle(BindingTargetNode.class);
    private static List factoryList = new ArrayList();
    protected HashMap userDataHash = new HashMap();
    protected BindingTargetNode parent;
    protected Vector children = new Vector();
    protected boolean loaded = false;

    public static void _registerBindingTargetNodeFactory(BindingTargetNodeFactory btnf) {
        factoryList.add(0, btnf);
    }

    public static BindingTargetNode _createTargetNode(BindingTargetNode parent, DesignBean bean, PropertyDescriptor[] propPath, Object propInstance) {
        Object o;
        Class<?> targetClass;
        if (bean == null) {
            return null;
        }
        Class<?> clazz = targetClass = propInstance != null ? propInstance.getClass() : null;
        if (targetClass == null && propPath != null && propPath.length > 0) {
            o = PropertyBindingHelper.getPropInstance(bean, propPath);
            if (o != null) {
                propInstance = o;
                targetClass = o.getClass();
            } else {
                targetClass = propPath[propPath.length - 1].getPropertyType();
            }
        }
        if (targetClass == null) {
            o = bean.getInstance();
            if (o != null) {
                propInstance = o;
                targetClass = o.getClass();
            } else {
                targetClass = bean.getBeanInfo().getBeanDescriptor().getBeanClass();
            }
        }
        for (int i = 0; i < factoryList.size(); ++i) {
            BindingTargetNode btn;
            BindingTargetNodeFactory tnf = (BindingTargetNodeFactory)factoryList.get(i);
            if (!tnf.supportsTargetClass(targetClass) || (btn = tnf.createTargetNode(parent, bean, propPath, propInstance)) == null) continue;
            return btn;
        }
        return new PropertyTargetNode(parent, bean, propPath, propInstance);
    }

    public abstract boolean lazyLoad();

    public abstract boolean isValidBindingTarget();

    public abstract String getBindingExpressionPart();

    public abstract Class getTargetTypeClass();

    public abstract String getDisplayText(boolean var1);

    public BindingTargetNode(BindingTargetNode parent) {
        this.parent = parent;
    }

    public Map getUserDataMap() {
        return this.userDataHash;
    }

    public boolean hasDisplayIcon() {
        return false;
    }

    public Icon getDisplayIcon(boolean enabled) {
        return null;
    }

    public JComponent getCustomDisplayPanel(ActionListener updateCallback) {
        return null;
    }

    public String getTargetTypeDisplayName() {
        Class c = this.getTargetTypeClass();
        if (c != null) {
            return PropertyBindingHelper.getPrettyTypeName(c.getName());
        }
        return "";
    }

    public DefaultTreeModel getTreeModel() {
        for (TreeNode p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Root)) continue;
            return ((Root)p).getTreeModel();
        }
        return null;
    }

    public void add(BindingTargetNode child) {
        if (child instanceof BindingTargetNode) {
            this.children.add(child);
            child.setParent(this);
        }
    }

    public void add(int index, BindingTargetNode child) {
        if (child instanceof BindingTargetNode) {
            this.children.add(index, child);
            child.setParent(this);
        }
    }

    public void remove(BindingTargetNode child) {
        this.children.remove(child);
    }

    public void removeAll() {
        this.children.clear();
        this.loaded = false;
    }

    public void setParent(BindingTargetNode parent) {
        if (parent instanceof BindingTargetNode) {
            this.parent = parent;
        }
    }

    public TreeNode getChildAt(int childIndex) {
        if (!this.loaded) {
            this.loaded = this.lazyLoad();
        }
        if (this.children.size() > childIndex) {
            return (TreeNode)this.children.get(childIndex);
        }
        return null;
    }

    public int getChildCount() {
        if (!this.loaded) {
            this.loaded = this.lazyLoad();
        }
        return this.children.size();
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public int getIndex(TreeNode node) {
        if (!this.loaded) {
            this.loaded = this.lazyLoad();
        }
        return this.children.indexOf(node);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        if (!this.loaded) {
            this.loaded = this.lazyLoad();
        }
        return this.children.size() == 0;
    }

    public Enumeration children() {
        if (!this.loaded) {
            this.loaded = this.lazyLoad();
        }
        return this.children.elements();
    }

    static /* synthetic */ Bundle access$000() {
        return bundle;
    }

    public static class Null
    extends BindingTargetNode {
        protected String displayText = "<html><b>" + BindingTargetNode.access$000().getMessage("propertyNotBound") + "</b></html>";

        public Null(BindingTargetNode parent) {
            super(parent);
        }

        public boolean lazyLoad() {
            return true;
        }

        public String getDisplayText(boolean enableNode) {
            return this.displayText;
        }

        public boolean isValidBindingTarget() {
            return true;
        }

        public String getBindingExpressionPart() {
            return null;
        }

        public Class getTargetTypeClass() {
            return null;
        }
    }

    public static class Root
    extends BindingTargetNode {
        protected DefaultTreeModel treeModel;

        public Root() {
            super(null);
        }

        protected void setTreeModel(DefaultTreeModel treeModel) {
            this.treeModel = treeModel;
        }

        public DefaultTreeModel getTreeModel() {
            return this.treeModel;
        }

        public boolean lazyLoad() {
            return true;
        }

        public String getDisplayText(boolean enableNode) {
            return null;
        }

        public boolean isValidBindingTarget() {
            return false;
        }

        public String getBindingExpressionPart() {
            return null;
        }

        public Class getTargetTypeClass() {
            return null;
        }
    }
}

