/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.propertyeditors.binding.BindingTargetCallback;
import com.sun.rave.propertyeditors.binding.BindingTargetNode;
import com.sun.rave.propertyeditors.binding.nodes.ContextTargetNode;
import com.sun.rave.propertyeditors.binding.nodes.DataProviderTargetNodeFactory;
import com.sun.rave.propertyeditors.binding.nodes.MapTargetNodeFactory;
import com.sun.rave.propertyeditors.binding.nodes.PropertyTargetNode;
import com.sun.rave.propertyeditors.binding.nodes.ResultSetTargetNodeFactory;
import com.sun.rave.propertyeditors.binding.nodes.UIDataVarNode;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.faces.component.UIData;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BindingTargetPanel
extends JPanel {
    JLabel targetLabel = new JLabel();
    JScrollPane targetScroll = new JScrollPane();
    JTree tree = new HiddenSelectionJTree();
    BindingTargetNode.Root rootNode = new BindingTargetNode.Root();
    DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagConstraints customPanelConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(-4, 12, 11, 0), 0, 0);
    private DesignBean targetBean = null;
    private static final Bundle bundle = Bundle.getBundle(BindingTargetPanel.class);
    protected BindingTargetCallback bindingCallback;
    protected DesignContext showingContext = null;
    protected UIDataVarNode varNode = null;
    protected DesignBean showingBean = null;
    protected DesignProperty showingProp = null;
    ActionListener updateCallback = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            BindingTargetPanel.this.refreshExpr();
        }
    };
    JComponent customPanel = null;
    boolean needsRefresh = false;
    public static Icon BEAN_ICON;
    public static Icon TAG_ICON;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public BindingTargetPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.rootNode.setTreeModel(this.treeModel);
        this.tree.getAccessibleContext().setAccessibleName(bundle.getMessage("TARGET_BINDING_TREE_ACCESS_NAME"));
        this.tree.getAccessibleContext().setAccessibleDescription(bundle.getMessage("TARGET_BINDING_TREE_ACCESS_DESC"));
        this.targetLabel.setLabelFor(this.tree);
        this.targetLabel.setDisplayedMnemonic(bundle.getMessage("TARGET_LABEL_DISPLAYED_MNEMONIC").charAt(0));
    }

    public BindingTargetPanel(BindingTargetCallback bindingCallback) {
        this();
        this.bindingCallback = bindingCallback;
    }

    protected DesignContext[] sortContexts(DesignContext[] contexts) {
        DesignContext c;
        int i;
        ArrayList<DesignContext> sortList = new ArrayList<DesignContext>();
        TreeMap<String, DesignContext> nameMap = new TreeMap<String, DesignContext>();
        for (int i2 = 0; i2 < contexts.length; ++i2) {
            nameMap.put(contexts[i2].getDisplayName(), contexts[i2]);
        }
        String[] names = nameMap.keySet().toArray(new String[nameMap.size()]);
        for (i = 0; i < names.length; ++i) {
            c = (DesignContext)nameMap.get(names[i]);
            if (!"request".equals(c.getContextData("scope"))) continue;
            sortList.add(c);
        }
        for (i = 0; i < names.length; ++i) {
            c = (DesignContext)nameMap.get(names[i]);
            if (!"session".equals(c.getContextData("scope"))) continue;
            sortList.add(c);
        }
        for (i = 0; i < names.length; ++i) {
            c = (DesignContext)nameMap.get(names[i]);
            if (!"application".equals(c.getContextData("scope"))) continue;
            sortList.add(c);
        }
        for (i = 0; i < names.length; ++i) {
            c = (DesignContext)nameMap.get(names[i]);
            if (!"none".equals(c.getContextData("scope"))) continue;
            sortList.add(c);
        }
        return sortList.toArray(new DesignContext[sortList.size()]);
    }

    protected DesignBean findUIDataParentWithVar(DesignBean fromBean) {
        Object var;
        DesignProperty varProp;
        DesignBean b;
        for (b = fromBean.getBeanParent(); b != null && !(b.getInstance() instanceof UIData); b = b.getBeanParent()) {
        }
        if (b != null && b.getInstance() instanceof UIData && (varProp = b.getProperty("var")) != null && (var = varProp.getValue()) != null) {
            return b;
        }
        return null;
    }

    public void sourceContextChanged(DesignContext context) {
        if (this.showingContext != null && this.showingContext == context) {
            return;
        }
        this.showingContext = context;
        this.rootNode.removeAll();
        this.rootNode.add(new BindingTargetNode.Null(this.rootNode));
        ArrayList<TreePath> expands = new ArrayList<TreePath>();
        if (context != null && context.getProject() != null) {
            DesignContext[] acs = context.getProject().getDesignContexts();
            acs = this.sortContexts(acs);
            for (int i = 0; acs != null && i < acs.length; ++i) {
                ContextTargetNode node = new ContextTargetNode(this.rootNode, acs[i]);
                expands.add(new TreePath(new Object[]{this.rootNode, node}));
                this.rootNode.add(node);
            }
        }
        this.treeModel.reload();
        this.tree.validate();
        for (int i = 0; i < expands.size(); ++i) {
            this.tree.expandPath((TreePath)expands.get(i));
        }
        this.refreshTarget();
    }

    public void sourceBeanChanged(DesignBean bean) {
        DesignBean uiDataBean;
        if (this.showingBean == bean) {
            return;
        }
        this.showingBean = bean;
        if (this.varNode != null) {
            this.rootNode.remove(this.varNode);
            this.treeModel.reload();
            this.tree.validate();
            this.varNode = null;
        }
        if (this.showingBean != null && (uiDataBean = this.findUIDataParentWithVar(this.showingBean)) != null) {
            this.varNode = new UIDataVarNode(this.rootNode, uiDataBean);
            this.rootNode.add(1, this.varNode);
            this.treeModel.reload();
            this.tree.validate();
        }
        this.refreshTarget();
    }

    public void sourcePropertyChanged(DesignProperty prop) {
        if (this.showingProp == prop) {
            return;
        }
        this.showingProp = prop;
        this.refreshTarget();
    }

    public void refreshTarget() {
        if (this.showingProp != null) {
            boolean bound;
            String vx = this.showingProp.getValueSource();
            boolean bl = bound = vx != null && vx.startsWith("#{") && vx.endsWith("}");
            if (bound) {
                this.selectNodeForExpression(vx.substring(2, vx.length() - 1));
            } else {
                this.tree.setSelectionRow(0);
            }
        } else {
            this.tree.setSelectionRow(0);
        }
        this.repaint(100L);
    }

    TreeNode findChildNodeForExprPart(TreeNode node, String exprPart) {
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            BindingTargetNode btn;
            TreeNode n = e.nextElement();
            if (!(n instanceof BindingTargetNode) || !exprPart.equals((btn = (BindingTargetNode)n).getBindingExpressionPart())) continue;
            return n;
        }
        return null;
    }

    void selectNodeForExpression(String expr) {
        TreeNode node;
        StringTokenizer st = new StringTokenizer(expr, ".");
        ArrayList<Object> parts = new ArrayList<Object>();
        while (st.hasMoreElements()) {
            parts.add(st.nextElement());
        }
        BindingTargetNode.Root lastNode = node = this.rootNode;
        while (parts.size() > 0 && (node = this.findChildNodeForExprPart(lastNode, (String)parts.get(0))) != null) {
            parts.remove(0);
            lastNode = node;
        }
        if (lastNode != null && lastNode != this.rootNode) {
            this.tree.setSelectionPath(this.createPath(lastNode));
        } else {
            this.tree.setSelectionRow(0);
        }
    }

    TreePath createPath(TreeNode node) {
        ArrayList<TreeNode> path = new ArrayList<TreeNode>();
        while (node != null) {
            path.add(0, node);
            node = node.getParent();
        }
        return new TreePath(path.toArray(new TreeNode[path.size()]));
    }

    String calcExpression(BindingTargetNode targetNode) {
        this.targetBean = null;
        ArrayList<String> parts = new ArrayList<String>();
        for (TreeNode n = targetNode; n != null; n = n.getParent()) {
            String ep;
            BindingTargetNode btn;
            if (n instanceof PropertyTargetNode) {
                PropertyTargetNode ptn = (PropertyTargetNode)n;
                if (!ptn.isValidBindingTarget()) continue;
                PropertyDescriptor[] propPath = ptn.getPropPath();
                if (propPath != null) {
                    for (int i = propPath.length - 1; i >= 0; --i) {
                        parts.add(0, propPath[i].getName());
                    }
                }
                this.targetBean = ptn.getBean();
                parts.add(0, ptn.getBean().getInstanceName());
                DesignContext c = ptn.getBean().getDesignContext();
                if (c instanceof FacesDesignContext) {
                    parts.add(0, ((FacesDesignContext)c).getReferenceName());
                    break;
                }
                parts.add(0, c.getDisplayName());
                break;
            }
            if (!(n instanceof BindingTargetNode) || !(btn = n).isValidBindingTarget() || (ep = btn.getBindingExpressionPart()) == null) continue;
            String siStart = "selectItems['";
            String siEnd = "']";
            if (ep.startsWith(siStart) && ep.endsWith(siEnd) && ep.length() > siStart.length() + siEnd.length()) {
                String epCrux = ep.substring(siStart.length(), ep.length() - siEnd.length());
                epCrux = epCrux.replaceAll("\\'", "\\\\'");
                ep = siStart + epCrux + siEnd;
            }
            parts.add(0, ep);
        }
        if (parts.size() > 0) {
            StringBuffer expr = new StringBuffer();
            expr.append("#{");
            for (int i = 0; i < parts.size(); ++i) {
                String part = "" + parts.get(i);
                if (i > 0 && !part.startsWith("[")) {
                    expr.append(".");
                }
                expr.append(part);
            }
            expr.append("}");
            return expr.toString();
        }
        return "";
    }

    void refreshExpr() {
        TreePath tp;
        if (this.customPanel != null) {
            this.remove(this.customPanel);
            this.customPanel = null;
            this.needsRefresh = true;
        }
        if ((tp = this.tree.getSelectionPath()) != null) {
            Object o = tp.getLastPathComponent();
            if (o instanceof BindingTargetNode) {
                BindingTargetNode btn = (BindingTargetNode)o;
                this.bindingCallback.setNewExpressionText(this.calcExpression(btn));
                this.customPanel = btn.getCustomDisplayPanel(this.updateCallback);
                if (this.customPanel != null) {
                    this.add((Component)this.customPanel, this.customPanelConstraints);
                    this.needsRefresh = true;
                }
            } else {
                this.bindingCallback.setNewExpressionText("");
            }
        } else {
            this.bindingCallback.setNewExpressionText("");
        }
        if (this.needsRefresh) {
            this.bindingCallback.refresh();
        }
    }

    public DesignBean getTargetBean() {
        return this.targetBean;
    }

    void jbInit() throws Exception {
        this.targetLabel.setText(bundle.getMessage("selectTarget"));
        this.targetLabel.setDisplayedMnemonic(bundle.getMessage("selectTargeDisplayedMnemonic").charAt(0));
        this.tree.setModel(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new TargetTreeRenderer());
        this.tree.setSelectionModel(this.treeSelectionModel);
        this.treeSelectionModel.setSelectionMode(1);
        this.treeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                BindingTargetPanel.this.refreshExpr();
            }
        });
        this.treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                BindingTargetPanel.this.updateTreePainting();
            }

            public void treeNodesInserted(TreeModelEvent e) {
                BindingTargetPanel.this.updateTreePainting();
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                BindingTargetPanel.this.updateTreePainting();
            }

            public void treeStructureChanged(TreeModelEvent e) {
                BindingTargetPanel.this.updateTreePainting();
            }
        });
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.targetLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 2, 8), 0, 0));
        this.add((Component)this.targetScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 8, 8), 0, 0));
        this.targetScroll.getViewport().add((Component)this.tree, null);
    }

    private void updateTreePainting() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BindingTargetPanel.this.tree.validate();
                BindingTargetPanel.this.targetScroll.validate();
            }
        });
    }

    static {
        BindingTargetNode._registerBindingTargetNodeFactory(new ResultSetTargetNodeFactory());
        BindingTargetNode._registerBindingTargetNodeFactory(new MapTargetNodeFactory());
        BindingTargetNode._registerBindingTargetNodeFactory(new DataProviderTargetNodeFactory());
        BEAN_ICON = new ImageIcon(BindingTargetPanel.class.getResource("img/property.gif"));
        TAG_ICON = new ImageIcon(BindingTargetPanel.class.getResource("img/html_element.png"));
    }

    static class HiddenSelectionJTree
    extends JTree {
        HiddenSelectionJTree() {
        }

        protected boolean removeDescendantSelectedPaths(TreePath path, boolean includePath) {
            return false;
        }
    }

    class TargetTreeRenderer
    extends DefaultTreeCellRenderer {
        TargetTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            boolean enableNode = true;
            if (value instanceof BindingTargetNode) {
                Icon customIcon;
                String customText;
                Class showingPropType;
                BindingTargetNode btn = (BindingTargetNode)value;
                if (BindingTargetPanel.this.showingProp != null && (showingPropType = BindingTargetPanel.this.showingProp.getPropertyDescriptor().getPropertyType()) != null) {
                    Class tc;
                    if (showingPropType.isPrimitive()) {
                        if (showingPropType == Boolean.TYPE) {
                            showingPropType = class$java$lang$Boolean == null ? (class$java$lang$Boolean = BindingTargetPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                        } else if (showingPropType == Character.TYPE) {
                            showingPropType = class$java$lang$Character == null ? (class$java$lang$Character = BindingTargetPanel.class$("java.lang.Character")) : class$java$lang$Character;
                        } else if (showingPropType == Byte.TYPE) {
                            showingPropType = class$java$lang$Byte == null ? (class$java$lang$Byte = BindingTargetPanel.class$("java.lang.Byte")) : class$java$lang$Byte;
                        } else if (showingPropType == Short.TYPE) {
                            showingPropType = class$java$lang$Short == null ? (class$java$lang$Short = BindingTargetPanel.class$("java.lang.Short")) : class$java$lang$Short;
                        } else if (showingPropType == Integer.TYPE) {
                            showingPropType = class$java$lang$Integer == null ? (class$java$lang$Integer = BindingTargetPanel.class$("java.lang.Integer")) : class$java$lang$Integer;
                        } else if (showingPropType == Long.TYPE) {
                            showingPropType = class$java$lang$Long == null ? (class$java$lang$Long = BindingTargetPanel.class$("java.lang.Long")) : class$java$lang$Long;
                        } else if (showingPropType == Float.TYPE) {
                            showingPropType = class$java$lang$Float == null ? (class$java$lang$Float = BindingTargetPanel.class$("java.lang.Float")) : class$java$lang$Float;
                        } else if (showingPropType == Double.TYPE) {
                            Class clazz = showingPropType = class$java$lang$Double == null ? (class$java$lang$Double = BindingTargetPanel.class$("java.lang.Double")) : class$java$lang$Double;
                        }
                    }
                    if ((tc = btn.getTargetTypeClass()) != null) {
                        enableNode = showingPropType.isAssignableFrom(tc);
                    }
                }
                if ((customText = btn.getDisplayText(enableNode)) != null) {
                    this.setText(customText);
                }
                if (btn.hasDisplayIcon() && (customIcon = btn.getDisplayIcon(enableNode)) != null) {
                    this.setIcon(customIcon);
                }
            }
            return this;
        }
    }
}

