/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.propertyeditors.binding.BindingSourcePanel;
import com.sun.rave.propertyeditors.binding.BindingTargetCallback;
import com.sun.rave.propertyeditors.binding.BindingTargetPanel;
import com.sun.rave.propertyeditors.binding.PropertyBindingsCustomizer;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PropertyBindingPanel
extends JPanel
implements BindingTargetCallback {
    private static final Bundle bundle = Bundle.getBundle(PropertyBindingPanel.class);
    JTextField curExprTextField = new JTextField();
    JTextField newExprTextField = new JTextField();
    JLabel curExprLabel = new JLabel();
    JLabel newExprLabel = new JLabel();
    JButton clearButton = new JButton();
    JButton applyButton = new JButton();
    JPanel topPanel = new JPanel();
    BindingSourcePanel sourcePanel = new BindingSourcePanel(this);
    BindingTargetPanel targetPanel = new BindingTargetPanel(this);
    JPanel filler1 = new JPanel();
    JPanel filler2 = new JPanel();
    protected boolean showSourcePanel = true;
    protected PropertyBindingsCustomizer customizer;
    protected DesignContext context;
    protected DesignBean sourceBean;
    protected DesignProperty prop;

    public PropertyBindingPanel() {
        try {
            this.jbInit();
            this.curExprLabel.setLabelFor(this.curExprTextField);
            this.newExprLabel.setLabelFor(this.newExprTextField);
            this.curExprLabel.setDisplayedMnemonic(bundle.getMessage("currBindingForPropDisplayedMnemonic").charAt(0));
            this.newExprLabel.setDisplayedMnemonic(bundle.getMessage("newBindingForPropDisplayedMnemonic").charAt(0));
            this.curExprTextField.getAccessibleContext().setAccessibleName(bundle.getMessage("CURR_EXP_ACCESS_NAME"));
            this.curExprTextField.getAccessibleContext().setAccessibleDescription(bundle.getMessage("CURR_EXP_ACCESS_DESC"));
            this.newExprTextField.getAccessibleContext().setAccessibleName(bundle.getMessage("NEW_EXP_ACCESS_NAME"));
            this.newExprTextField.getAccessibleContext().setAccessibleDescription(bundle.getMessage("NEW_EXP_ACCESS_DESC"));
            this.clearButton.getAccessibleContext().setAccessibleDescription(bundle.getMessage("CLEAR_BUTTON_ACCESS_DESC"));
            this.applyButton.getAccessibleContext().setAccessibleDescription(bundle.getMessage("APPLY_BUTTON_ACCESS_DESC"));
            this.clearButton.setMnemonic(bundle.getMessage("CLEAR_BUTTON_MNEMONIC").charAt(0));
            this.applyButton.setMnemonic(bundle.getMessage("APPLY_BUTTON_MNEMONIC").charAt(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public void setShowSourcePanel(boolean showSource) {
        this.showSourcePanel = showSource;
        this.refresh();
    }

    public boolean isShowSourcePanel() {
        return this.showSourcePanel;
    }

    public void setCustomizer(PropertyBindingsCustomizer bc) {
        this.customizer = bc;
    }

    public void setSourceContext(DesignContext context) {
        this.context = context;
        this.sourcePanel.sourceContextChanged(context);
        this.targetPanel.sourceContextChanged(context);
        this.refreshCurExprText();
    }

    public DesignContext getSourceContext() {
        return this.context;
    }

    public void setSourceBean(DesignBean bean) {
        this.sourceBean = bean;
        if (bean != null && this.context != bean.getDesignContext()) {
            this.setSourceContext(bean.getDesignContext());
        }
        this.sourcePanel.sourceBeanChanged(bean);
        this.targetPanel.sourceBeanChanged(bean);
        this.refreshCurExprText();
    }

    public DesignBean getSourceBean() {
        return this.sourceBean;
    }

    public void setSourceProperty(DesignProperty prop) {
        this.prop = prop;
        if (prop != null && this.sourceBean != prop.getDesignBean()) {
            this.setSourceBean(prop.getDesignBean());
        }
        this.sourcePanel.sourcePropertyChanged(prop);
        this.targetPanel.sourcePropertyChanged(prop);
        this.refreshCurExprText();
    }

    public DesignProperty getSourceProperty() {
        return this.prop;
    }

    public void refreshCurExprText() {
        String vx;
        DesignProperty p = this.getSourceProperty();
        String pt = p != null ? p.getPropertyDescriptor().getName() : "<font color=\"red\">" + bundle.getMessage("pickOneBrackets") + "</font>";
        DesignBean b = this.getSourceBean();
        this.curExprLabel.setText("<html>" + bundle.getMessage("currBindingForProp", pt) + "</html>");
        String nx = this.newExprTextField.getText();
        this.applyButton.setEnabled(b != null && p != null && nx != null && !"".equals(nx));
        if (p != null && (vx = p.getValueSource()) != null && vx.startsWith("#{") && vx.endsWith("}")) {
            this.curExprTextField.setText(vx);
            this.clearButton.setEnabled(true);
            return;
        }
        this.curExprTextField.setText(null);
        this.clearButton.setEnabled(false);
        if (this.customizer != null) {
            this.customizer.firePropertyChange();
        }
    }

    public void refreshApplyState() {
        DesignProperty p = this.getSourceProperty();
        DesignBean b = this.getSourceBean();
        String nx = this.newExprTextField.getText();
        this.applyButton.setEnabled(b != null && p != null && nx != null && !"".equals(nx));
        if (this.customizer != null) {
            this.customizer.firePropertyChange();
        }
    }

    public boolean isModified() {
        String oldEx = this.curExprTextField.getText();
        String newEx = this.newExprTextField.getText();
        return !(oldEx == null && newEx == null || oldEx != null && oldEx.equals(newEx));
    }

    public void setNewExpressionText(String newExpr) {
        if (this.targetPanel.getTargetBean() != this.getSourceBean()) {
            this.newExprTextField.setText(newExpr.trim());
            this.applyButton.setEnabled(true);
            this.refreshCurExprText();
        } else {
            this.newExprTextField.setText(bundle.getMessage("MSG_INVALID_TARGET"));
            this.applyButton.setEnabled(false);
        }
    }

    public void refresh() {
        if (this.showSourcePanel) {
            this.topPanel.add((Component)this.sourcePanel, "West");
        } else {
            this.topPanel.remove(this.sourcePanel);
        }
        this.refreshCurExprText();
        this.validate();
        this.doLayout();
        this.repaint(100L);
    }

    void doClearExpr() {
        DesignProperty p = this.getSourceProperty();
        if (p != null) {
            p.setValueSource(null);
            this.refresh();
        }
    }

    void doApplyExpr() {
        DesignProperty p;
        if (this.applyButton.isEnabled() && (p = this.getSourceProperty()) != null) {
            p.setValueSource(this.newExprTextField.getText());
            this.refresh();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.topPanel.setLayout(new BorderLayout(0, 0));
        this.curExprTextField.setText("");
        this.curExprTextField.setEditable(false);
        this.curExprTextField.setBackground(SystemColor.control);
        this.newExprTextField.setText("");
        this.newExprTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                PropertyBindingPanel.this.refreshApplyState();
            }

            public void removeUpdate(DocumentEvent e) {
                PropertyBindingPanel.this.refreshApplyState();
            }

            public void changedUpdate(DocumentEvent e) {
                PropertyBindingPanel.this.refreshApplyState();
            }
        });
        String boldRedPickOne = "<b><font color=\"red\">" + bundle.getMessage("pickOneBrackets") + "</font></b>";
        this.curExprLabel.setText("<html>" + bundle.getMessage("currBindingForProp", boldRedPickOne) + "</html>");
        this.newExprLabel.setText(bundle.getMessage("newBindExpr"));
        this.curExprLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 3 && e.isMetaDown()) {
                    PropertyBindingPanel.this.setShowSourcePanel(!PropertyBindingPanel.this.isShowSourcePanel());
                }
            }
        });
        this.clearButton.setText(bundle.getMessage("clear"));
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyBindingPanel.this.doClearExpr();
            }
        });
        this.applyButton.setText(bundle.getMessage("apply"));
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyBindingPanel.this.doApplyExpr();
            }
        });
        this.filler1.setBackground(SystemColor.controlShadow);
        this.filler1.setOpaque(true);
        this.filler2.setBackground(SystemColor.controlShadow);
        this.filler2.setOpaque(true);
        if (this.showSourcePanel) {
            this.topPanel.add((Component)this.sourcePanel, "West");
        }
        this.topPanel.add((Component)this.targetPanel, "Center");
        this.topPanel.add((Component)this.filler1, "South");
        this.add((Component)this.topPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.curExprLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 8), 0, 0));
        this.add((Component)this.curExprTextField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.clearButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 4, 0, 8), 0, 0));
        this.add((Component)this.newExprLabel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(4, 8, 0, 8), 0, 0));
        this.add((Component)this.newExprTextField, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.applyButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 4, 0, 8), 0, 0));
        this.add((Component)this.filler2, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 2, new Insets(8, 0, 0, 0), 0, -9));
    }
}

