/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding.data;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.faces.FacesDesignProperty;
import com.sun.rave.propertyeditors.binding.BindingTargetCallback;
import com.sun.rave.propertyeditors.binding.data.BindValueToObjectPanel;
import com.sun.rave.propertyeditors.binding.data.DataBindingPanel;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class TabbedDataBindingPanel
extends DataBindingPanel
implements BindingTargetCallback {
    private static final Bundle bundle = Bundle.getBundle(TabbedDataBindingPanel.class);
    protected JTabbedPane tabs = new JTabbedPane();
    protected JTextField valueTextField = new JTextField(70);
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected JLabel valueLabel = new JLabel();
    private static Class[] BINDING_PANEL_CONSTRUCTOR_SIG = new Class[]{BindingTargetCallback.class, DesignProperty.class};
    protected boolean initializing = true;
    static /* synthetic */ Class class$com$sun$rave$propertyeditors$binding$data$BindValueToObjectPanel;
    static /* synthetic */ Class class$com$sun$data$provider$DataProvider;

    public String getDataBindingTitle() {
        return bundle.getMessage("bindToData");
    }

    public void refresh() {
        this.validate();
        this.doLayout();
        this.repaint(100L);
        this.bindingCallback.refresh();
    }

    public void setNewExpressionText(String newExpr) {
        if (this.initializing) {
            return;
        }
        this.valueTextField.setText(newExpr);
        this.bindingCallback.setNewExpressionText(newExpr);
    }

    public String getNewExpressionText() {
        return this.valueTextField.getText();
    }

    public TabbedDataBindingPanel(BindingTargetCallback callback, DesignProperty prop, Class[] bindingPanelClasses, boolean showExpr) {
        super(callback, prop);
        DataBindingPanel bp;
        this.valueTextField.setText(prop.getValueSource());
        this.valueLabel.setLabelFor(this.valueTextField);
        this.valueLabel.setDisplayedMnemonic(bundle.getMessage("VALUE_EXP_DISPLAYED_MNEMONIC").charAt(0));
        this.valueTextField.getAccessibleContext().setAccessibleName(bundle.getMessage("VALUE_EXP_ACCESS_NAME"));
        this.valueTextField.getAccessibleContext().setAccessibleDescription(bundle.getMessage("VALUE_EXP_ACCESS_DESC"));
        ArrayList<DataBindingPanel> bindingPanels = new ArrayList<DataBindingPanel>();
        if (bindingPanelClasses != null && bindingPanelClasses.length > 0) {
            for (int i = 0; i < bindingPanelClasses.length; ++i) {
                try {
                    Constructor con = bindingPanelClasses[i].getConstructor(BINDING_PANEL_CONSTRUCTOR_SIG);
                    bp = (DataBindingPanel)con.newInstance(this, prop);
                    bindingPanels.add(bp);
                    continue;
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        } else {
            bindingPanels.add(new BindValueToObjectPanel(this, prop));
        }
        this.setLayout(this.gridBagLayout1);
        String lbl_current = bundle.getMessage("LBL_Current");
        String lbl_setting = bundle.getMessage("LBL_Setting");
        this.valueLabel.setText(lbl_current + " " + this.designProperty.getPropertyDescriptor().getDisplayName() + " " + lbl_setting);
        if (showExpr && bindingPanels.size() > 0) {
            this.add((Component)this.valueLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 2, 8), 0, 0));
            this.add((Component)this.valueTextField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 4, 8), 0, 0));
        }
        if (bindingPanels.size() > 1) {
            boolean shouldShowBindToObjectPanel = this.showBindToObjectPanel();
            this.add((Component)this.tabs, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 8, 8), 0, 0));
            int selectedIndex = 0;
            for (int i = 0; i < bindingPanels.size(); ++i) {
                DataBindingPanel bp2 = (DataBindingPanel)bindingPanels.get(i);
                this.tabs.add((Component)bp2, bp2.getDataBindingTitle());
                if (!shouldShowBindToObjectPanel || !bp2.getClass().isAssignableFrom(class$com$sun$rave$propertyeditors$binding$data$BindValueToObjectPanel == null ? TabbedDataBindingPanel.class$("com.sun.rave.propertyeditors.binding.data.BindValueToObjectPanel") : class$com$sun$rave$propertyeditors$binding$data$BindValueToObjectPanel)) continue;
                selectedIndex = i;
            }
            this.tabs.setSelectedIndex(selectedIndex);
        } else if (bindingPanels.size() > 0) {
            bp = (DataBindingPanel)bindingPanels.get(0);
            this.add((Component)bp, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 8, 8), 0, 0));
        }
        this.initializing = false;
    }

    private boolean showBindToObjectPanel() {
        String valueExpression = null;
        if (this.designProperty instanceof FacesDesignProperty) {
            FacesDesignProperty fprop = (FacesDesignProperty)this.designProperty;
            if (fprop.isBound() && fprop.getValueBinding() != null) {
                valueExpression = fprop.getValueBinding().getExpressionString();
            }
        } else {
            valueExpression = this.designProperty.getValueSource();
        }
        if (valueExpression != null) {
            boolean dataProviderBound = false;
            DesignContext[] contexts = this.designProperty.getDesignBean().getDesignContext().getProject().getDesignContexts();
            block0: for (int i = 0; i < contexts.length; ++i) {
                DesignBean[] dpbs = contexts[i].getBeansOfType(class$com$sun$data$provider$DataProvider == null ? TabbedDataBindingPanel.class$("com.sun.data.provider.DataProvider") : class$com$sun$data$provider$DataProvider);
                for (int j = 0; j < dpbs.length; ++j) {
                    String modelBindingExpr = ((FacesDesignContext)contexts[i]).getBindingExpr(dpbs[j]);
                    int startIndex = modelBindingExpr.indexOf(123);
                    int endIndex = modelBindingExpr.indexOf(125);
                    if (startIndex != -1 && endIndex != -1) {
                        modelBindingExpr = modelBindingExpr.substring(startIndex + 2, endIndex - 1);
                    }
                    if (valueExpression.indexOf(modelBindingExpr) == -1) continue;
                    dataProviderBound = true;
                    continue block0;
                }
            }
            if (!dataProviderBound) {
                return true;
            }
        }
        return false;
    }
}

