/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding.nodes;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import com.sun.rave.propertyeditors.binding.BindingTargetNode;
import com.sun.rave.propertyeditors.binding.BindingTargetPanel;
import com.sun.rave.propertyeditors.binding.PropertyBindingHelper;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PropertyTargetNode
extends BindingTargetNode {
    private static Bundle bundle = Bundle.getBundle(PropertyTargetNode.class);
    protected DesignBean bean;
    protected PropertyDescriptor[] propPath;
    protected Object propInstance;
    protected String displayTextEnabled;
    protected String displayTextDisabled;
    boolean iconChecked = false;
    Icon displayIcon = null;

    public PropertyTargetNode(BindingTargetNode parent, DesignBean bean, PropertyDescriptor[] propPath, Object propInstance) {
        super(parent);
        this.bean = bean;
        this.propPath = propPath;
        this.propInstance = propInstance;
        this.displayTextEnabled = this.getDisplayText(true);
        this.displayTextDisabled = this.getDisplayText(false);
    }

    public DesignBean getBean() {
        return this.bean;
    }

    public PropertyDescriptor[] getPropPath() {
        return this.propPath;
    }

    public Object getPropInstance() {
        return this.propInstance;
    }

    public boolean lazyLoad() {
        this.lazyLoadCustomTargetNodes();
        if (this.propPath == null) {
            this.lazyLoadBeanTargetNodes();
        }
        if (this.isValidBindingTarget()) {
            this.lazyLoadPropertyTargetNodes();
        }
        return true;
    }

    public void lazyLoadCustomTargetNodes() {
    }

    public void lazyLoadBeanTargetNodes() {
        if (this.bean.isContainer()) {
            DesignBean[] kids = this.bean.getChildBeans();
            for (int i = 0; kids != null && i < kids.length; ++i) {
                super.add(PropertyTargetNode._createTargetNode(this, kids[i], null, kids[i].getInstance()));
            }
        }
    }

    public void lazyLoadPropertyTargetNodes() {
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.getTargetTypeClass());
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            for (int i = 0; pds != null && i < pds.length; ++i) {
                if (pds[i].getReadMethod() == null || pds[i].getReadMethod().getName().equals("getClass")) continue;
                ArrayList<PropertyDescriptor> pdList = new ArrayList<PropertyDescriptor>();
                for (int j = 0; this.propPath != null && j < this.propPath.length; ++j) {
                    pdList.add(this.propPath[j]);
                }
                pdList.add(pds[i]);
                PropertyDescriptor[] pda = pdList.toArray(new PropertyDescriptor[pdList.size()]);
                BindingTargetNode btn = PropertyTargetNode._createTargetNode(this, this.bean, pda, null);
                super.add(btn);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public String getDisplayText(boolean enableNode) {
        if (enableNode && this.displayTextEnabled != null) {
            return this.displayTextEnabled;
        }
        if (!enableNode && this.displayTextDisabled != null) {
            return this.displayTextDisabled;
        }
        PropertyDescriptor pd = this.propPath != null && this.propPath.length > 0 ? this.propPath[this.propPath.length - 1] : null;
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        if (!enableNode) {
            sb.append("<font color=\"gray\">");
        }
        if (pd != null) {
            sb.append(bundle.getMessage("property"));
            sb.append(" ");
        }
        if (enableNode) {
            sb.append("<b>");
        }
        if (pd != null) {
            sb.append(pd.getName());
        } else {
            sb.append(this.bean.getInstanceName());
        }
        if (enableNode) {
            sb.append("</b>");
        }
        sb.append(" &nbsp; <font size=\"-1\"><i>");
        sb.append(this.getTargetTypeDisplayName());
        sb.append("</i></font>");
        if (!enableNode) {
            sb.append("</font>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    public boolean isValidBindingTarget() {
        if (this.propPath == null && this.bean.getDesignContext() instanceof FacesDesignContext) {
            return ((FacesDesignContext)this.bean.getDesignContext()).isValidBindingTarget(this.bean);
        }
        return true;
    }

    public String getBindingExpressionPart() {
        if (this.propPath != null && this.propPath.length > 0) {
            return this.propPath[this.propPath.length - 1].getName();
        }
        return this.bean.getInstanceName();
    }

    public Class getTargetTypeClass() {
        if (this.propInstance == null) {
            this.propInstance = PropertyBindingHelper.getPropInstance(this.bean, this.propPath);
        }
        if (this.propInstance != null && !this.propInstance.getClass().isPrimitive()) {
            return this.propInstance.getClass();
        }
        return this.propPath != null && this.propPath.length > 0 ? this.propPath[this.propPath.length - 1].getPropertyType() : (this.bean.getInstance() != null ? this.bean.getInstance().getClass() : (this.bean.getBeanInfo() != null ? this.bean.getBeanInfo().getBeanDescriptor().getBeanClass() : null));
    }

    public boolean hasDisplayIcon() {
        if (!this.iconChecked) {
            this.displayIcon = this.getDisplayIcon(true);
            this.iconChecked = true;
        }
        return this.displayIcon != null;
    }

    public Icon getDisplayIcon(boolean enableNode) {
        if (this.displayIcon == null) {
            if (this.propInstance == null) {
                this.propInstance = PropertyBindingHelper.getPropInstance(this.bean, this.propPath);
            }
            if (this.propInstance != null) {
                try {
                    BeanInfo bi = Introspector.getBeanInfo(this.propInstance.getClass());
                    Image img = bi.getIcon(1);
                    if (img != null) {
                        this.displayIcon = new ImageIcon(img);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.displayIcon == null && (this.propPath == null || this.propPath.length == 0) && this.bean instanceof MarkupDesignBean && ((MarkupDesignBean)this.bean).getElement() != null) {
                    this.displayIcon = BindingTargetPanel.TAG_ICON;
                }
            }
        }
        if (this.displayIcon == null) {
            this.displayIcon = BindingTargetPanel.BEAN_ICON;
        }
        return this.displayIcon;
    }
}

