/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding.nodes;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.propertyeditors.binding.BindingTargetNode;
import com.sun.rave.propertyeditors.binding.BindingTargetNodeFactory;
import com.sun.rave.propertyeditors.binding.PropertyBindingHelper;
import com.sun.rave.propertyeditors.binding.nodes.PropertyTargetNode;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;

public class ResultSetTargetNodeFactory
implements BindingTargetNodeFactory {
    private static final Bundle bundle = Bundle.getBundle(ResultSetTargetNodeFactory.class);
    static /* synthetic */ Class array$Ljavax$faces$model$SelectItem;

    public boolean supportsTargetClass(Class targetClass) {
        return ResultSet.class.isAssignableFrom(targetClass);
    }

    public BindingTargetNode createTargetNode(BindingTargetNode parent, DesignBean bean, PropertyDescriptor[] propPath, Object propInstance) {
        return new ResultSetTargetNode(parent, bean, propPath, propInstance);
    }

    public static String getTypeName(int sqlType) {
        switch (sqlType) {
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -6: {
                return "TINYINT";
            }
            case -5: {
                return "BIGINT";
            }
            case -7: {
                return "BIT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 8: {
                return "DOUBLE";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case -2: {
                return "BINARY";
            }
            case 1: {
                return "CHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2006: {
                return "REF";
            }
            case 2002: {
                return "STRUCT";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -3: {
                return "VARBINARY";
            }
        }
        return null;
    }

    public static Class getJavaType(int sqlType) {
        switch (sqlType) {
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -6: {
                return Byte.class;
            }
            case -5: {
                return Long.class;
            }
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case 91: 
            case 92: {
                return Timestamp.class;
            }
            case 2: 
            case 3: {
                return Number.class;
            }
            case 7: 
            case 8: {
                return Double.class;
            }
            case 6: {
                return Float.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 70: 
            case 93: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2004: 
            case 2005: 
            case 2006: {
                return null;
            }
        }
        return null;
    }

    public class ComboDisplayColumnRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ComboDisplayColumn) {
                ComboDisplayColumn cdc = (ComboDisplayColumn)value;
                String tn = ResultSetTargetNodeFactory.getTypeName(cdc.columnType);
                StringBuffer sb = new StringBuffer();
                sb.append("<html><b>");
                sb.append(cdc.columnName);
                sb.append("</b> &nbsp; <font size=\"-1\"><i>");
                sb.append(tn);
                sb.append("</i></font></html>");
                this.setText(sb.toString());
            } else {
                this.setText(bundle.getMessage("noneBrackets"));
            }
            return this;
        }
    }

    public class ComboDisplayColumn {
        public String columnName;
        public int columnType;

        public ComboDisplayColumn(String columnName, int columnType) {
            this.columnName = columnName;
            this.columnType = columnType;
        }
    }

    public class ResultSetTargetNode
    extends PropertyTargetNode {
        protected ResultSet resultSet;

        public ResultSetTargetNode(BindingTargetNode parent, DesignBean bean, PropertyDescriptor[] propPath, Object propInstance) {
            super(parent, bean, propPath, propInstance);
            if (propInstance == null) {
                propInstance = PropertyBindingHelper.getPropInstance(bean, propPath);
            }
            if (propInstance instanceof ResultSet) {
                this.resultSet = (ResultSet)propInstance;
            }
        }

        public void lazyLoadCustomTargetNodes() {
            if (this.resultSet != null) {
                Thread resuleSetNodeThread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            final ResultSetMetaData rsmd = ResultSetTargetNode.this.resultSet.getMetaData();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    try {
                                        int cols = rsmd.getColumnCount();
                                        if (cols > 0) {
                                            for (int i = 0; i < cols; ++i) {
                                                ResultSetTargetNode.super.add(new ColumnNode(ResultSetTargetNode.this, rsmd.getColumnName(i + 1), rsmd.getColumnType(i + 1)));
                                            }
                                        }
                                        ResultSetTargetNode.super.add(new SelectItemsNode(ResultSetTargetNode.this, rsmd));
                                    }
                                    catch (Exception exc) {
                                        ErrorManager.getDefault().notify((Throwable)exc);
                                    }
                                }
                            });
                        }
                        catch (Exception exc) {
                            ErrorManager.getDefault().notify((Throwable)exc);
                        }
                    }
                });
                resuleSetNodeThread.setPriority(1);
                resuleSetNodeThread.start();
            }
        }

        public class SelectItemsNode
        extends BindingTargetNode {
            protected ResultSetMetaData metaData;
            protected String displayTextEnabled;
            protected String displayTextDisabled;
            JPanel pickerPanel;
            JLabel valueLabel;
            JLabel labelLabel;
            JLabel descrLabel;
            JComboBox valueCombo;
            JComboBox labelCombo;
            JComboBox descrCombo;
            ActionListener updateCallback;
            ActionListener updateAdapter;

            public SelectItemsNode(BindingTargetNode parent, ResultSetMetaData metaData) {
                super(parent);
                this.displayTextEnabled = null;
                this.displayTextDisabled = null;
                this.pickerPanel = new JPanel();
                this.valueLabel = new JLabel(bundle.getMessage("valueField"));
                this.labelLabel = new JLabel(bundle.getMessage("displayField"));
                this.descrLabel = new JLabel(bundle.getMessage("tooltipField"));
                this.valueCombo = new JComboBox();
                this.labelCombo = new JComboBox();
                this.descrCombo = new JComboBox();
                this.updateCallback = null;
                this.updateAdapter = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (SelectItemsNode.this.updateCallback != null) {
                            SelectItemsNode.this.updateCallback.actionPerformed(e);
                        }
                    }
                };
                this.metaData = metaData;
                this.initCustomPanel();
                this.displayTextEnabled = this.getDisplayText(true);
                this.displayTextDisabled = this.getDisplayText(false);
            }

            public String getDisplayText(boolean enableNode) {
                if (enableNode && this.displayTextEnabled != null) {
                    return this.displayTextEnabled;
                }
                if (!enableNode && this.displayTextDisabled != null) {
                    return this.displayTextDisabled;
                }
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                if (!enableNode) {
                    sb.append("<font color=\"gray\">");
                }
                if (enableNode) {
                    sb.append("<b>");
                }
                sb.append(bundle.getMessage("selectItems"));
                if (enableNode) {
                    sb.append("</b>");
                }
                sb.append(" &nbsp; <font size=\"-1\"><i>");
                sb.append(bundle.getMessage("parenItemsForListBoxOr"));
                sb.append("</i></font>");
                if (!enableNode) {
                    sb.append("</font>");
                }
                sb.append("</html>");
                return sb.toString();
            }

            public int getChildCount() {
                return 0;
            }

            public boolean lazyLoad() {
                return true;
            }

            public Class getTargetTypeClass() {
                return array$Ljavax$faces$model$SelectItem == null ? (array$Ljavax$faces$model$SelectItem = ResultSetTargetNodeFactory.class$("[Ljavax.faces.model.SelectItem;")) : array$Ljavax$faces$model$SelectItem;
            }

            public boolean isValidBindingTarget() {
                return true;
            }

            public String getBindingExpressionPart() {
                return "selectItems['" + this.getColumnPicks() + "']";
            }

            String getColumnPicks() {
                StringBuffer sb = new StringBuffer();
                Object o = this.valueCombo.getSelectedItem();
                if (o instanceof ComboDisplayColumn) {
                    sb.append(((ComboDisplayColumn)o).columnName);
                }
                if ((o = this.labelCombo.getSelectedItem()) instanceof ComboDisplayColumn) {
                    sb.append(",");
                    sb.append(((ComboDisplayColumn)o).columnName);
                }
                if ((o = this.descrCombo.getSelectedItem()) instanceof ComboDisplayColumn) {
                    sb.append(",");
                    sb.append(((ComboDisplayColumn)o).columnName);
                }
                return sb.toString();
            }

            void initCustomPanel() {
                ComboDisplayColumnRenderer cdcr = new ComboDisplayColumnRenderer();
                this.valueCombo.setRenderer(cdcr);
                this.labelCombo.setRenderer(cdcr);
                this.descrCombo.setRenderer(cdcr);
                this.labelCombo.addItem(bundle.getMessage("noneBrackets"));
                this.descrCombo.addItem(bundle.getMessage("noneBrackets"));
                try {
                    int cols = this.metaData.getColumnCount();
                    if (cols > 0) {
                        for (int i = 0; i < cols; ++i) {
                            ComboDisplayColumn col = new ComboDisplayColumn(this.metaData.getColumnName(i + 1), this.metaData.getColumnType(i + 1));
                            this.valueCombo.addItem(col);
                            this.labelCombo.addItem(col);
                            this.descrCombo.addItem(col);
                        }
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                this.pickerPanel.setLayout(new GridBagLayout());
                this.pickerPanel.add((Component)this.valueLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 4), 0, 0));
                this.pickerPanel.add((Component)this.labelLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 4), 0, 0));
                this.pickerPanel.add((Component)this.descrLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
                this.pickerPanel.add((Component)this.valueCombo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 4), 0, 0));
                this.pickerPanel.add((Component)this.labelCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 4), 0, 0));
                this.pickerPanel.add((Component)this.descrCombo, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.valueCombo.addActionListener(this.updateAdapter);
                this.labelCombo.addActionListener(this.updateAdapter);
                this.descrCombo.addActionListener(this.updateAdapter);
            }

            public JComponent getCustomDisplayPanel(ActionListener updateCallback) {
                this.updateCallback = updateCallback;
                return this.pickerPanel;
            }
        }

        public class ColumnNode
        extends BindingTargetNode {
            protected String columnName;
            protected int columnType;

            public ColumnNode(BindingTargetNode parent, String columnName, int columnType) {
                super(parent);
                this.columnName = columnName;
                this.columnType = columnType;
            }

            public int getChildCount() {
                return 0;
            }

            public boolean lazyLoad() {
                return true;
            }

            public boolean isValidBindingTarget() {
                return true;
            }

            public String getBindingExpressionPart() {
                return "currentRow['" + this.columnName + "']";
            }

            public Class getTargetTypeClass() {
                return ResultSetTargetNodeFactory.getJavaType(this.columnType);
            }

            public String getDisplayText(boolean enableNode) {
                String tn = ResultSetTargetNodeFactory.getTypeName(this.columnType);
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                if (!enableNode) {
                    sb.append("<font color=\"gray\">");
                }
                sb.append(bundle.getMessage("column"));
                sb.append(" ");
                if (enableNode) {
                    sb.append("<b>");
                }
                sb.append(this.columnName);
                if (enableNode) {
                    sb.append("</b>");
                }
                sb.append(" &nbsp; <font size=\"-1\"><i>");
                sb.append(tn);
                sb.append("</i></font>");
                if (!enableNode) {
                    sb.append("</font>");
                }
                sb.append("</html>");
                return sb.toString();
            }
        }
    }
}

