/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.domains;

import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.propertyeditors.domains.AttachedDomain;
import com.sun.rave.propertyeditors.domains.Element;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;

public abstract class EditableDomain
extends AttachedDomain {
    protected static int DESIGN_CONTEXT_STORAGE = 0;
    protected static int PROJECT_STORAGE = 1;
    protected static int IDE_STORAGE = 2;
    private int storageScope;
    private Class elementValueClass;
    protected ArrayList elements;
    private StorageProxy storageProxy;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Date;

    protected EditableDomain(int storageScope) {
        this(storageScope, String.class);
    }

    protected EditableDomain(int storageScope, Class elementValueClass) {
        this.elementValueClass = elementValueClass;
        this.storageScope = storageScope == DESIGN_CONTEXT_STORAGE || storageScope == PROJECT_STORAGE || storageScope == IDE_STORAGE ? storageScope : DESIGN_CONTEXT_STORAGE;
        this.elements = new ArrayList();
    }

    public Class getElementValueClass() {
        return this.elementValueClass;
    }

    public Element[] getElements() {
        return this.elements.toArray(Element.EMPTY_ARRAY);
    }

    public Element getElementAt(int index) {
        if (index < 0 || index > this.elements.size()) {
            return null;
        }
        return (Element)this.elements.get(index);
    }

    public int getSize() {
        return this.elements.size();
    }

    public Element setElementAt(int index, Element element) {
        Element previousElement = this.elements.set(index, element);
        this.refreshStorageProxy();
        return previousElement;
    }

    public void addElementAt(int index, Element element) {
        this.elements.add(index, element);
        this.refreshStorageProxy();
    }

    public void addElement(Element element) {
        this.elements.add(element);
        this.refreshStorageProxy();
    }

    public Element removeElementAt(int index) {
        Element previousElement = (Element)this.elements.remove(index);
        this.refreshStorageProxy();
        return previousElement;
    }

    public void setDesignProperty(DesignProperty designProperty) {
        super.setDesignProperty(designProperty);
        DesignContext context = designProperty.getDesignBean().getDesignContext();
        Object proxyObject = null;
        proxyObject = this.storageScope == DESIGN_CONTEXT_STORAGE ? context.getContextData(this.getClass().getName()) : (this.storageScope == PROJECT_STORAGE ? context.getProject().getProjectData(this.getClass().getName()) : context.getProject().getGlobalData(this.getClass().getName()));
        if (proxyObject == null || proxyObject instanceof String && ((String)proxyObject).length() == 0) {
            return;
        }
        if (proxyObject instanceof StorageProxy) {
            this.elements = ((StorageProxy)proxyObject).getElements();
        } else if (proxyObject instanceof String) {
            this.storageProxy = StorageProxy.restoreInstance((String)proxyObject, this.elementValueClass);
            this.elements = this.storageProxy.getElements();
            this.refreshStorageProxy();
        }
    }

    void refreshStorageProxy() {
        DesignContext context = this.designProperty.getDesignBean().getDesignContext();
        if (this.storageProxy == null) {
            this.storageProxy = StorageProxy.newInstance(this.elements, this.elementValueClass);
        }
        if (this.storageScope == DESIGN_CONTEXT_STORAGE) {
            context.setContextData(this.getClass().getName(), (Object)this.storageProxy);
        } else if (this.storageScope == PROJECT_STORAGE) {
            context.getProject().setProjectData(this.getClass().getName(), (Object)this.storageProxy.toString());
        } else {
            context.getProject().setGlobalData(this.getClass().getName(), (Object)this.storageProxy.toString());
        }
    }

    static void appendEncoded(StringBuffer buffer, String str) {
        char[] chars = str.toCharArray();
        for (int j = 0; j < chars.length; ++j) {
            if (chars[j] == '=') {
                buffer.append("%3D");
                continue;
            }
            if (chars[j] == ',') {
                buffer.append("%2C");
                continue;
            }
            if (chars[j] == '%') {
                buffer.append("%25");
                continue;
            }
            buffer.append(chars[j]);
        }
    }

    static String decode(String str) {
        return str.replaceAll("%3D", "=").replaceAll("%2C", ",").replaceAll("%25", "%");
    }

    static class DateStorageProxy
    extends StorageProxy {
        DateFormat format = DateFormat.getDateTimeInstance();

        DateStorageProxy() {
        }

        protected String valueToString(Object value) {
            return this.format.format((Date)value);
        }

        protected Object stringToValue(String str) {
            try {
                return this.format.parse(str);
            }
            catch (ParseException e) {
                return null;
            }
        }
    }

    static class IntegerStorageProxy
    extends StorageProxy {
        IntegerStorageProxy() {
        }

        protected String valueToString(Object value) {
            return value.toString();
        }

        protected Object stringToValue(String str) {
            return new Integer(Integer.parseInt(str));
        }
    }

    static class StringStorageProxy
    extends StorageProxy {
        StringStorageProxy() {
        }

        protected String valueToString(Object value) {
            return value.toString();
        }

        protected Object stringToValue(String str) {
            return str;
        }
    }

    static abstract class StorageProxy {
        protected ArrayList elementList;

        private StorageProxy() {
        }

        public ArrayList getElements() {
            return this.elementList;
        }

        public static StorageProxy newInstance(ArrayList elementList, Class valueClass) {
            StorageProxy proxy;
            if (valueClass == (class$java$lang$String == null ? (class$java$lang$String = EditableDomain.class$("java.lang.String")) : class$java$lang$String)) {
                proxy = new StringStorageProxy();
            } else if (valueClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = EditableDomain.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                proxy = new IntegerStorageProxy();
            } else if (valueClass == (class$java$util$Date == null ? (class$java$util$Date = EditableDomain.class$("java.util.Date")) : class$java$util$Date)) {
                proxy = new DateStorageProxy();
            } else {
                return null;
            }
            proxy.elementList = elementList;
            return proxy;
        }

        public static StorageProxy restoreInstance(String str, Class valueClass) {
            StorageProxy proxy;
            if (valueClass == (class$java$lang$String == null ? (class$java$lang$String = EditableDomain.class$("java.lang.String")) : class$java$lang$String)) {
                proxy = new StringStorageProxy();
            } else if (valueClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = EditableDomain.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                proxy = new IntegerStorageProxy();
            } else if (valueClass == (class$java$util$Date == null ? (class$java$util$Date = EditableDomain.class$("java.util.Date")) : class$java$util$Date)) {
                proxy = new DateStorageProxy();
            } else {
                return null;
            }
            proxy.fromString(str);
            return proxy;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this.elementList.size(); ++i) {
                Element e = (Element)this.elementList.get(i);
                EditableDomain.appendEncoded(buffer, e.getLabel());
                buffer.append('=');
                EditableDomain.appendEncoded(buffer, this.valueToString(e.getValue()));
                buffer.append(',');
            }
            buffer.setLength(buffer.length() - 1);
            return buffer.toString();
        }

        public void fromString(String str) {
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            ArrayList<Element> elements = new ArrayList<Element>();
            DateFormat format = DateFormat.getDateTimeInstance();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int i = token.indexOf(61);
                String label = EditableDomain.decode(token.substring(0, i));
                Object value = this.stringToValue(EditableDomain.decode(token.substring(i + 1)));
                elements.add(new Element(value, label));
            }
            this.elementList = elements;
        }

        protected abstract String valueToString(Object var1);

        protected abstract Object stringToValue(String var1);
    }
}

