/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.domains;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignProject;
import com.sun.rave.propertyeditors.domains.AttachedDomain;
import com.sun.rave.propertyeditors.domains.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class InstanceVariableDomain
extends AttachedDomain {
    public static final String INSTANCE_VARIABLE_SUBTYPE = "com.sun.rave.propertyeditors.domains.INSTANCE_VARIABLE_DOMAIN_SUBTYPE";
    protected static final String SCOPE_REQUEST = "request";
    protected static final String SCOPE_SESSION = "session";
    protected static final String SCOPE_APPLICATION = "application";
    private static HashMap arrayTypeKeyHash = new HashMap();

    private DesignContext[] getDesignContexts(DesignBean designBean) {
        DesignProject designProject = designBean.getDesignContext().getProject();
        DesignContext[] contexts = designProject instanceof FacesDesignProject ? ((FacesDesignProject)designProject).findDesignContexts(new String[]{SCOPE_REQUEST, SCOPE_SESSION, SCOPE_APPLICATION}) : new DesignContext[]{};
        DesignContext[] designContexts = new DesignContext[contexts.length + 1];
        designContexts[0] = designBean.getDesignContext();
        System.arraycopy(contexts, 0, designContexts, 1, contexts.length);
        return designContexts;
    }

    public Element[] getElements() {
        DesignProperty designProperty = this.getDesignProperty();
        if (designProperty == null) {
            return Element.EMPTY_ARRAY;
        }
        Class<?> propertyType = designProperty.getPropertyDescriptor().getPropertyType();
        FacesDesignProject facesDesignProject = (FacesDesignProject)designProperty.getDesignBean().getDesignContext().getProject();
        Object subPropertyType = designProperty.getPropertyDescriptor().getValue(INSTANCE_VARIABLE_SUBTYPE);
        if (subPropertyType instanceof Class && propertyType.isAssignableFrom((Class)subPropertyType)) {
            propertyType = (Class<?>)subPropertyType;
        } else if (subPropertyType instanceof String) {
            try {
                Class<?> subPropertyClass = Class.forName((String)subPropertyType, false, facesDesignProject.getContextClassLoader());
                if (propertyType.isAssignableFrom(subPropertyClass)) {
                    propertyType = subPropertyClass;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DesignContext thisContext = designProperty.getDesignBean().getDesignContext();
        DesignContext[] scanContexts = this.getScanContexts(thisContext, this.getDesignContexts(designProperty.getDesignBean()));
        TreeSet<String> nameSet = new TreeSet<String>();
        HashMap<String, Element> elementMap = new HashMap<String, Element>();
        for (int c = 0; c < scanContexts.length; ++c) {
            DesignContext context = scanContexts[c];
            DesignBean[] beans = context.getBeansOfType(propertyType);
            for (int i = 0; i < beans.length; ++i) {
                Element element;
                String name;
                Object instance = beans[i].getInstance();
                if (!propertyType.isAssignableFrom(instance.getClass())) continue;
                if (context == thisContext) {
                    name = beans[i].getInstanceName();
                    element = new Element(beans[i].getInstance(), name);
                } else {
                    name = beans[i].getInstanceName() + " (" + context.getDisplayName() + ")";
                    String initString = this.getInitString(context, beans[i], propertyType);
                    element = new InstanceElement(beans[i].getInstance(), name, initString);
                }
                nameSet.add(name);
                elementMap.put(name, element);
            }
        }
        if (nameSet.size() == 0) {
            return Element.EMPTY_ARRAY;
        }
        Element[] elements = new Element[nameSet.size()];
        Iterator names = nameSet.iterator();
        int n = 0;
        while (names.hasNext()) {
            String name = (String)names.next();
            elements[n++] = (Element)elementMap.get(name);
        }
        return elements;
    }

    protected DesignContext[] getScanContexts(DesignContext thisContext, DesignContext[] allContexts) {
        ArrayList<DesignContext> scanContexts = new ArrayList<DesignContext>();
        scanContexts.add(thisContext);
        Object thisScope = thisContext.getContextData("scope");
        for (int i = 0; i < allContexts.length; ++i) {
            DesignContext context = allContexts[i];
            if (context == thisContext) continue;
            Object scope = context.getContextData("scope");
            if (SCOPE_REQUEST.equals(scope) && SCOPE_REQUEST.equals(thisScope)) {
                Object baseClass = context.getContextData("baseClass");
                if (!(baseClass instanceof Class) || !"com.sun.rave.web.ui.appbase.AbstractRequestBean".equals(((Class)baseClass).getName())) continue;
                scanContexts.add(context);
                continue;
            }
            if (SCOPE_SESSION.equals(scope) && (SCOPE_REQUEST.equals(thisScope) || SCOPE_SESSION.equals(thisScope))) {
                scanContexts.add(context);
                continue;
            }
            if (!SCOPE_APPLICATION.equals(scope) || !SCOPE_REQUEST.equals(thisScope) && !SCOPE_SESSION.equals(thisScope) && !SCOPE_APPLICATION.equals(thisScope)) continue;
            scanContexts.add(context);
        }
        return scanContexts.toArray(new DesignContext[scanContexts.size()]);
    }

    protected String getInitString(DesignContext context, DesignBean bean, Class propType) {
        String typeName = InstanceVariableDomain.getJavaTypeName(propType.getName());
        return "(" + typeName + ")getValue(\"#{" + context.getDisplayName() + "." + bean.getInstanceName() + "}\")";
    }

    private static String getJavaTypeName(String tn) {
        if (tn.startsWith("[")) {
            int depth = 0;
            while (tn.startsWith("[")) {
                tn = tn.substring(1);
                ++depth;
            }
            if (tn.startsWith("L")) {
                tn = tn.substring(1);
                tn = tn.substring(0, tn.length() - 1);
            } else {
                char typeKey = tn.charAt(0);
                tn = (String)arrayTypeKeyHash.get("" + typeKey);
            }
            for (int i = 0; i < depth; ++i) {
                tn = tn + "[]";
            }
        }
        return tn;
    }

    static {
        arrayTypeKeyHash.put("B", "byte");
        arrayTypeKeyHash.put("C", "char");
        arrayTypeKeyHash.put("D", "double");
        arrayTypeKeyHash.put("F", "float");
        arrayTypeKeyHash.put("I", "int");
        arrayTypeKeyHash.put("J", "long");
        arrayTypeKeyHash.put("S", "short");
        arrayTypeKeyHash.put("Z", "boolean");
        arrayTypeKeyHash.put("V", "void");
    }

    public static class InstanceElement
    extends Element {
        protected String javaInitString;

        public InstanceElement(Object value, String label, String javaInitString) {
            super(value, label);
            this.javaInitString = javaInitString;
        }

        public String getJavaInitializationString() {
            return this.javaInitString;
        }
    }
}

