/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Arch
extends Task
implements ErrorHandler {
    private Map answers;
    private Map questions;
    private File questionsFile;
    private File output;
    private String stylesheet = null;
    private String overviewlink = null;
    private String footer = null;
    private File xsl = null;

    public void setAnswers(File f) {
        this.questionsFile = f;
    }

    public void setOutput(File f) {
        this.output = f;
    }

    public void setStylesheet(String s) {
        this.stylesheet = s;
    }

    public void setOverviewlink(String s) {
        this.overviewlink = s;
    }

    public void setFooter(String s) {
        this.footer = s;
    }

    public void setXSL(File xsl) {
        this.xsl = xsl;
    }

    public void execute() throws BuildException {
        TreeSet s;
        Document q;
        boolean generateTemplate;
        if (this.questionsFile == null) {
            throw new BuildException("questions file must be provided");
        }
        if (this.output == null) {
            throw new BuildException("output file must be specified");
        }
        boolean bl = generateTemplate = !this.questionsFile.exists();
        if (!generateTemplate && this.output.exists() && this.questionsFile.lastModified() <= this.output.lastModified() && this.getProject().getProperty("arch.generate") == null) {
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(this);
            q = generateTemplate ? builder.parse(this.getClass().getResourceAsStream("Arch-api-questions.xml")) : builder.parse(this.questionsFile);
        }
        catch (SAXParseException ex) {
            this.log(ex.getSystemId() + ":" + ex.getLineNumber() + ": " + ex.getLocalizedMessage(), 0);
            throw new BuildException(this.questionsFile.getAbsolutePath() + " is malformed or invalid", (Throwable)ex, this.location);
        }
        catch (Exception ex) {
            throw new BuildException("File " + this.questionsFile + " cannot be parsed: " + ex.getLocalizedMessage(), (Throwable)ex, this.location);
        }
        this.questions = Arch.readElements(q, "question");
        NodeList apiQuestions = q.getElementsByTagName("api-questions");
        if (apiQuestions.getLength() != 1) {
            throw new BuildException("No element api-questions");
        }
        String questionsVersion = ((Element)apiQuestions.item(0)).getAttribute("version");
        if (questionsVersion == null) {
            throw new BuildException("Element api-questions does not have attribute version");
        }
        if (this.questions.size() == 0) {
            throw new BuildException("There are no <question> elements in the file!");
        }
        if (generateTemplate) {
            this.log("Input file " + this.questionsFile + " does not exists. Generating it filled with skeleton answers.");
            try {
                s = new TreeSet(this.questions.keySet());
                this.generateTemplateFile(questionsVersion, s);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
            return;
        }
        this.answers = Arch.readElements(q, "answer");
        NodeList apiAnswers = q.getElementsByTagName("api-answers");
        if (apiAnswers.getLength() != 1) {
            throw new BuildException("No element api-answers");
        }
        String answersVersion = ((Element)apiAnswers.item(0)).getAttribute("question-version");
        if (answersVersion == null) {
            throw new BuildException("Element api-answers does not have attribute question-version");
        }
        if (!answersVersion.equals(questionsVersion)) {
            String msg = this.questionsFile.getAbsolutePath() + ": answers were created for questions version \"" + answersVersion + "\" but current version of questions is \"" + questionsVersion + "\"";
            if ("true".equals(this.getProject().getProperty("arch.warn"))) {
                this.log(msg, 1);
            } else {
                throw new BuildException(msg);
            }
        }
        s = new TreeSet(this.questions.keySet());
        s.removeAll(this.answers.keySet());
        if (!s.isEmpty()) {
            if ("true".equals(this.getProject().getProperty("arch.generate"))) {
                this.log("Missing answers to questions: " + s);
                this.log("Generating the answers to end of file " + this.questionsFile);
                try {
                    this.generateMissingQuestions(s);
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            } else {
                this.log(this.questionsFile.getAbsolutePath() + ": some questions have not been answered: " + s + "\n" + "Run with -Darch.generate=true to add missing questions into the end of question file", 1);
            }
        }
        try {
            String archPref;
            StreamSource ss;
            String file;
            String string = file = this.xsl != null ? this.xsl.toString() : this.getProject().getProperty("arch.xsl");
            if (file != null) {
                this.log("Using " + file + " as the XSL stylesheet");
                try {
                    ss = new StreamSource(new FileInputStream(file));
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            } else {
                ss = new StreamSource(this.getClass().getResourceAsStream("Arch.xsl"));
            }
            this.log("Transforming " + this.questionsFile + " into " + this.output);
            Transformer t = TransformerFactory.newInstance().newTransformer(ss);
            DOMSource s2 = new DOMSource(q);
            StreamResult r = new StreamResult(this.output);
            if (this.stylesheet != null) {
                t.setParameter("arch.stylesheet", this.stylesheet);
            }
            if (this.overviewlink != null) {
                t.setParameter("arch.overviewlink", this.overviewlink);
            }
            if (this.footer != null) {
                t.setParameter("arch.footer", this.footer);
            }
            t.setParameter("arch.answers.date", DateFormat.getDateInstance().format(new Date(this.questionsFile.lastModified())));
            String archTarget = this.output.toString();
            int slash = archTarget.lastIndexOf(File.separatorChar);
            if (slash > 0) {
                archTarget = archTarget.substring(slash + 1);
            }
            if ((archPref = this.getProject().getProperty("arch.target")) != null) {
                archTarget = archPref + File.separatorChar + archTarget;
            }
            t.setParameter("arch.target", archTarget);
            t.setParameter("arch.when", this.getProject().getProperty("arch.when"));
            t.transform(s2, r);
        }
        catch (TransformerConfigurationException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (TransformerException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void generateMissingQuestions(Set missing) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(this.questionsFile.toString(), true));
        w.write("<!-- Copy this above the </api-answers> tag! -->\n\n");
        this.writeQuestions(w, missing);
        ((Writer)w).close();
    }

    private void writeQuestions(Writer w, Set missing) throws IOException {
        Iterator it = missing.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            Element n = (Element)this.questions.get(s);
            w.write("\n\n<!--\n        ");
            w.write(Arch.elementToString(n));
            w.write("\n-->\n");
            w.write("<answer id=\"" + s + "\">\nNo answer\n</answer>\n\n");
        }
    }

    private static String findNbRoot(File f) {
        StringBuffer result = new StringBuffer();
        for (f = f.getParentFile(); f != null; f = f.getParentFile()) {
            File x = new File(f, "nbbuild" + File.separatorChar + "antsrc" + File.separatorChar + "org" + File.separatorChar + "netbeans" + File.separatorChar + "nbbuild" + File.separatorChar + "Arch.dtd");
            if (x.exists()) {
                return result.toString();
            }
            result.append("../");
        }
        return "${nbroot}/";
    }

    private void generateTemplateFile(String versionOfQuestions, Set missing) throws IOException {
        String nbRoot = Arch.findNbRoot(this.questionsFile).replace(File.separatorChar, '/');
        FileWriter w = new FileWriter(this.questionsFile);
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        w.write("<!DOCTYPE api-answers PUBLIC \"-//NetBeans//DTD Arch Answers//EN\" \"");
        w.write(nbRoot);
        w.write("nbbuild/antsrc/org/netbeans/nbbuild/Arch.dtd\" [\n");
        w.write("  <!ENTITY api-questions SYSTEM \"");
        w.write(nbRoot);
        w.write("nbbuild/antsrc/org/netbeans/nbbuild/Arch-api-questions.xml\">\n");
        w.write("]>\n");
        w.write("\n");
        w.write("<api-answers\n");
        w.write("  question-version=\"");
        w.write(versionOfQuestions);
        w.write("\"\n");
        w.write("  module=\"name of your module\"\n");
        w.write("  author=\"yourname@netbeans.org\"\n");
        w.write(">\n\n");
        w.write("  &api-questions;\n");
        this.writeQuestions(w, missing);
        w.write("</api-answers>\n");
        ((Writer)w).close();
    }

    private static HashMap readElements(Document q, String name) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        NodeList list = q.getElementsByTagName(name);
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i).getAttributes().getNamedItem("id");
            if (n == null) {
                throw new BuildException("Question without id tag");
            }
            String id = n.getNodeValue();
            map.put(id, list.item(i));
        }
        return map;
    }

    public void error(SAXParseException exception) throws SAXException {
        this.log(exception.getSystemId() + ":" + exception.getLineNumber() + ": " + exception.getLocalizedMessage(), 0);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (exception.getLocalizedMessage().startsWith("Using original entity definition for")) {
            return;
        }
        this.log(exception.getSystemId() + ":" + exception.getLineNumber() + ": " + exception.getLocalizedMessage(), 1);
    }

    private static String elementToString(Element e) throws IOException {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "no");
            t.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(e);
            StringWriter w = new StringWriter();
            StreamResult result = new StreamResult(w);
            t.transform(source, result);
            return w.toString();
        }
        catch (Exception x) {
            throw (IOException)new IOException(x.toString()).initCause(x);
        }
    }
}

