/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class CreateModuleXML
extends Task {
    private final List enabled = new ArrayList(1);
    private final List disabled = new ArrayList(1);
    private final List autoload = new ArrayList(1);
    private final List eager = new ArrayList(1);
    private File xmldir = null;
    private List enabledNames = new ArrayList(50);
    private List disabledNames = new ArrayList(10);
    private List autoloadNames = new ArrayList(10);
    private List eagerNames = new ArrayList(10);

    public void addEnabled(FileSet fs) {
        this.enabled.add(fs);
    }

    public void addDisabled(FileSet fs) {
        this.disabled.add(fs);
    }

    public void addAutoload(FileSet fs) {
        this.autoload.add(fs);
    }

    public void addEager(FileSet fs) {
        this.eager.add(fs);
    }

    public void setXmldir(File f) {
        this.xmldir = f;
    }

    public void execute() throws BuildException {
        if (this.xmldir == null) {
            throw new BuildException("Must set xmldir", this.location);
        }
        if (this.enabled.isEmpty() && this.disabled.isEmpty() && this.autoload.isEmpty() && this.eager.isEmpty()) {
            this.log("Warning: <createmodulexml> with no modules listed", 1);
        }
        Iterator it = this.enabled.iterator();
        while (it.hasNext()) {
            this.scanModules((FileSet)it.next(), true, false, false, "installation", this.enabledNames);
        }
        it = this.disabled.iterator();
        while (it.hasNext()) {
            this.scanModules((FileSet)it.next(), false, false, false, "installation", this.disabledNames);
        }
        it = this.autoload.iterator();
        while (it.hasNext()) {
            this.scanModules((FileSet)it.next(), false, true, false, "installation/autoload", this.autoloadNames);
        }
        it = this.eager.iterator();
        while (it.hasNext()) {
            this.scanModules((FileSet)it.next(), false, false, true, "installation/eager", this.eagerNames);
        }
        Collections.sort(this.enabledNames);
        Collections.sort(this.disabledNames);
        Collections.sort(this.autoloadNames);
        Collections.sort(this.eagerNames);
        this.log("Enabled modules: " + this.enabledNames);
        this.log("Disabled modules: " + this.disabledNames);
        this.log("Autoload modules: " + this.autoloadNames);
        this.log("Eager modules: " + this.eagerNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanModules(FileSet fs, boolean isEnabled, boolean isAutoload, boolean isEager, String origin, List names) throws BuildException {
        DirectoryScanner scan = fs.getDirectoryScanner(this.project);
        File dir = scan.getBasedir();
        String[] kids = scan.getIncludedFiles();
        for (int i = 0; i < kids.length; ++i) {
            File module = new File(dir, kids[i]);
            if (!module.exists()) {
                throw new BuildException("Does not really exist: " + module, this.location);
            }
            if (!module.getParentFile().equals(dir)) {
                throw new BuildException("JARs in subfolders not permitted: " + module, this.location);
            }
            if (!module.getName().endsWith(".jar")) {
                throw new BuildException("Only *.jar may be listed: " + module, this.location);
            }
            try {
                JarFile jar = new JarFile(module);
                try {
                    int rel;
                    String codenamebase;
                    String bundle;
                    Manifest m = jar.getManifest();
                    Attributes attr = m.getMainAttributes();
                    String codename = attr.getValue("OpenIDE-Module");
                    if (codename == null) {
                        throw new BuildException("Not a module: " + module);
                    }
                    String displayname = attr.getValue("OpenIDE-Module-Name");
                    if (displayname == null && (bundle = attr.getValue("OpenIDE-Module-Localizing-Bundle")) != null) {
                        InputStream is;
                        ZipEntry entry = jar.getEntry(bundle);
                        if (entry != null) {
                            is = jar.getInputStream(entry);
                        } else {
                            File moduleloc = new File(new File(module.getParentFile(), "locale"), module.getName());
                            if (!moduleloc.isFile()) {
                                throw new BuildException("Expecting localizing bundle: " + bundle + " in: " + module);
                            }
                            JarFile jarloc = new JarFile(moduleloc);
                            try {
                                ZipEntry entry2 = jarloc.getEntry(bundle);
                                if (entry2 == null) {
                                    throw new BuildException("Expecting localizing bundle: " + bundle + " in: " + module);
                                }
                                is = jarloc.getInputStream(entry2);
                            }
                            finally {
                                jarloc.close();
                            }
                        }
                        try {
                            Properties p = new Properties();
                            p.load(is);
                            displayname = p.getProperty("OpenIDE-Module-Name");
                        }
                        finally {
                            is.close();
                        }
                    }
                    if (displayname == null) {
                        displayname = codename;
                    }
                    names.add(displayname);
                    int idx = codename.lastIndexOf(47);
                    if (idx == -1) {
                        codenamebase = codename;
                        rel = -1;
                    } else {
                        codenamebase = codename.substring(0, idx);
                        rel = Integer.parseInt(codename.substring(idx + 1));
                    }
                    String spec = attr.getValue("OpenIDE-Module-Specification-Version");
                    File xml = new File(this.xmldir, codenamebase.replace('.', '-') + ".xml");
                    FileOutputStream os = new FileOutputStream(xml);
                    try {
                        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        pw.println("<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"");
                        pw.println("                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">");
                        pw.println("<module name=\"" + codenamebase + "\">");
                        pw.println("    <param name=\"autoload\">" + isAutoload + "</param>");
                        pw.println("    <param name=\"eager\">" + isEager + "</param>");
                        if (!isAutoload && !isEager) {
                            pw.println("    <param name=\"enabled\">" + isEnabled + "</param>");
                        }
                        pw.println("    <param name=\"jar\">" + module.getName() + "</param>");
                        pw.println("    <param name=\"origin\">" + origin + "</param>");
                        if (rel != -1) {
                            pw.println("    <param name=\"release\">" + rel + "</param>");
                        }
                        pw.println("    <param name=\"reloadable\">false</param>");
                        if (spec != null) {
                            pw.println("    <param name=\"specversion\">" + spec + "</param>");
                        }
                        pw.println("</module>");
                        pw.flush();
                        pw.close();
                        continue;
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
                finally {
                    jar.close();
                }
            }
            catch (IOException ioe) {
                throw new BuildException("Caught while processing " + module + ": " + ioe, (Throwable)ioe, this.location);
            }
        }
    }
}

