/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class CvsFileSet
extends FileSet {
    private String mode = "controlled";
    private static final Set[] NO_ENTRIES = new Set[]{Collections.EMPTY_SET, Collections.EMPTY_SET};

    public void setMode(Mode m) {
        this.mode = m.getValue();
    }

    public DirectoryScanner getDirectoryScanner(Project proj) throws BuildException {
        CvsDirectoryScanner scan = new CvsDirectoryScanner();
        this.setupDirectoryScanner((FileScanner)scan, proj);
        scan.scan();
        return scan;
    }

    private class CvsDirectoryScanner
    extends DirectoryScanner {
        private final Map entries = new HashMap(100);

        private CvsDirectoryScanner() {
        }

        protected boolean isIncluded(String name) throws BuildException {
            if (!super.isIncluded(name)) {
                return false;
            }
            File f = new File(this.getBasedir(), name);
            if (!f.exists()) {
                throw new IllegalStateException();
            }
            if (!f.isFile()) {
                return false;
            }
            Set[] entries = this.loadEntries(f.getParentFile());
            Set text = entries[0];
            Set binary = entries[1];
            String bname = f.getName();
            if (CvsFileSet.this.mode.equals("controlled")) {
                return text.contains(bname) || binary.contains(bname);
            }
            if (CvsFileSet.this.mode.equals("uncontrolled")) {
                return !text.contains(bname) && !binary.contains(bname);
            }
            if (CvsFileSet.this.mode.equals("text")) {
                return text.contains(bname);
            }
            if (CvsFileSet.this.mode.equals("binary")) {
                return binary.contains(bname);
            }
            throw new IllegalStateException(CvsFileSet.this.mode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set[] loadEntries(File dir) throws BuildException {
            Set[] tb = (Set[])this.entries.get(dir);
            if (tb == null) {
                block10: {
                    File efile = new File(new File(dir, "CVS"), "Entries");
                    if (efile.exists()) {
                        tb = new Set[]{new HashSet(10), new HashSet(10)};
                        try {
                            FileReader r = new FileReader(efile);
                            try {
                                String line;
                                BufferedReader buf = new BufferedReader(r);
                                while ((line = buf.readLine()) != null) {
                                    if (!line.startsWith("/")) continue;
                                    line = line.substring(1);
                                    int idx = line.indexOf(47);
                                    String name = line.substring(0, idx);
                                    idx = line.lastIndexOf(47);
                                    String subst = (line = line.substring(0, idx)).substring((idx = line.lastIndexOf(47)) + 1);
                                    if (subst.equals("")) {
                                        tb[0].add(name);
                                        continue;
                                    }
                                    if (subst.equals("-kb")) {
                                        tb[1].add(name);
                                        continue;
                                    }
                                    throw new BuildException("Strange key subst mode in " + efile + ": " + subst);
                                }
                                break block10;
                            }
                            finally {
                                ((Reader)r).close();
                            }
                        }
                        catch (IOException ioe) {
                            throw new BuildException("While reading " + efile, (Throwable)ioe);
                        }
                    }
                    tb = NO_ENTRIES;
                }
                this.entries.put(dir, tb);
            }
            return tb;
        }

        protected boolean couldHoldIncluded(String name) {
            if (!super.couldHoldIncluded(name)) {
                return false;
            }
            return !name.endsWith(File.separatorChar + "CVS");
        }
    }

    public static final class Mode
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"controlled", "uncontrolled", "text", "binary"};
        }
    }
}

