/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.SourceFileScanner;
import org.netbeans.nbbuild.L10nTask;

public class GetL9eFiles
extends Task {
    protected String listFile = "l10n.list";
    protected String baseDir = "..";
    protected File grandParent = null;
    protected File targetDir = null;
    protected String excludes = "**/ja/,**/*_ja.*";
    protected FileUtils fileUtils = null;
    static /* synthetic */ Class class$org$netbeans$nbbuild$L10nTask;

    public void setBaseDir(String s) {
        this.baseDir = s;
        File f = new File(this.antBaseDir() + this.baseDir);
        try {
            this.grandParent = new File(f.getCanonicalPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException();
        }
    }

    public void setListFile(String s) {
        this.listFile = s;
    }

    public void setTargetDir(File f) {
        this.targetDir = f;
    }

    public void setExcludes(String s) {
        this.excludes = s;
    }

    public void execute() throws BuildException {
        if (this.targetDir == null) {
            this.targetDir = new File(this.antBaseDir() + "src-todo");
        }
        if (this.grandParent == null) {
            this.setBaseDir(this.baseDir);
        }
        LinkedList modules = this.getModulesWithListFiles();
        ListIterator iter = modules.listIterator();
        while (iter.hasNext()) {
            File module = (File)iter.next();
            this.copyL9eFiles(module);
        }
    }

    protected void copyL9eFiles(File module) {
        String[] changedFiles;
        if (this.fileUtils == null) {
            this.fileUtils = FileUtils.newFileUtils();
        }
        this.project.addTaskDefinition("l10nTask", class$org$netbeans$nbbuild$L10nTask == null ? (class$org$netbeans$nbbuild$L10nTask = GetL9eFiles.class$("org.netbeans.nbbuild.L10nTask")) : class$org$netbeans$nbbuild$L10nTask);
        L10nTask l10nTask = (L10nTask)this.project.createTask("l10nTask");
        l10nTask.init();
        l10nTask.setLocalizableFile(this.listFile);
        l10nTask.setExcludePattern(this.excludes);
        String[] l9eFiles = l10nTask.getLocalizableFiles(this.grandParent, module.getName());
        if (l9eFiles != null && (changedFiles = this.getChangedFiles(l9eFiles)) != null && changedFiles.length > 0) {
            this.log("Copying " + changedFiles.length + " files to " + this.targetDir.getPath());
            for (int i = 0; i < changedFiles.length; ++i) {
                File fromFile = new File(changedFiles[i]);
                File toFile = new File(GetL9eFiles.mapL9eFile(changedFiles[i], this.targetDir.getPath(), this.grandParent.getPath()));
                try {
                    this.fileUtils.copyFile(fromFile, toFile);
                    continue;
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + fromFile.getPath() + " to " + toFile.getPath() + " due to " + ioe.getMessage();
                    throw new BuildException(msg, (Throwable)ioe, this.location);
                }
            }
        }
    }

    protected String[] getChangedFiles(String[] files) {
        L9eMapper mapper = new L9eMapper();
        mapper.setFrom(this.grandParent.getPath());
        mapper.setTo(this.targetDir.getPath());
        SourceFileScanner ds = new SourceFileScanner((Task)this);
        return ds.restrict(files, null, null, (FileNameMapper)mapper);
    }

    protected static String mapL9eFile(String file, String toDir, String grandParentName) {
        return toDir + file.substring(grandParentName.length());
    }

    protected LinkedList getModulesWithListFiles() {
        LinkedList<File> modules = new LinkedList<File>();
        File[] parents = this.grandParent.listFiles(new DirectoryFilter());
        for (int i = 0; i < parents.length; ++i) {
            File module = parents[i];
            File list = new File(module.getPath() + File.separator + this.listFile);
            if (!list.exists()) continue;
            modules.add(module);
        }
        return modules;
    }

    protected String antBaseDir() {
        return this.getProject().getBaseDir().getAbsolutePath() + File.separator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class L9eMapper
    implements FileNameMapper {
        protected String m_grandParent;
        protected String m_toDir;

        protected L9eMapper() {
        }

        public void setFrom(String from) {
            this.m_grandParent = from;
        }

        public void setTo(String to) {
            this.m_toDir = to;
        }

        public String[] mapFileName(String file) {
            return new String[]{GetL9eFiles.mapL9eFile(file, this.m_toDir, this.m_grandParent)};
        }
    }

    class TarFileFilter
    implements FileFilter {
        TarFileFilter() {
        }

        public boolean accept(File f) {
            return f.getName().endsWith(".tar");
        }
    }

    class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory();
        }
    }
}

