/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.nbbuild.Issue;
import org.netbeans.nbbuild.IssuezillaXMLHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public final class Issuezilla {
    private URL urlBase;
    private SAXParser saxParser;
    private int maxIOFailures = 15;
    private Vector proxyServer = null;
    private int lastProxy = -1;

    public Issuezilla(URL urlBase) {
        this.urlBase = urlBase;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            this.saxParser = factory.newSAXParser();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Cannot initialize parser");
        }
    }

    public void setProxyPool(String proxyPool) {
        StringTokenizer tokens = new StringTokenizer(proxyPool, ",");
        this.proxyServer = new Vector();
        while (tokens.hasMoreTokens()) {
            this.proxyServer.add(tokens.nextToken());
        }
        this.rotateProxy();
    }

    private void rotateProxy() {
        if (this.proxyServer == null) {
            return;
        }
        if (this.proxyServer.size() == 0) {
            return;
        }
        this.lastProxy = this.lastProxy + 2 > this.proxyServer.size() ? 0 : ++this.lastProxy;
        String proxyString = (String)this.proxyServer.get(this.lastProxy);
        String host = proxyString.substring(0, proxyString.indexOf(58));
        String port = proxyString.substring(proxyString.indexOf(58) + 1);
        System.out.println("Rotating http proxy server to " + host + ":" + port);
        if (!port.equals("")) {
            System.getProperties().put("http.proxyPort", port);
        }
        if (!host.equals("")) {
            System.getProperties().put("http.proxyHost", host);
        }
    }

    public Issue getBug(int number) throws SAXException, IOException {
        Issue[] arr = this.getBugs(new int[]{number});
        if (arr.length != 1) {
            throw new InvalidObjectException("Issue not read");
        }
        return arr[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Issue[] getBugs(int[] numbers) throws SAXException, IOException {
        int maxIssuesAtOnce = 10;
        Issue[] result = new Issue[numbers.length];
        int issueToProcess = 0;
        block10: while (issueToProcess < numbers.length) {
            int lastIssueRightNow = Math.min(numbers.length, issueToProcess + maxIssuesAtOnce);
            StringBuffer sb = new StringBuffer(numbers.length * 8);
            String sep = "xml.cgi?id=";
            IOException lastEx = null;
            for (int i = issueToProcess; i < lastIssueRightNow; ++i) {
                sb.append(sep);
                sb.append(numbers[i]);
                sep = ",";
            }
            sb.append("&show_attachments=false");
            for (int iterate = 0; iterate < this.maxIOFailures; ++iterate) {
                URL u = null;
                try {
                    Issue[] arr;
                    u = new URL(this.urlBase, sb.toString());
                    InputStream is = u.openStream();
                    try {
                        arr = this.getBugs(is);
                    }
                    finally {
                        is.close();
                    }
                    int i = 0;
                    while (i < arr.length) {
                        result[issueToProcess++] = arr[i++];
                    }
                    continue block10;
                }
                catch (IOException ex) {
                    Issuezilla issuezilla = this;
                    synchronized (issuezilla) {
                        try {
                            System.out.println(new Date().toString() + ": Can't get URL : " + u.toString());
                            Issuezilla.hintProxySettings();
                            this.rotateProxy();
                            this.wait(5000L);
                        }
                        catch (InterruptedException ex1) {
                            // empty catch block
                        }
                    }
                    lastEx = ex;
                    continue;
                }
            }
            throw lastEx;
        }
        return result;
    }

    private static void hintProxySettings() {
        String host = System.getProperty("http.proxyHost", "<undefined http.proxyHost>");
        String port = System.getProperty("http.proxyPort", "<default http.proxyPort>");
        System.out.println("Current proxy settings are " + host + ":" + port + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] query(String query) throws SAXException, IOException {
        String line;
        URL u = new URL(this.urlBase, "buglist.cgi?" + query);
        IOException lastEx = null;
        BufferedReader reader = null;
        for (int iterate = 0; iterate < this.maxIOFailures; ++iterate) {
            try {
                reader = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
                continue;
            }
            catch (IOException ex) {
                Issuezilla issuezilla = this;
                synchronized (issuezilla) {
                    try {
                        System.out.println(new Date().toString() + ": Can't get URL : " + u.toString());
                        Issuezilla.hintProxySettings();
                        this.rotateProxy();
                        this.wait(5000L);
                    }
                    catch (InterruptedException ex1) {
                        // empty catch block
                    }
                }
                lastEx = ex;
            }
        }
        if (reader == null) {
            if (lastEx != null) {
                throw lastEx;
            }
            throw new IOException("Can't get connection to " + u.toString() + " for " + this.maxIOFailures + "times.");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        String magic = "show_bug.cgi?id=";
        while ((line = reader.readLine()) != null) {
            int index = line.indexOf(magic);
            if (index == -1) continue;
            int end = line.indexOf(34, index += magic.length());
            if (end == -1) {
                throw new IOException("No ending \" from index " + index + " in " + line);
            }
            String number = line.substring(index, end);
            result.add(Integer.valueOf(number));
        }
        int[] arr = new int[result.size()];
        Iterator it = result.iterator();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (Integer)it.next();
        }
        return arr;
    }

    private Issue[] getBugs(InputStream in) throws SAXException, IOException {
        IssuezillaXMLHandler handler = new IssuezillaXMLHandler();
        this.saxParser.parse(in, (HandlerBase)handler);
        return this.getBugsFromHandler(handler);
    }

    private Issue[] getBugsFromHandler(IssuezillaXMLHandler handler) {
        List bugList = handler.getBugList();
        if (bugList == null) {
            return null;
        }
        Issue[] bugs = new Issue[bugList.size()];
        for (int i = 0; i < bugList.size(); ++i) {
            Issue bug = new Issue();
            Map atts = (Map)bugList.get(i);
            Iterator it = atts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                bug.setAttribute((String)entry.getKey(), entry.getValue());
            }
            bugs[i] = bug;
        }
        return bugs;
    }
}

