/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.UpToDate;

public class MakeLayer
extends MatchingTask {
    private File dest = null;
    private File topdir = null;
    private boolean absolutePath = false;

    public void setDestfile(File f) {
        this.dest = f;
    }

    public void setTopdir(File t) {
        this.topdir = t;
    }

    public void setAbsolutePath(boolean absolutePath) {
        this.absolutePath = absolutePath;
    }

    public void execute() throws BuildException {
        FileWriter layerFile;
        if (this.topdir == null) {
            throw new BuildException("You must set at topdir attribute", this.location);
        }
        if (this.dest == null) {
            throw new BuildException("You must specify output file", this.location);
        }
        UpToDate upToDate = (UpToDate)this.getProject().createTask("uptodate");
        this.fileset.setDir(this.topdir);
        upToDate.addSrcfiles(this.fileset);
        upToDate.setTargetFile(this.dest);
        upToDate.setProperty(this.dest.getAbsolutePath() + ".property");
        upToDate.execute();
        if (this.getProject().getProperty(this.dest.getAbsolutePath() + ".property") != null) {
            return;
        }
        int lengthAdjust = this.absolutePath ? 0 : 1;
        try {
            layerFile = new FileWriter(this.dest);
        }
        catch (IOException e) {
            throw new BuildException(e.fillInStackTrace(), this.location);
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.topdir);
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            File aFileName = new File(this.topdir, files[i]);
            try {
                layerFile.write(("<file name=\"" + aFileName.getName() + "\"\n").replace(File.separatorChar, '/'));
                layerFile.write(("  url=\"" + aFileName.getAbsolutePath().substring(this.topdir.getAbsolutePath().length() + lengthAdjust) + "\"/>\n").replace(File.separatorChar, '/'));
                continue;
            }
            catch (IOException ex) {
                throw new BuildException(ex.fillInStackTrace(), this.location);
            }
        }
        try {
            layerFile.close();
        }
        catch (IOException e) {
            throw new BuildException(e.fillInStackTrace(), this.location);
        }
    }
}

