/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.jar.Attributes;
import java.util.zip.CRC32;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.UpdateTracking;

public class MakeListOfNBM
extends Task {
    String targetName = null;
    File outputFile = null;

    public void setTargetname(String s) {
        this.targetName = s;
    }

    public void setOutputfiledir(File s) {
        this.outputFile = s;
    }

    public void execute() throws BuildException {
        if (this.targetName == null) {
            new BuildException("You have to specify target used to make NBMs");
        }
        if (this.outputFile == null) {
            new BuildException("You have to specify output directoty");
        }
        this.log("Generating information for Auto Update...");
        Task[] nbms = ((Target)this.getProject().getTargets().get(this.targetName)).getTasks();
        UpdateTracking track = new UpdateTracking(this.outputFile.getAbsolutePath());
        for (int i = 0; i < nbms.length; ++i) {
            Attributes attr;
            FileSet fs;
            if (!nbms[i].getClass().getName().endsWith("MakeNBM")) continue;
            nbms[i].maybeConfigure();
            try {
                Method m = nbms[i].getClass().getDeclaredMethod("getFileSet", null);
                m.setAccessible(true);
                fs = (FileSet)m.invoke((Object)nbms[i], null);
            }
            catch (Exception ex) {
                throw new BuildException("Can't get fileset of NBM", (Throwable)ex, this.location);
            }
            try {
                Method m = nbms[i].getClass().getDeclaredMethod("getAttributes", null);
                m.setAccessible(true);
                attr = (Attributes)m.invoke((Object)nbms[i], null);
            }
            catch (Exception ex) {
                throw new BuildException("Can't get manifest attributes", (Throwable)ex, this.location);
            }
            String codename = attr.getValue("OpenIDE-Module");
            if (codename == null) {
                throw new BuildException("invalid manifest, does not contain OpenIDE-Module", this.location);
            }
            String versionSpecNum = attr.getValue("OpenIDE-Module-Specification-Version");
            if (versionSpecNum == null) {
                this.log("manifest does not contain OpenIDE-Module-Specification-Version");
                return;
            }
            UpdateTracking.Version version = track.addNewModuleVersion(codename, versionSpecNum);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] include = ds.getIncludedFiles();
            for (int j = 0; j < include.length; ++j) {
                if (include[j].equals("Info" + File.separatorChar + "info.xml") || include[j].startsWith("main" + File.separatorChar) || include[j].startsWith("netbeans" + File.separatorChar + "update_tracking" + File.separatorChar)) continue;
                try {
                    File inFile = new File(ds.getBasedir(), include[j]);
                    FileInputStream inFileStream = new FileInputStream(inFile);
                    byte[] array = new byte[(int)inFile.length()];
                    CRC32 crc = new CRC32();
                    inFileStream.read(array);
                    inFileStream.close();
                    crc.update(array);
                    String abs = inFile.getAbsolutePath();
                    String prefix = ds.getBasedir().getAbsolutePath() + File.separatorChar + "netbeans" + File.separatorChar;
                    if (!abs.startsWith(prefix)) {
                        throw new IllegalStateException(abs);
                    }
                    version.addFileWithCrc(abs.substring(prefix.length()), Long.toString(crc.getValue()));
                    continue;
                }
                catch (IOException ex) {
                    this.log(ex.toString());
                }
            }
            track.write();
        }
    }
}

