/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class MakeParserDB
extends Task {
    private static final Map levels = new HashMap(5);
    private File db;
    private File sources;
    private File nbroot;
    private String fieldlevel = "public-and-protected";
    private String methodlevel = "public-and-protected";
    private String classlevel = "public-and-protected";

    public void setDB(File f) {
        this.db = f;
    }

    public void setSources(File f) {
        this.sources = f;
    }

    public void setNbroot(File f) {
        this.nbroot = f;
    }

    public void setFieldlevel(Level l) {
        this.fieldlevel = l.getValue();
    }

    public void setMethodlevel(Level l) {
        this.methodlevel = l.getValue();
    }

    public void setClasslevel(Level l) {
        this.classlevel = l.getValue();
    }

    public void execute() throws BuildException {
        if (this.db == null || this.sources == null || this.nbroot == null) {
            throw new BuildException("Need to set db, sources, and nbroot attrs", this.location);
        }
        if (!this.sources.isDirectory() || !this.nbroot.isDirectory()) {
            throw new BuildException("sources and nbroot attrs must be existing dirs", this.location);
        }
        File db2 = new File(this.db.getAbsolutePath() + ".jcb");
        if (db2.isFile() && !MakeParserDB.newer(this.sources, db2.lastModified())) {
            this.log("The parser database " + db2 + " is already up-to-date, not rebuilding from " + this.sources);
            return;
        }
        CommandlineJava j = new CommandlineJava();
        j.setClassname("org.netbeans.modules.editor.java.StandaloneJCDBCreator");
        j.createArgument().setFile(this.sources);
        j.createArgument().setFile(this.db);
        j.createArgument().setValue((String)levels.get(this.classlevel));
        j.createArgument().setValue((String)levels.get(this.fieldlevel));
        j.createArgument().setValue((String)levels.get(this.methodlevel));
        Environment.Variable v = new Environment.Variable();
        v.setKey("netbeans.security.nocheck");
        v.setValue("true");
        j.addSysproperty(v);
        File[] cp = this.getClasspath();
        Path path = j.createClasspath(this.getProject());
        for (int i = 0; i < cp.length; ++i) {
            Path.PathElement el = path.createPathElement();
            el.setLocation(cp[i]);
        }
        this.log("Parsing " + this.sources + " into " + this.db + ".jc[bs] ...");
        this.log("Running: " + j.describeCommand(), 3);
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1));
        execute.setCommandline(j.getCommandline());
        try {
            int retval = execute.execute();
            if (retval != 0) {
                throw new BuildException("parser database updater failed with status " + retval, this.getLocation());
            }
        }
        catch (IOException e) {
            throw new BuildException("Cannot run parser database updater: " + e, (Throwable)e, this.getLocation());
        }
    }

    private File[] getClasspath() {
        String[] cp = new String[]{"openide/netbeans/lib/openide.jar", "openide/loaders/netbeans/lib/openide-loaders.jar", "openide/execution/netbeans/modules/autoload/openide-execution.jar", "openide/io/netbeans/modules/autoload/openide-io.jar", "core/netbeans/lib/ext/boot.jar", "core/netbeans/lib/core.jar", "classfile/netbeans/modules/autoload/classfile.jar", "java/api/netbeans/modules/autoload/java-api.jar", "java/srcmodel/netbeans/modules/autoload/java-src-model.jar", "java/netbeans/modules/java.jar", "editor/netbeans/modules/editor.jar", "debuggercore/oldapi/netbeans/modules/autoload/openide-debugger.jar", "openide/compiler/netbeans/modules/autoload/openide-compiler.jar", "libs/regexp/netbeans/modules/autoload/nb-regexp-wrapper.jar", "libs/regexp/netbeans/modules/autoload/ext/regexp-1.2.jar", "core/execution/netbeans/modules/autoload/core-execution.jar", "core/compiler/netbeans/modules/autoload/core-compiler.jar", "core/output/netbeans/modules/autoload/core-output.jar", "core/term/netbeans/modules/autoload/terminalemulator.jar"};
        File[] cpf = new File[cp.length];
        for (int i = 0; i < cp.length; ++i) {
            File f = this.nbroot;
            StringTokenizer tok = new StringTokenizer(cp[i], "/");
            while (tok.hasMoreTokens()) {
                f = new File(f, tok.nextToken());
            }
            if (!f.isFile()) {
                throw new BuildException("No such file for classpath: " + f);
            }
            cpf[i] = f;
        }
        this.log("Classpath to load StandaloneJCDBCreator: " + Arrays.asList(cpf), 3);
        return cpf;
    }

    private static boolean newer(File f, long t) {
        if (f.isFile()) {
            return f.lastModified() >= t;
        }
        if (f.isDirectory()) {
            File[] kids = f.listFiles(new FileFilter(){

                public boolean accept(File test) {
                    return test.isDirectory() || test.getName().endsWith(".java");
                }
            });
            for (int i = 0; i < kids.length; ++i) {
                if (!MakeParserDB.newer(kids[i], t)) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException(f.toString());
    }

    static {
        levels.put("public-and-protected", "2");
        levels.put("all", "0");
        levels.put("not-private", "1");
        levels.put("public", "3");
    }

    public static class Level
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"public-and-protected", "all", "not-private", "public"};
        }
    }
}

