/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class NbPatchClass
extends MatchingTask {
    private Path patchPath;
    private String patchClass = "org.netbeans.PatchByteCode";
    private String patchMethod = "patch";
    private File targetdir;
    private Vector filesets = new Vector();
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;

    public Path createClasspath() {
        if (this.patchPath == null) {
            this.patchPath = new Path(this.getProject());
        }
        return this.patchPath.createPath();
    }

    public void setPatchClass(String f) {
        this.patchClass = f;
    }

    public void setPatchMethod(String f) {
        this.patchMethod = f;
    }

    public void setSource(File f) {
        if (f.exists()) {
            this.log("Adding source file " + f.getAbsolutePath(), 3);
            FileSet xfs = new FileSet();
            xfs.setDir(f.getParentFile());
            this.log("Setting FileSet's dir to \"" + f.getParentFile().getAbsolutePath() + "\"", 4);
            xfs.setIncludes(f.getName());
            this.log("Setting FileSet's include to \"" + f.getName() + "\"", 4);
            DirectoryScanner ds = xfs.getDirectoryScanner(this.project);
            String[] files = ds.getIncludedFiles();
            if (files.length < 1) {
                this.log("FileSet is empty, source doesn't doesn't exist (" + f.getParentFile().getAbsolutePath() + ")", 3);
            } else {
                this.log("Adding FileSet with " + files.length + " file(s)", 3);
                this.addFileset(xfs);
            }
        }
    }

    public void setTargetdir(File f) {
        this.targetdir = f;
    }

    public void addFileset(FileSet set) {
        this.log("Adding new FileSet", 4);
        this.filesets.addElement(set);
    }

    public void execute() throws BuildException {
        Method m;
        if (this.targetdir == null) {
            throw new BuildException("Attribute targetdir must be specified");
        }
        boolean fs_empty = true;
        for (int i = 0; i < this.filesets.size() && fs_empty; ++i) {
            FileSet n = (FileSet)this.filesets.elementAt(i);
            if (n == null) continue;
            DirectoryScanner ds = n.getDirectoryScanner(this.project);
            String[] files = ds.getIncludedFiles();
            File bdir = ds.getBasedir();
            if (files.length < 1) {
                this.log("FileSet is empty, doesn't have included files", 3);
            }
            for (int k = 0; k < files.length && fs_empty; ++k) {
                File n_file = new File(bdir, files[k]);
                if (!n_file.exists()) continue;
                fs_empty = false;
            }
        }
        if (fs_empty) {
            throw new BuildException("Attribute \"source\" or fileset includes must be specified");
        }
        this.log("Initializing patching " + this.patchClass + '.' + this.patchMethod);
        AntClassLoader cl = new AntClassLoader(this.getProject(), this.patchPath);
        try {
            Class<?> c = cl.loadClass(this.patchClass);
            m = c.getMethod(this.patchMethod, array$B == null ? (array$B = NbPatchClass.class$("[B")) : array$B, class$java$lang$String == null ? (class$java$lang$String = NbPatchClass.class$("java.lang.String")) : class$java$lang$String);
            if (m.getReturnType() != (array$B == null ? (array$B = NbPatchClass.class$("[B")) : array$B)) {
                throw new BuildException("Method does not return byte[]: " + m);
            }
        }
        catch (Exception ex) {
            throw new BuildException("Cannot initialize class " + this.patchClass + " and method " + this.patchMethod, (Throwable)ex);
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet n = (FileSet)this.filesets.elementAt(i);
            if (n == null) continue;
            DirectoryScanner ds = n.getDirectoryScanner(this.project);
            String[] files = ds.getIncludedFiles();
            File bdir = ds.getBasedir();
            for (int k = 0; k < files.length; ++k) {
                JarFile jar;
                File n_file = new File(bdir, files[k]);
                this.log("Checking classes in jarfile " + n_file, 3);
                try {
                    jar = new JarFile(n_file);
                }
                catch (IOException ex) {
                    throw new BuildException("Problem initializing file " + n_file, (Throwable)ex);
                }
                Enumeration<JarEntry> it = jar.entries();
                while (it.hasMoreElements()) {
                    byte[] out;
                    JarEntry e = it.nextElement();
                    String entryname = e.getName();
                    if (!entryname.endsWith(".class")) {
                        this.log("Skipping record (probably directory or resource) " + entryname, 4);
                        continue;
                    }
                    String name = entryname.substring(0, entryname.length() - 6).replace('/', '.');
                    int size = (int)e.getSize();
                    if (size <= 4) {
                        this.log("Class " + name + " is not an interesting entry (<5 bytes)", 4);
                        continue;
                    }
                    this.log("Checking class " + name, 4);
                    byte[] arr = new byte[size];
                    try {
                        int read;
                        InputStream is = jar.getInputStream(e);
                        for (int indx = 0; indx < arr.length; indx += read) {
                            read = is.read(arr, indx, arr.length - indx);
                            if (read != -1) continue;
                            throw new BuildException("Entry: " + name + " size should be: " + size + " but was read just: " + indx);
                        }
                    }
                    catch (IOException ex) {
                        throw new BuildException((Throwable)ex);
                    }
                    byte[] original = (byte[])arr.clone();
                    try {
                        out = (byte[])m.invoke(null, arr, name);
                    }
                    catch (InvocationTargetException ex) {
                        throw new BuildException(ex.getTargetException());
                    }
                    catch (Exception ex) {
                        throw new BuildException((Throwable)ex);
                    }
                    if (Arrays.equals(original, out)) {
                        this.log("Not patching class " + name, 4);
                        continue;
                    }
                    File f = new File(this.targetdir, e.getName().replace('/', File.separatorChar));
                    if (f.exists() && f.lastModified() > n_file.lastModified()) {
                        this.log("Patched class " + name + " in " + this.targetdir.getAbsolutePath() + " is newer than jarfile of origin, not saving patched bytestream to file " + f.getAbsolutePath(), 3);
                        continue;
                    }
                    f.getParentFile().mkdirs();
                    this.log("Writing patched file " + f, 2);
                    try {
                        FileOutputStream os = new FileOutputStream(f);
                        os.write(out);
                        os.close();
                    }
                    catch (IOException ex) {
                        throw new BuildException("Cannot write file " + f, (Throwable)ex);
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

