/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.Issue;
import org.netbeans.nbbuild.Issuezilla;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class PlansPreprocess
extends Task {
    private String urlBase = "http://www.netbeans.org/issues/";
    private File src;
    private File target;
    private String proxyHost;
    private int proxyPort = -1;
    private File nicknames;
    private boolean recurse = true;
    private int maxIOFailures = 5;
    private HashMap issues = new HashMap(101);
    private Properties names = new Properties();
    private boolean generateDependenciesAsLinks;
    private String proxyPool = null;
    private static final String ATTR_MODE_NAME = "mode";
    private static final int MODE_QUERIES_ONLY = 1;
    private static final int MODE_ISSUES_ONLY = 2;
    private static final int MODE_BOTH = 3;
    int mode;
    private HashMap owners;
    private HashSet components;
    private HashSet subcomponents;

    public String getUrlBase() {
        return this.urlBase;
    }

    public void setUrlBase(String urlBase) {
        this.urlBase = urlBase;
    }

    public File getSrc() {
        return this.src;
    }

    public void setSrc(File sourceFile) {
        this.src = sourceFile;
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File destination) {
        this.target = destination;
    }

    public File getNicknames() {
        return this.nicknames;
    }

    public void setNicknames(File nicknames) {
        this.nicknames = nicknames;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    public void setGenerateDependenciesAsLinks(boolean g) {
        this.generateDependenciesAsLinks = g;
    }

    public void setProxypool(String proxypool) {
        this.proxyPool = proxypool;
        this.log("The proxypool attribute is deprecated use the proxyhost and proxyport instead.", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Object previousPort;
        block37: {
            if (this.getTarget() == null) {
                throw new BuildException("Must set target");
            }
            if (this.getSrc() == null) {
                throw new BuildException("Must set target");
            }
            previousPort = null;
            Object previousHost = null;
            if (this.proxyPort != -1) {
                previousPort = System.getProperties().put("http.proxyPort", new Integer(this.proxyPort).toString());
            }
            if (this.proxyHost != null) {
                previousHost = System.getProperties().put("http.proxyHost", this.proxyHost);
            }
            this.log("Reading: " + this.getSrc());
            try {
                try {
                    int i;
                    Node node;
                    Issuezilla iz = new Issuezilla(new URL(this.getUrlBase()));
                    if (this.proxyPool != null) {
                        iz.setProxyPool(this.proxyPool);
                    }
                    this.log("Searching for issue references");
                    Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.getSrc());
                    NamedNodeMap attrsM = dom.getElementsByTagName("module-requirements").item(0).getAttributes();
                    Node attrMode = attrsM.getNamedItem(ATTR_MODE_NAME);
                    this.mode = attrMode != null && "queries-only".equals(attrMode.getNodeValue()) ? 1 : (attrMode != null && "queries-and-issues".equals(attrMode.getNodeValue()) ? 3 : 2);
                    if (this.mode == 2) {
                        Node node2;
                        ArrayList<Node> toRemove = new ArrayList<Node>();
                        NodeList list = dom.getElementsByTagName("requirement");
                        int size = list.getLength();
                        for (int i2 = 0; i2 < size; ++i2) {
                            node2 = list.item(i2);
                            NamedNodeMap attrs = node2.getAttributes();
                            Node attrQuery = attrs.getNamedItem("query");
                            if (attrQuery == null) continue;
                            toRemove.add(node2);
                        }
                        Iterator i3 = toRemove.iterator();
                        while (i3.hasNext()) {
                            node2 = (Node)i3.next();
                            node2.getParentNode().removeChild(node2);
                        }
                    } else {
                        Set issuesFromQ = this.fillIssuesByQueries(dom, iz);
                        if (this.mode == 1) {
                            ArrayList<Node> toRemove = new ArrayList<Node>();
                            NodeList list = dom.getElementsByTagName("requirement");
                            int size = list.getLength();
                            for (int i4 = 0; i4 < size; ++i4) {
                                node = list.item(i4);
                                int issue = this.getIssueNumber(node);
                                if (issuesFromQ.contains(new Integer(issue))) continue;
                                toRemove.add(node);
                            }
                            Iterator i5 = toRemove.iterator();
                            while (i5.hasNext()) {
                                node = (Node)i5.next();
                                node.getParentNode().removeChild(node);
                            }
                        }
                    }
                    NodeList list = dom.getElementsByTagName("requirement");
                    ArrayList<Node> nodes = new ArrayList<Node>();
                    ArrayList<String> numbers = new ArrayList<String>();
                    int size = list.getLength();
                    for (int i6 = 0; i6 < size; ++i6) {
                        node = list.item(i6);
                        NamedNodeMap attrs = node.getAttributes();
                        Node issueNode = attrs.getNamedItem("issue");
                        if (null == issueNode) continue;
                        nodes.add(node);
                        numbers.add(issueNode.getNodeValue());
                    }
                    this.components = new HashSet();
                    this.subcomponents = new HashSet();
                    this.owners = new HashMap();
                    if (numbers.size() > 0) {
                        String previousModule = "";
                        this.log("Retrieving issues " + numbers + " from " + this.getUrlBase());
                        Issue[] issues = this.findIssues(iz, numbers.toArray(new String[0]));
                        if (issues.length != nodes.size()) {
                            throw new BuildException("Error: issues = " + issues.length + " requested: " + nodes.size());
                        }
                        this.log("Updating the issues");
                        if (this.getNicknames() != null) {
                            FileInputStream is = new FileInputStream(this.getNicknames());
                            this.names.load(is);
                            ((InputStream)is).close();
                        }
                        for (int i7 = 0; i7 < issues.length; ++i7) {
                            String mod;
                            Node node3 = (Node)nodes.get(i7);
                            Issue issue = issues[i7];
                            Node parent = node3.getParentNode();
                            if (parent != null && parent.getNodeName().equals("module-requirements") && (mod = parent.getAttributes().getNamedItem("name").getNodeValue()) != null && !previousModule.equals(mod)) {
                                this.log("Processing module: " + mod);
                                previousModule = mod;
                            }
                            this.fillRequirement(iz, dom, issue, node3, new HashSet());
                        }
                        this.log("Writing result to " + this.getTarget());
                    } else {
                        this.log("No issues to synchronize. Copying file to " + this.getTarget());
                    }
                    Element componentsNode = dom.createElement("components");
                    Iterator<Object> it = this.components.iterator();
                    while (it.hasNext()) {
                        componentsNode.appendChild(PlansPreprocess.createComponent(dom, false, (String)it.next()));
                    }
                    it = this.subcomponents.iterator();
                    while (it.hasNext()) {
                        componentsNode.appendChild(PlansPreprocess.createComponent(dom, true, (String)it.next()));
                    }
                    dom.getDocumentElement().appendChild(componentsNode);
                    Element ownersNode = dom.createElement("owners");
                    it = this.owners.keySet().iterator();
                    while (it.hasNext()) {
                        String email = (String)it.next();
                        String name = (String)this.owners.get(email);
                        Element owner = dom.createElement("owner");
                        owner.setAttribute("nickname", name);
                        owner.setAttribute("e-mail", email);
                        ownersNode.appendChild(owner);
                    }
                    dom.getDocumentElement().appendChild(ownersNode);
                    dom.getDocumentElement().appendChild(ownersNode);
                    Element otherNode = dom.createElement("other");
                    Element todayNode = dom.createElement("today");
                    todayNode.setAttribute("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
                    Calendar cal = Calendar.getInstance();
                    cal.set(7, 2);
                    todayNode.setAttribute("thisweek", new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime()));
                    cal.add(5, 7);
                    todayNode.setAttribute("nextweek", new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime()));
                    otherNode.appendChild(todayNode);
                    cal.add(5, -14);
                    todayNode.setAttribute("lastweek", new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime()));
                    dom.getDocumentElement().appendChild(otherNode);
                    HashMap existing = new HashMap();
                    list = dom.getElementsByTagName("module-requirements");
                    size = list.getLength();
                    for (i = 0; i < size; ++i) {
                        Node module = list.item(i);
                        NodeList topReqs = module.getChildNodes();
                        int l2 = topReqs.getLength();
                        for (int j = 0; j < l2; ++j) {
                            Node req = topReqs.item(j);
                            if (!req.getNodeName().equals("requirement")) continue;
                            this.addAppearance(req, existing, dom);
                        }
                    }
                    list = dom.getElementsByTagName("requirement");
                    size = list.getLength();
                    for (i = 0; i < size; ++i) {
                        Node node4 = list.item(i);
                        this.addAppearance(node4, existing, dom);
                    }
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.getTarget()));
                    try {
                        XMLUtil.write(dom, os);
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                    Object var26_41 = null;
                    if (previousHost == null) break block37;
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
                catch (SAXException ex) {
                    throw new BuildException((Throwable)ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                Object var26_42 = null;
                if (previousHost != null) {
                    System.setProperty("http.proxyHost", (String)previousHost);
                }
                if (previousPort == null) throw throwable;
                System.setProperty("http.proxy", (String)previousPort);
                throw throwable;
            }
            System.setProperty("http.proxyHost", (String)previousHost);
        }
        if (previousPort == null) return;
        System.setProperty("http.proxy", (String)previousPort);
    }

    private Node findRequirement(Document dom, int number) {
        NodeList list = dom.getElementsByTagName("requirement");
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node req = list.item(i);
            if (this.getIssueNumber(req) != number) continue;
            return req;
        }
        return null;
    }

    private int getIssueNumber(Node n) {
        NamedNodeMap attrs = n.getAttributes();
        Node attrIssue = attrs.getNamedItem("issue");
        if (attrIssue != null) {
            try {
                return Integer.parseInt(attrIssue.getNodeValue());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return -1;
    }

    private Set fillIssuesByQueries(Document dom, Issuezilla iz) throws IOException, SAXException {
        ArrayList<Node> toRemove = new ArrayList<Node>();
        NodeList list = dom.getElementsByTagName("requirement");
        int size = list.getLength();
        HashSet<Integer> issuesFromQueries = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            Node req = list.item(i);
            NamedNodeMap attrs = req.getAttributes();
            Node attrQuery = attrs.getNamedItem("query");
            if (attrQuery == null) continue;
            this.log("Processing query " + attrQuery.getNodeValue() + " ...");
            int[] n = iz.query(attrQuery.getNodeValue());
            for (int j = 0; j < n.length; ++j) {
                Node r = this.findRequirement(dom, n[j]);
                if (r == null) {
                    this.log("Adding issue " + n[j] + " from query ...");
                    r = dom.createElement("requirement");
                    req.getParentNode().appendChild(r);
                    this.fillMissingAttribute(dom, String.valueOf(n[j]), r.getAttributes(), "issue");
                }
                issuesFromQueries.add(new Integer(n[j]));
            }
            toRemove.add(req);
        }
        Iterator i = toRemove.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            node.getParentNode().removeChild(node);
        }
        return issuesFromQueries;
    }

    void addAppearance(Node node, HashMap existing, Document dom) {
        int assign;
        NamedNodeMap attrs = node.getAttributes();
        Node issueNode = attrs.getNamedItem("issue");
        if (issueNode == null) {
            return;
        }
        Node appearanceNode = attrs.getNamedItem("appearance");
        if (appearanceNode != null) {
            return;
        }
        Integer n = Integer.valueOf(issueNode.getNodeValue());
        int[] cnt = (int[])existing.get(n);
        if (cnt == null) {
            assign = 1;
            existing.put(n, new int[]{1});
        } else {
            assign = cnt[0] = cnt[0] + 1;
        }
        Attr a = dom.createAttribute("appearance");
        a.setNodeValue(String.valueOf(assign));
        attrs.setNamedItem(a);
    }

    private void fillRequirement(Issuezilla iz, Document dom, Issue issue, Node node, HashSet alreadyProcessed) throws SAXException, IOException {
        NamedNodeMap attrs = node.getAttributes();
        this.fillMissingAttribute(dom, issue.getTargetMilestone(), attrs, "target");
        this.fillMissingAttribute(dom, String.valueOf(issue.getPriority()), attrs, "issue-priority");
        this.fillMissingAttribute(dom, issue.getType(), attrs, "issue-type");
        this.fillMissingAttribute(dom, this.mapPriority(issue.getPriority()), attrs, "priority");
        this.fillPercentageComplete(iz, dom, node, issue);
        this.fillMissingAttribute(dom, issue.getSummary(), attrs, "name");
        this.fillMissingAttribute(dom, String.valueOf(issue.getVotes()), attrs, "votes");
        this.fillMissingAttribute(dom, String.valueOf(issue.getKeywords()), attrs, "keywords");
        this.fillMissingAttribute(dom, this.mapUserImpact(issue.getType()), attrs, "user-impact");
        this.fillMissingAttribute(dom, issue.getDuration(), attrs, "duration");
        String comp = String.valueOf(issue.getComponent());
        this.components.add(comp);
        String sub = String.valueOf(issue.getSubcomponent());
        this.subcomponents.add(sub);
        this.fillMissingAttribute(dom, comp, attrs, "component");
        this.fillMissingAttribute(dom, sub, attrs, "subcomponent");
        PlansPreprocess.checkPersons(dom, issue, node, this.names, this.owners);
        this.checkRequirements(iz, dom, issue, node, alreadyProcessed);
        PlansPreprocess.checkLongDescription(dom, issue, node);
    }

    private void fillPercentageComplete(Issuezilla iz, Document dom, Node node, Issue issue) throws SAXException, IOException {
        NamedNodeMap attrs = node.getAttributes();
        Attr percentAttr = (Attr)attrs.getNamedItem("percentage-complete");
        String percent = this.mapPercentage(iz, issue);
        if (percentAttr != null && "100".equals(percent)) {
            percentAttr.setValue(percent);
        } else {
            this.fillMissingAttribute(dom, this.mapPercentage(iz, issue), attrs, "percentage-complete");
        }
    }

    private void checkRequirements(Issuezilla iz, Document dom, Issue issue, Node node, HashSet alreadyProcessed) throws SAXException, IOException {
        Node n;
        int i;
        if (!alreadyProcessed.add(issue)) {
            return;
        }
        if (!this.recurse) {
            return;
        }
        int[] deps = issue.getDependsOn();
        if (deps == null || deps.length == 0) {
            return;
        }
        if (this.generateDependenciesAsLinks) {
            TreeSet set = new TreeSet();
            this.addDependencies(iz, issue, set);
            set.remove(issue);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Issue d = (Issue)it.next();
                Element link = dom.createElement("req-link");
                link.setAttribute("href", this.urlBase + "show_bug.cgi?id=" + d.getId());
                link.appendChild(dom.createTextNode(d.getSummary() + " (" + PlansPreprocess.mapFinished(d) + ")"));
                node.appendChild(link);
            }
        }
        Node subreq = null;
        HashSet<Integer> issues = new HashSet<Integer>();
        NodeList list = node.getChildNodes();
        int len = list.getLength();
        for (i = 0; i < len; ++i) {
            n = list.item(i);
            if (!n.getNodeName().equals("requirements") || !(n instanceof Element)) continue;
            subreq = (Element)n;
            break;
        }
        if (subreq == null) {
            subreq = dom.createElement("requirements");
            node.appendChild(subreq);
        } else {
            list = subreq.getChildNodes();
            len = list.getLength();
            for (i = 0; i < len; ++i) {
                String number;
                Node numbnode;
                n = list.item(i);
                if (!n.getNodeName().equals("requirement") || (numbnode = n.getAttributes().getNamedItem("issue")) == null || (number = numbnode.getNodeValue()) == null) continue;
                issues.add(Integer.valueOf(number));
            }
        }
        for (int i2 = 0; i2 < deps.length; ++i2) {
            Integer number = new Integer(deps[i2]);
            if (issues.contains(number)) continue;
            Issue one = this.findIssue(iz, deps[i2]);
            Element req = dom.createElement("requirement");
            req.setAttribute("issue", number.toString());
            if (this.mode == 1) {
                req.setAttribute("appearance", "2");
            }
            this.fillRequirement(iz, dom, one, req, alreadyProcessed);
            subreq.appendChild(req);
        }
    }

    private static void checkLongDescription(Document dom, Issue issue, Node node) throws IOException {
        if (issue.getDescriptions().length == 0) {
            return;
        }
        Issue.Description text = issue.getDescriptions()[0];
        if ("".equals(text.getBody())) {
            return;
        }
        NodeList list = node.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = list.item(i);
            if (!n.getNodeName().equals("long-description")) continue;
            return;
        }
        StringBuffer buf = new StringBuffer(1024);
        BufferedReader r = new BufferedReader(new StringReader(text.getBody()));
        Element body = dom.createElement("body");
        while (true) {
            String line;
            if ((line = r.readLine()) != null) {
                int i = 0;
                while (i < line.length()) {
                    int j = line.indexOf(32, i);
                    if (j == -1) {
                        j = line.length();
                    }
                    if (j - i > 100) {
                        line = line.substring(0, i + 100) + "\n" + line.substring(i + 100);
                        i += 100;
                        continue;
                    }
                    i = j + 1;
                }
            }
            if (line == null || line.length() == 0) {
                Element p = dom.createElement("P");
                p.appendChild(dom.createTextNode(buf.toString()));
                body.appendChild(p);
                buf.setLength(0);
            }
            if (line == null) break;
            if (line.length() <= 0) continue;
            buf.append(line);
            buf.append("\n");
        }
        Element desc = dom.createElement("long-description");
        desc.appendChild(body);
        node.appendChild(desc);
    }

    private static void checkPersons(Document dom, Issue issue, Node node, Properties names, HashMap owners) {
        Element el = (Element)node;
        NodeList list = el.getElementsByTagName("roles");
        if (list.getLength() > 0) {
            Element roles = (Element)list.item(0);
            if (roles.getParentNode() == el) {
                NodeList rlist = roles.getElementsByTagName("e-mail");
                for (int i = 0; i < rlist.getLength(); ++i) {
                    Element email = (Element)rlist.item(i);
                    try {
                        String assigned;
                        NodeList tnodes = email.getChildNodes();
                        if (tnodes.getLength() <= 0 || tnodes.item(0).toString().length() <= 0 || owners.containsKey(assigned = tnodes.item(0).toString())) continue;
                        owners.put(assigned, PlansPreprocess.findNickname(assigned, names));
                        continue;
                    }
                    catch (DOMException ex) {
                        // empty catch block
                    }
                }
            }
            return;
        }
        Element roles = dom.createElement("roles");
        roles.appendChild(PlansPreprocess.createPerson(dom, issue.getAssignedTo(), "responsible", names));
        roles.appendChild(PlansPreprocess.createPerson(dom, issue.getReportedBy(), "initiator", names));
        owners.put(issue.getAssignedTo(), PlansPreprocess.findNickname(issue.getAssignedTo(), names));
        String[] supervisors = issue.getObservedBy();
        for (int i = 0; i < supervisors.length; ++i) {
            roles.appendChild(PlansPreprocess.createPerson(dom, supervisors[i], "consultant", names));
        }
        node.appendChild(roles);
    }

    private static Element createPerson(Document dom, String email, String roleName, Properties names) {
        Element person = dom.createElement("person");
        String nick = PlansPreprocess.findNickname(email, names);
        person.setAttribute("nickname", nick);
        Element mail = dom.createElement("e-mail");
        mail.appendChild(dom.createTextNode(email));
        Element role = dom.createElement("role");
        role.setAttribute("name", roleName);
        person.appendChild(mail);
        person.appendChild(role);
        return person;
    }

    private static Element createComponent(Document dom, boolean subcomponent, String name) {
        Element component = dom.createElement(subcomponent ? "subcomponent" : "component");
        component.setAttribute("name", name);
        return component;
    }

    private void fillMissingAttribute(Document dom, String value, NamedNodeMap attrs, String name) {
        if (attrs.getNamedItem(name) == null) {
            Attr a = dom.createAttribute(name);
            a.setValue(value);
            attrs.setNamedItem(a);
        }
    }

    private String mapUserImpact(String type) {
        if ("FEATURE".equals(type)) {
            return "high";
        }
        if ("ENHANCEMENT".equals(type)) {
            return "low";
        }
        return "medium";
    }

    private String mapPercentage(Issuezilla iz, Issue issue) throws SAXException, IOException {
        HashSet allIssues = new HashSet();
        int cnt = this.countFinished(iz, issue, allIssues);
        int done = allIssues.size();
        if (PlansPreprocess.isFinished(issue)) {
            return "100";
        }
        return cnt + " of " + allIssues.size();
    }

    private int countFinished(Issuezilla iz, Issue issue, HashSet set) throws SAXException, IOException {
        this.addDependencies(iz, issue, set);
        int sum = 0;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Issue d = (Issue)it.next();
            if (!PlansPreprocess.isFinished(d)) continue;
            ++sum;
        }
        return sum;
    }

    private void addDependencies(Issuezilla iz, Issue issue, Set set) throws SAXException, IOException {
        if (set.contains(issue)) {
            return;
        }
        set.add(issue);
        if (!this.recurse) {
            return;
        }
        int[] deps = issue.getDependsOn();
        for (int i = 0; i < deps.length; ++i) {
            Issue d = this.findIssue(iz, deps[i]);
            this.addDependencies(iz, d, set);
        }
    }

    private static String mapFinished(Issue issue) {
        if (PlansPreprocess.isFinished(issue)) {
            return "Done";
        }
        return issue.getStatus().toLowerCase();
    }

    private static boolean isFinished(Issue issue) {
        if ("RESOLVED".equals(issue.getStatus())) {
            return true;
        }
        if ("VERIFIED".equals(issue.getStatus())) {
            return true;
        }
        return "CLOSED".equals(issue.getStatus());
    }

    private String mapPriority(int priority) {
        String propName = "issue.priority." + priority;
        String value = this.getProject().getProperty(propName);
        if (value != null) {
            return value;
        }
        if (priority == 1) {
            return "high";
        }
        if (priority == 2) {
            return "medium";
        }
        return "small";
    }

    private Issue[] findIssues(Issuezilla iz, String[] name) throws SAXException, IOException {
        int[] numbers = new int[name.length];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = Integer.parseInt(name[i]);
        }
        Issue[] arr = iz.getBugs(numbers);
        for (int i = 0; i < numbers.length; ++i) {
            this.issues.put(new Integer(numbers[i]), arr[i]);
        }
        return arr;
    }

    private Issue findIssue(Issuezilla iz, int number) throws SAXException, IOException {
        Integer integer = new Integer(number);
        Issue i = (Issue)this.issues.get(integer);
        if (i != null) {
            return i;
        }
        this.log("Retrieving issue " + number);
        i = iz.getBug(number);
        this.issues.put(integer, i);
        return i;
    }

    private static String findNickname(String email, Properties nicks) {
        String value = nicks.getProperty(email);
        if (value != null) {
            return value;
        }
        int zav = email.indexOf(64);
        if (zav != -1) {
            String plain = email.substring(0, zav);
            value = nicks.getProperty(plain);
            if (value != null) {
                return value;
            }
            return plain;
        }
        return email;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        if ("".equals(proxyHost)) {
            proxyHost = null;
        }
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }
}

