/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.app;

import com.sun.jsfcl.app.AbstractPageBean;
import com.sun.jsfcl.app.PageBeanMapper;
import com.sun.jsfcl.app.PageBeanMapperImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.LifecycleFactory;

public class ViewHandlerImpl
extends ViewHandler
implements PhaseListener {
    private ViewHandler handler = null;
    private PageBeanMapper mapper = null;
    public static final String CREATED_VIEW = "com.sun.jsfcl.app.CREATED_VIEW";
    private static final String PAGE_BEAN_RENDERED = "com.sun.jsfcl.app.PAGE_BEAN_RENDERED";
    private static final String PAGE_BEANS_INITIALIZED = "com.sun.jsfcl.app.PAGE_BEANS_INITIALIZED";

    public ViewHandlerImpl(ViewHandler handler) {
        this.handler = handler;
        this.register();
    }

    public Locale calculateLocale(FacesContext context) {
        Locale locale = this.handler.calculateLocale(context);
        return locale;
    }

    public String calculateRenderKitId(FacesContext context) {
        String renderKitId = this.handler.calculateRenderKitId(context);
        return renderKitId;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot viewRoot = this.handler.createView(context, viewId);
        context.getExternalContext().getRequestMap().put(CREATED_VIEW, viewId);
        this.setupPageBean(context, viewRoot, false);
        return viewRoot;
    }

    public String getActionURL(FacesContext context, String viewId) {
        String url = this.handler.getActionURL(context, viewId);
        return url;
    }

    public String getResourceURL(FacesContext context, String path) {
        String url = this.handler.getResourceURL(context, path);
        return url;
    }

    public void renderView(FacesContext context, UIViewRoot viewRoot) throws IOException, FacesException {
        this.handler.renderView(context, viewRoot);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        UIViewRoot viewRoot = this.handler.restoreView(context, viewId);
        this.setupPageBean(context, viewRoot, true);
        return viewRoot;
    }

    public void writeState(FacesContext context) throws IOException {
        this.handler.writeState(context);
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        FacesContext context = event.getFacesContext();
        if (PhaseId.RENDER_RESPONSE.equals(phaseId)) {
            this.beforeRenderResponse(context);
        }
    }

    public void afterPhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        FacesContext context = event.getFacesContext();
        if (PhaseId.RESTORE_VIEW.equals(phaseId)) {
            this.afterRestoreView(context);
        } else if (PhaseId.RENDER_RESPONSE.equals(phaseId) || context.getResponseComplete()) {
            this.destroy(context);
        }
    }

    private void afterRestoreView(FacesContext context) {
        Map map = context.getExternalContext().getRequestMap();
        List list = (List)map.get(PAGE_BEANS_INITIALIZED);
        if (list == null) {
            return;
        }
        Iterator beans = list.iterator();
        while (beans.hasNext()) {
            AbstractPageBean bean = (AbstractPageBean)beans.next();
            if (!bean.isPostBack()) continue;
            try {
                bean.preprocess();
            }
            catch (RuntimeException e) {
                context.getExternalContext().log(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void beforeRenderResponse(FacesContext context) {
        Map map = context.getExternalContext().getRequestMap();
        AbstractPageBean pageBean = (AbstractPageBean)map.get(PAGE_BEAN_RENDERED);
        if (pageBean == null) {
            return;
        }
        try {
            pageBean.prerender();
        }
        catch (RuntimeException e) {
            context.getExternalContext().log(e.getMessage(), (Throwable)e);
        }
        map.remove(PAGE_BEAN_RENDERED);
    }

    private void destroy(FacesContext context) {
        Map map = context.getExternalContext().getRequestMap();
        List list = (List)map.get(PAGE_BEANS_INITIALIZED);
        if (list == null) {
            return;
        }
        Iterator beans = list.iterator();
        while (beans.hasNext()) {
            AbstractPageBean bean = (AbstractPageBean)beans.next();
            try {
                bean.destroy();
            }
            catch (RuntimeException e) {
                context.getExternalContext().log(e.getMessage(), (Throwable)e);
            }
        }
        map.remove(PAGE_BEANS_INITIALIZED);
    }

    private PageBeanMapper getPageBeanMapper() {
        if (this.mapper == null) {
            this.mapper = new PageBeanMapperImpl();
        }
        return this.mapper;
    }

    private void register() {
        String lifecycleId = "DEFAULT";
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        factory.getLifecycle(lifecycleId).addPhaseListener((PhaseListener)this);
    }

    private void setupPageBean(FacesContext context, UIViewRoot view, boolean postBack) {
        if (view == null) {
            return;
        }
        String viewId = view.getViewId();
        String viewName = this.getPageBeanMapper().mapViewId(viewId);
        if (viewName == null) {
            return;
        }
        ValueBinding vb = context.getApplication().createValueBinding("#{" + viewName + "}");
        AbstractPageBean pageBean = null;
        try {
            pageBean = (AbstractPageBean)vb.getValue(context);
        }
        catch (ClassCastException e) {
            return;
        }
        if (pageBean == null) {
            return;
        }
        try {
            pageBean.init();
        }
        catch (RuntimeException e) {
            context.getExternalContext().log(e.getMessage(), (Throwable)e);
        }
        Map map = context.getExternalContext().getRequestMap();
        map.put(PAGE_BEAN_RENDERED, pageBean);
        ArrayList<AbstractPageBean> list = (ArrayList<AbstractPageBean>)map.get(PAGE_BEANS_INITIALIZED);
        if (list == null) {
            list = new ArrayList<AbstractPageBean>(2);
            map.put(PAGE_BEANS_INITIALIZED, list);
        }
        list.add(pageBean);
    }
}

